/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.batchtuning;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.bean.BatchParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class BatchMatrix {
    private boolean isAddPattern = true;
    private List<String> names;

    public void setAddPattern(boolean pattern) {
        this.isAddPattern = pattern;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public List<String> getNames() {
        return this.names;
    }

    public int show(ParamBean paramBean) {
        Shell shell = Display.getCurrent().getActiveShell();
        TableViewerDialog tableViewerDialog = new TableViewerDialog(shell);
        tableViewerDialog.setParamBean(paramBean);
        return tableViewerDialog.open();
    }

    protected class ContentProvider
    implements IStructuredContentProvider {
        protected ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class MyTextCellEditor
    extends TextCellEditor {
        public MyTextCellEditor(Composite parent) {
            super(parent);
        }

        public void doSetValue(Object value) {
            if (value == null) {
                return;
            }
            super.doSetValue(value);
        }
    }

    protected class TableCellModifier
    implements ICellModifier {
        private TableViewer tableViewer;
        private ParamBean paramBean;
        private List<String> columnProperties;

        public TableCellModifier(TableViewer tableViewer, List<String> columnProperties, ParamBean paramBean) {
            this.tableViewer = tableViewer;
            this.columnProperties = columnProperties;
            this.paramBean = paramBean;
        }

        private void updateParamBean(int row, int col, Object value) {
            assert (value instanceof String);
            if (StrUtil.isBlank((CharSequence)((String)value))) {
                return;
            }
            ParamBean.ValueBean valueBean = this.paramBean.getValue();
            JSONArray jsonArray = (JSONArray)valueBean.getValue();
            assert (jsonArray != null);
            Object rowObject = jsonArray.get(row);
            Object colObject = null;
            if (rowObject instanceof JSONArray) {
                JSONArray rowJsonArray = (JSONArray)rowObject;
                colObject = rowJsonArray.get(col);
                if (colObject instanceof BigDecimal) {
                    rowJsonArray.set(col, (Object)new BigDecimal((String)value));
                } else if (colObject instanceof Integer) {
                    rowJsonArray.set(col, (Object)Integer.valueOf((String)value));
                } else assert (false);
            } else {
                assert (row == 0);
                colObject = jsonArray.get(col);
                if (colObject instanceof BigDecimal) {
                    jsonArray.set(col, (Object)new BigDecimal((String)value));
                } else if (colObject instanceof Integer) {
                    jsonArray.set(col, (Object)Integer.valueOf((String)value));
                } else assert (false);
            }
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            int index = this.columnProperties.indexOf(property);
            if (element instanceof ArrayList) {
                return ((ArrayList)element).get(index);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            ArrayList rowValueArray;
            Object oldValue;
            if (StrUtil.isBlank((CharSequence)((String)value))) {
                return;
            }
            int col = this.columnProperties.indexOf(property);
            Object rowValues = ((TableItem)element).getData();
            if (rowValues instanceof ArrayList && !(oldValue = (rowValueArray = (ArrayList)rowValues).get(col)).equals(value)) {
                rowValueArray.set(col, value);
                this.tableViewer.update(rowValues, null);
            }
        }
    }

    protected class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof List) {
                List strArray = (List)element;
                if (columnIndex >= strArray.size()) {
                    return "";
                }
                return (String)strArray.get(columnIndex);
            }
            assert (false);
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    public class TableViewerDialog
    extends Dialog {
        private ParamBean paramBean;
        private Table table;
        private TableViewer tableViewer;
        private BatchParamBean batchParamBean;

        public TableViewerDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            assert (this.paramBean != null);
            Composite composite = new Composite(parent, 0);
            this.tableViewer = new TableViewer(composite, 68354);
            this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
            this.table = this.tableViewer.getTable();
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setBounds(10, 10, 300, 300);
            ParamBean.ValueBean valueBean = this.paramBean.getValue();
            int colCount = 0;
            ArrayList<String> columnProperties = new ArrayList<String>();
            if (valueBean.getColTitles() != null) {
                for (Object title : valueBean.getColTitles()) {
                    TableColumn col = new TableColumn(this.table, 0);
                    col.setWidth(100);
                    col.setText((String)title);
                    columnProperties.add((String)title);
                }
                colCount = valueBean.getColTitles().size();
            }
            ArrayList rows = new ArrayList();
            ArrayList<String> singleRow = new ArrayList<String>();
            JSONArray jsonArray = (JSONArray)valueBean.getValue();
            assert (jsonArray != null);
            for (Object object : jsonArray) {
                if (object instanceof JSONArray) {
                    JSONArray rowJsonArray = (JSONArray)object;
                    if (colCount == 0) {
                        int i = 0;
                        while (i < rowJsonArray.size()) {
                            TableColumn col = new TableColumn(this.table, 0);
                            col.setWidth(100);
                            col.setText(String.valueOf(i + 1));
                            columnProperties.add(String.valueOf(i + 1));
                            ++i;
                        }
                        colCount = rowJsonArray.size();
                    }
                    ArrayList<String> row = new ArrayList<String>();
                    for (Object rowObject : rowJsonArray) {
                        if (rowObject instanceof BigDecimal) {
                            row.add(((BigDecimal)rowObject).toString());
                            continue;
                        }
                        if (rowObject instanceof Integer) {
                            row.add(((Integer)rowObject).toString());
                            continue;
                        }
                        assert (false);
                    }
                    rows.add(row);
                    continue;
                }
                if (colCount == 0) {
                    int i = 0;
                    while (i < jsonArray.size()) {
                        TableColumn col = new TableColumn(this.table, 0);
                        col.setWidth(100);
                        col.setText(String.valueOf(i + 1));
                        columnProperties.add(String.valueOf(i + 1));
                        ++i;
                    }
                    colCount = jsonArray.size();
                }
                if (object instanceof BigDecimal) {
                    singleRow.add(((BigDecimal)object).toString());
                    continue;
                }
                if (object instanceof Integer) {
                    singleRow.add(((Integer)object).toString());
                    continue;
                }
                assert (false);
            }
            if (singleRow.size() > 0) {
                rows.add(singleRow);
            }
            CellEditor[] editors = new CellEditor[colCount];
            int i = 0;
            while (i < colCount) {
                MyTextCellEditor textEditor = new MyTextCellEditor((Composite)this.table);
                ((Text)textEditor.getControl()).addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent e) {
                        e.doit = "-.0123456789".indexOf(e.text) >= 0;
                    }
                });
                editors[i] = textEditor;
                ++i;
            }
            this.tableViewer.setColumnProperties(columnProperties.toArray(new String[colCount]));
            this.tableViewer.setCellModifier((ICellModifier)new TableCellModifier(this.tableViewer, columnProperties, this.paramBean));
            this.tableViewer.setCellEditors(editors);
            this.tableViewer.setInput(rows);
            return null;
        }

        protected void okPressed() {
            if (BatchMatrix.this.isAddPattern) {
                Shell shell = new Shell();
                InputDialog inputDialog = new InputDialog(shell, "Save as", "Save as ", "Unnamed Matrix", null);
                inputDialog.open();
                if (inputDialog.getReturnCode() == 0) {
                    BatchMatrix.this.names.add(inputDialog.getValue() == null ? "Unnamed Matrix" : inputDialog.getValue());
                    this.saveTableData();
                    super.okPressed();
                }
            } else {
                this.saveTableData();
                super.okPressed();
            }
        }

        void saveTableData() {
            ParamBean.ValueBean valueBean = this.paramBean.getValue();
            JSONArray jsonArray = (JSONArray)valueBean.getValue();
            assert (jsonArray != null);
            int rowCount = this.table.getItemCount();
            int colCount = this.table.getColumnCount();
            int row = 0;
            while (row < rowCount) {
                TableItem item = this.table.getItem(row);
                ArrayList rowValues = (ArrayList)item.getData();
                Object rowObject = jsonArray.get(row);
                int col = 0;
                while (col < colCount) {
                    String value = (String)rowValues.get(col);
                    Object colObject = null;
                    if (rowObject instanceof JSONArray) {
                        JSONArray rowJsonArray = (JSONArray)rowObject;
                        colObject = rowJsonArray.get(col);
                        if (colObject instanceof BigDecimal) {
                            rowJsonArray.set(col, (Object)new BigDecimal(value));
                        } else if (colObject instanceof Integer) {
                            rowJsonArray.set(col, (Object)Integer.valueOf(value));
                        } else assert (false);
                    } else {
                        assert (row == 0);
                        colObject = jsonArray.get(col);
                        if (colObject instanceof BigDecimal) {
                            jsonArray.set(col, (Object)new BigDecimal(value));
                        } else if (colObject instanceof Integer) {
                            jsonArray.set(col, (Object)Integer.valueOf(value));
                        } else assert (false);
                    }
                    ++col;
                }
                ++row;
            }
        }

        public ParamBean getParamBean() {
            return this.paramBean;
        }

        public Table getTable() {
            return this.table;
        }

        public TableViewer getTableViewer() {
            return this.tableViewer;
        }

        public BatchParamBean getBatchParamBean() {
            return this.batchParamBean;
        }

        public void setParamBean(ParamBean paramBean) {
            this.paramBean = paramBean;
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public void setTableViewer(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public void setBatchParamBean(BatchParamBean batchParamBean) {
            this.batchParamBean = batchParamBean;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableViewerDialog)) {
                return false;
            }
            TableViewerDialog other = (TableViewerDialog)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            ParamBean this$paramBean = this.getParamBean();
            ParamBean other$paramBean = other.getParamBean();
            if (this$paramBean == null ? other$paramBean != null : !this$paramBean.equals(other$paramBean)) {
                return false;
            }
            Table this$table = this.getTable();
            Table other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            TableViewer this$tableViewer = this.getTableViewer();
            TableViewer other$tableViewer = other.getTableViewer();
            if (this$tableViewer == null ? other$tableViewer != null : !this$tableViewer.equals(other$tableViewer)) {
                return false;
            }
            BatchParamBean this$batchParamBean = this.getBatchParamBean();
            BatchParamBean other$batchParamBean = other.getBatchParamBean();
            return !(this$batchParamBean == null ? other$batchParamBean != null : !this$batchParamBean.equals(other$batchParamBean));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableViewerDialog;
        }

        public int hashCode() {
            int result = 1;
            ParamBean $paramBean = this.getParamBean();
            result = result * 59 + ($paramBean == null ? 43 : $paramBean.hashCode());
            Table $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            TableViewer $tableViewer = this.getTableViewer();
            result = result * 59 + ($tableViewer == null ? 43 : $tableViewer.hashCode());
            BatchParamBean $batchParamBean = this.getBatchParamBean();
            result = result * 59 + ($batchParamBean == null ? 43 : $batchParamBean.hashCode());
            return result;
        }

        public String toString() {
            return "BatchMatrix.TableViewerDialog(paramBean=" + this.getParamBean() + ", table=" + this.getTable() + ", tableViewer=" + this.getTableViewer() + ", batchParamBean=" + this.getBatchParamBean() + ")";
        }
    }
}

