/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.batchtuning;

import com.verisilicon.isp.tuning.core.bean.BatchParamBean;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.core.ImageRegistry;
import com.verisilicon.isp.tuning.ui.view.batchtuning.BatchJobConfigView;
import com.verisilicon.isp.tuning.ui.view.batchtuning.BatchJobParamView;
import com.verisilicon.isp.tuning.ui.view.batchtuning.BatchWizardPage;
import com.verisilicon.isp.tuning.ui.view.batchtuning.WriteDataBaseProgress;
import com.verisilicon.isp.tuning.ui.view.group.GroupTitleView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class BatchJobView
extends BatchWizardPage {
    private TreeViewer treeViewer;
    private BatchParamBean lastSelected;
    private Composite currentComposite;
    private Group rightGroup;
    private Group leftTree;
    private List<String> supportedType = Arrays.asList("range", "toggle", "option", "matrix", "curve");
    public BatchJobConfigView batchJobConfigView = new BatchJobConfigView();
    private ProgressMonitorDialog progressDialog;
    private Button addBtn;
    public int maxItem = 5;
    public List<String> paramNameList = new ArrayList<String>();
    public List<BatchParamBean> paramBeanList = new ArrayList<BatchParamBean>();

    public BatchJobView(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    public void addBtnUpdate() {
        this.addBtn.setEnabled(this.paramBeanList.size() < this.maxItem);
    }

    private List<String> checkComplete() {
        ArrayList<String> emptyParam = new ArrayList<String>();
        for (BatchParamBean batchParamBean : this.paramBeanList) {
            if (batchParamBean.getBatchValues() != null && !batchParamBean.getBatchValues().isEmpty()) continue;
            emptyParam.add(batchParamBean.getProcessedName());
        }
        return emptyParam;
    }

    public void createControl(Composite parent) {
        this.show(parent);
    }

    @Override
    public void nextButtonClick() {
        if (this.checkComplete().size() != 0) {
            String s = "Count Cannot be 0 : ";
            for (String i : this.checkComplete()) {
                s = String.valueOf(s) + i;
                s = String.valueOf(s) + " ";
            }
            this.warningWindow(s);
            return;
        }
        map = new HashMap();
        map.put("type", this.batchJobConfigView.getOption());
        map.put("path", this.batchJobConfigView.getPath());
        map.put("num", this.batchJobConfigView.getNum().toString());
        map.put("comment", this.batchJobConfigView.getComment());
        WriteDataBaseProgress writeDataBaseProgress = new WriteDataBaseProgress(map, this.paramBeanList);
        this.progressDialog = new ProgressMonitorDialog(this.getContainer().getShell());
        try {
            this.progressDialog.run(true, true, (IRunnableWithProgress)writeDataBaseProgress);
        }
        catch (Exception e) {
            e.printStackTrace();
            ConsoleLogger.print((String)e.getMessage());
        }
        if (this.progressDialog.getProgressMonitor().isCanceled()) {
            return;
        }
        jpgImagePath = writeDataBaseProgress.getJpgImagePath();
        if (jpgImagePath == null || jpgImagePath.isEmpty()) {
            ConsoleLogger.print((String)"jpg Images not Found.");
            return;
        }
        IWizardPage page = this.getContainer().getCurrentPage().getNextPage();
        if (page == null) {
            return;
        }
        this.getContainer().showPage(page);
    }

    public void show(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        this.currentComposite = composite;
        this.leftTree = new Group(composite, 0);
        this.leftTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.leftTree.setLayout((Layout)new GridLayout(4, true));
        GroupTitleView titleView = new GroupTitleView();
        titleView.setGridData(new GridData(4, 4, false, false, 3, 1));
        titleView.show((Composite)this.leftTree, "Parameters List");
        this.leftGroupShow();
        Group configGroup = new Group(composite, 0);
        configGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        configGroup.setLayout((Layout)new GridLayout(1, true));
        GroupTitleView configTitleView = new GroupTitleView();
        configTitleView.setGridData(new GridData(4, 4, true, false, 1, 1));
        configTitleView.show((Composite)configGroup, "Configuration");
        this.batchJobConfigView.setParentPage(this);
        this.batchJobConfigView.show((Composite)configGroup);
        this.rightGroupShow();
        this.setControl((Control)composite);
    }

    private TreeNode[] getData() {
        ArrayList<TreeNode> moduleNodeArray = new ArrayList<TreeNode>();
        List moduleBeans = ModuleDataCenter.getInstance().getCurrentTemplateModuleBeans();
        for (ModuleBean moduleBean : moduleBeans) {
            TreeNode moduleNode = new TreeNode((Object)moduleBean);
            moduleNodeArray.add(moduleNode);
            ArrayList<TreeNode> groupNodeArray = new ArrayList<TreeNode>();
            for (ParamGroupBean paramGroupBean : moduleBean.getParamGroups()) {
                TreeNode groupNode = new TreeNode((Object)paramGroupBean);
                groupNodeArray.add(groupNode);
                ArrayList<TreeNode> paramNodeArray = new ArrayList<TreeNode>();
                for (ParamBean paramBean : paramGroupBean.getParams()) {
                    TreeNode paramNode = new TreeNode((Object)paramBean);
                    paramNode.setParent(groupNode);
                    paramNodeArray.add(paramNode);
                }
                groupNode.setChildren(paramNodeArray.toArray(new TreeNode[paramNodeArray.size()]));
                groupNode.setParent(moduleNode);
            }
            moduleNode.setChildren(groupNodeArray.toArray(new TreeNode[groupNodeArray.size()]));
        }
        return moduleNodeArray.toArray(new TreeNode[moduleNodeArray.size()]);
    }

    private void addParameter(TreeNode treeNode) {
        String name = "";
        ParamBean paramBean = (ParamBean)treeNode.getValue();
        this.lastSelected = new BatchParamBean();
        this.lastSelected.setOrigParamBean(paramBean);
        while (treeNode.getParent() != null) {
            treeNode = treeNode.getParent();
        }
        ModuleBean moduleBean = (ModuleBean)treeNode.getValue();
        String singleModule = moduleBean.getModuleName();
        ArrayList<String> words = new ArrayList<String>(Arrays.asList(singleModule.split(" ")));
        int size = words.size();
        if (size > 1 && this.isNumeric(words.get(size - 1)) && size > 1) {
            words.set(size - 2, String.valueOf(words.get(size - 2)) + words.get(size - 1));
            words.remove(size - 1);
        }
        if ((size = words.size()) > 1) {
            for (String word : words) {
                boolean flag = false;
                int i = 0;
                while (i < word.length()) {
                    char ch = word.charAt(i);
                    if (!flag && Character.isUpperCase(ch)) {
                        name = String.valueOf(name) + ch;
                    }
                    if (Character.isDigit(ch)) {
                        name = String.valueOf(name) + ch;
                    }
                    if (Character.isLowerCase(word.charAt(i))) {
                        flag = true;
                    }
                    ++i;
                }
            }
        } else {
            name = String.valueOf(name) + singleModule;
        }
        this.lastSelected.setProcessedName("[" + name + "]" + paramBean.getKey().toString());
    }

    private boolean isNumeric(String string) {
        int i = 0;
        while (i < string.length()) {
            if (!Character.isDigit(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void leftGroupShow() {
        this.treeViewer = new TreeViewer((Composite)this.leftTree);
        this.treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeNodeLabelProvider());
        this.treeViewer.setInput((Object)this.getData());
        GridData gridData = new GridData(4, 4, false, false, 3, 1);
        gridData.heightHint = 800;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        this.addBtn = new Button((Composite)this.leftTree, 0);
        this.addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.addBtn.setImage(ImageRegistry.getImage(ImageRegistry.BATCH_TASK_ADD));
        this.addBtnUpdate();
        this.addBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (BatchJobView.this.lastSelected == null) {
                    BatchJobView.this.warningWindow("Please Select a Valid Parameter");
                    return;
                }
                if (BatchJobView.this.paramBeanList.size() >= BatchJobView.this.maxItem) {
                    BatchJobView.this.warningWindow("The Number of Parameters Exceeds");
                    BatchJobView.this.lastSelected = null;
                    return;
                }
                if (BatchJobView.this.paramNameList.contains(BatchJobView.this.lastSelected.getProcessedName())) {
                    BatchJobView.this.warningWindow("Selected an Existed Parameter");
                    BatchJobView.this.lastSelected = null;
                    return;
                }
                if (!BatchJobView.this.supportedType.contains(BatchJobView.this.lastSelected.getOrigParamBean().getType())) {
                    BatchJobView.this.warningWindow("Unsupported type: " + BatchJobView.this.lastSelected.getOrigParamBean().getType() + " for param " + BatchJobView.this.lastSelected.getOrigParamBean().getKey());
                    return;
                }
                BatchJobView.this.paramBeanList.add(BatchJobView.this.lastSelected);
                BatchJobView.this.paramNameList.add(BatchJobView.this.lastSelected.getProcessedName());
                BatchJobView.this.addBtnUpdate();
                BatchJobView.this.lastSelected = null;
                final Display display = Display.getCurrent();
                new Thread(){

                    @Override
                    public void run() {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                BatchJobView.this.rightGroupShow();
                            }
                        });
                    }
                }.start();
            }
        });
        this.treeViewer.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                TreeNode treeNode;
                TreeItem treeItem = BatchJobView.this.treeViewer.getTree().getItem(new Point(event.x, event.y));
                if (treeItem != null && !(treeNode = (TreeNode)treeItem.getData()).hasChildren()) {
                    BatchJobView.this.addParameter(treeNode);
                }
            }
        });
        this.treeViewer.getTree().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TreeNode treeNode;
                TreeItem treeItem = BatchJobView.this.treeViewer.getTree().getItem(new Point(event.x, event.y));
                if (treeItem != null && !(treeNode = (TreeNode)treeItem.getData()).hasChildren()) {
                    BatchJobView.this.addParameter(treeNode);
                    BatchJobView.this.addBtn.notifyListeners(13, new Event());
                }
            }
        });
    }

    public void rightGroupShow() {
        if (this.rightGroup != null) {
            this.rightGroup.dispose();
        }
        this.rightGroup = new Group(this.currentComposite, 0);
        this.rightGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.rightGroup.setLayout((Layout)new GridLayout(2, true));
        GroupTitleView titleView = new GroupTitleView();
        titleView.setGridData(new GridData(4, 4, true, false, 2, 1));
        titleView.show((Composite)this.rightGroup, "Selected Parameters");
        BatchJobParamView batchJobParamView = new BatchJobParamView();
        batchJobParamView.show(this, (Composite)this.rightGroup);
        this.setPageComplete(!this.paramBeanList.isEmpty());
        this.currentComposite.layout();
        this.addBtnUpdate();
    }

    private class TreeNodeLabelProvider
    implements ILabelProvider {
        private TreeNodeLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TreeNode) {
                TreeNode node = (TreeNode)element;
                if (node.getValue() instanceof ModuleBean) {
                    ModuleBean bean = (ModuleBean)node.getValue();
                    return bean.getModuleName();
                }
                if (node.getValue() instanceof ParamGroupBean) {
                    ParamGroupBean bean = (ParamGroupBean)node.getValue();
                    return bean.getGroupName();
                }
                if (node.getValue() instanceof ParamBean) {
                    ParamBean bean = (ParamBean)node.getValue();
                    return bean.getKey();
                }
            }
            return "_";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

