/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.batchtuning;

import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import com.verisilicon.isp.tuning.ui.view.batchtuning.BatchWizardPage;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public class BatchJobConfigView {
    String[] options = new String[]{"RGB (*.ppm)", "YUV (*.yuv)"};
    private int type = 0;
    public String inputImagePath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation());
    public String rawPath = DialogSettingManager.getInstance().getCaptureSavePath();
    public String path = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation());
    public String comment = "BatchJob " + String.valueOf(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
    public int snapNum = 1;
    public String imageType = this.options[0];
    private BatchWizardPage parentPage;

    public String getPath() {
        return this.path;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public String getOption() {
        return this.imageType;
    }

    public Integer getNum() {
        return this.snapNum;
    }

    public String getComment() {
        return this.comment;
    }

    public void setParentPage(BatchWizardPage page) {
        this.parentPage = page;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void show(Composite parent) {
        Composite composite = new Composite(parent, 16);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        if (this.type == 0) {
            Composite inputCheckComposite = new Composite(composite, 0);
            GridLayout inputCheckBoxLayout = new GridLayout(3, false);
            inputCheckComposite.setLayout((Layout)inputCheckBoxLayout);
            inputCheckComposite.setLayoutData((Object)new GridData(1808));
            Button isImageInput = new Button(inputCheckComposite, 32);
            isImageInput.setText("Input Image");
            isImageInput.setLayoutData((Object)new GridData(16384, 4, true, true, 3, 1));
            Composite inputImageComposite = new Composite(composite, 0);
            GridLayout inputImageLayout = new GridLayout(3, false);
            inputImageComposite.setLayout((Layout)inputImageLayout);
            inputImageComposite.setLayoutData((Object)new GridData(1808));
            Label inputPathLabel = new Label(inputImageComposite, 0);
            inputPathLabel.setText("Input Image Path");
            inputPathLabel.setEnabled(isImageInput.getSelection());
            Text inputPath = new Text(inputImageComposite, 0);
            inputPath.setLayoutData((Object)new GridData(768));
            if (this.inputImagePath != null) {
                inputPath.setText(this.inputImagePath);
            }
            inputPath.setEditable(false);
            inputPath.setBackground(new Color(null, 255, 255, 255));
            inputPath.setEnabled(isImageInput.getSelection());
            Button browseInputPathBtn = new Button(inputImageComposite, 0);
            browseInputPathBtn.setText("Browse");
            browseInputPathBtn.setEnabled(isImageInput.getSelection());
            browseInputPathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog inputDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                    inputDialog.setText("Browse Input Image Path");
                    String inputImagePathString = inputDialog.open();
                    if (inputImagePathString != null) {
                        inputPath.setText(inputImagePathString);
                        BatchJobConfigView.this.inputImagePath = inputImagePathString;
                        BatchJobConfigView.this.parentPage.setPageComplete(!BatchJobConfigView.this.path.isEmpty() && !BatchJobConfigView.this.rawPath.isEmpty());
                    }
                }
            });
            isImageInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    inputPathLabel.setEnabled(isImageInput.getSelection());
                    inputPath.setEnabled(isImageInput.getSelection());
                    browseInputPathBtn.setEnabled(isImageInput.getSelection());
                }
            });
        }
        Composite formatComposite = new Composite(composite, 0);
        GridLayout formayLayout = new GridLayout(2, false);
        formatComposite.setLayout((Layout)formayLayout);
        formatComposite.setLayoutData((Object)new GridData(1808));
        Label formatLabel = new Label(formatComposite, 0);
        formatLabel.setText("Image Type     ");
        Combo combo = new Combo(formatComposite, 8);
        combo.setLayoutData((Object)new GridData(768));
        combo.add(this.options[0]);
        combo.add(this.options[1]);
        combo.setText(this.imageType);
        combo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                BatchJobConfigView.this.imageType = combo.getText();
            }
        });
        if (this.type == 1) {
            Composite rawPathComposite = new Composite(composite, 0);
            rawPathComposite.setLayout((Layout)new GridLayout(3, false));
            rawPathComposite.setLayoutData((Object)new GridData(1808));
            Label rawPathLabel = new Label(rawPathComposite, 0);
            rawPathLabel.setText("Raw Image Path     ");
            Text rawPathInput = new Text(rawPathComposite, 0);
            rawPathInput.setLayoutData((Object)new GridData(768));
            if (this.rawPath != null) {
                rawPathInput.setText(this.rawPath);
            }
            rawPathInput.setEditable(false);
            rawPathInput.setBackground(new Color(null, 255, 255, 255));
            Button browseRawPathBtn = new Button(rawPathComposite, 0);
            browseRawPathBtn.setText("Browse");
            browseRawPathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog rawDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                    rawDialog.setText("Browse Raw Image Path");
                    String rawPathString = rawDialog.open();
                    if (rawPathString != null) {
                        rawPathInput.setText(rawPathString);
                        BatchJobConfigView.this.rawPath = rawPathString;
                        BatchJobConfigView.this.parentPage.setPageComplete(!BatchJobConfigView.this.path.isEmpty());
                    }
                }
            });
        }
        Composite pathComposite = new Composite(composite, 0);
        pathComposite.setLayout((Layout)new GridLayout(3, false));
        pathComposite.setLayoutData((Object)new GridData(1808));
        Label pathLabel = new Label(pathComposite, 0);
        pathLabel.setText("Save Path         ");
        Text pathInput = new Text(pathComposite, 0);
        pathInput.setLayoutData((Object)new GridData(768));
        if (this.path != null) {
            pathInput.setText(this.path);
        }
        pathInput.setEditable(false);
        pathInput.setBackground(new Color(null, 255, 255, 255));
        Button browsePathBtn = new Button(pathComposite, 0);
        browsePathBtn.setText("Browse");
        browsePathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                dialog.setText("Browse Save Path");
                dialog.setFilterPath(BatchJobConfigView.this.path);
                BatchJobConfigView.this.path = dialog.open();
                pathInput.setText(BatchJobConfigView.this.path);
            }
        });
        Composite snapComposite = new Composite(composite, 0);
        snapComposite.setLayout((Layout)new GridLayout(3, false));
        snapComposite.setLayoutData((Object)new GridData(1808));
        Label snapLabel = new Label(snapComposite, 0);
        snapLabel.setText("Snapshot Num");
        Text input = new Text(snapComposite, 0);
        input.setBackground(Display.getCurrent().getSystemColor(1));
        input.setText("1");
        input.setLayoutData((Object)new GridData(768));
        Scale scale = new Scale(snapComposite, 0);
        scale.setLayoutData((Object)new GridData(768));
        scale.setMaximum(100);
        scale.setMinimum(1);
        scale.setSelection(1);
        input.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String valueStr = input.getText();
                scale.setSelection(Integer.valueOf(valueStr).intValue());
            }
        });
        scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String str = String.valueOf(scale.getSelection());
                input.setText(str);
            }
        });
        Composite commentComposite = new Composite(composite, 0);
        commentComposite.setLayout((Layout)new GridLayout(4, true));
        commentComposite.setLayoutData((Object)new GridData(1808));
        Label commentLable = new Label(commentComposite, 0);
        commentLable.setText("Comment  ");
        GridData gridData6 = new GridData(16384, 0x1000000, true, true, 1, 1);
        commentLable.setLayoutData((Object)gridData6);
        Text commentInput = new Text(commentComposite, 0);
        GridData gridData7 = new GridData(4, 0x1000000, true, true, 3, 1);
        commentInput.setBackground(Display.getCurrent().getSystemColor(1));
        commentInput.setLayoutData((Object)gridData7);
        commentInput.setText(this.comment);
        commentInput.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (commentInput.getText().isEmpty()) {
                    commentInput.setText("BatchJob" + String.valueOf(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())));
                }
            }
        });
    }
}

