/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.batchtuning;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.verisilicon.isp.tuning.core.bean.BatchParamBean;
import com.verisilicon.isp.tuning.core.dao.bean.BatchJob;
import com.verisilicon.isp.tuning.core.dao.bean.constant.BatchJobState;
import com.verisilicon.isp.tuning.core.model.BatchDataCenter;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.core.ImageRegistry;
import com.verisilicon.isp.tuning.ui.view.batchtuning.BatchJobView;
import com.verisilicon.isp.tuning.ui.view.batchtuning.BatchJobWizard;
import com.verisilicon.isp.tuning.ui.view.batchtuning.BatchResultView;
import com.verisilicon.isp.tuning.ui.view.batchtuning.WriteDataBaseProgress;
import com.verisilicon.isp.tuning.ui.view.dialog.BatchWizardDialog;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class BatchHistory {
    public void show() {
        Shell shell = Display.getCurrent().getActiveShell();
        TableViewerDialog dialog = new TableViewerDialog(shell);
        dialog.open();
    }

    protected class ContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentProvider)) {
                return false;
            }
            ContentProvider other = (ContentProvider)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentProvider;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "BatchHistory.ContentProvider()";
        }
    }

    protected class TableLabelProvider
    implements ITableLabelProvider {
        protected TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            BatchJob batchJob = (BatchJob)element;
            if (columnIndex == 0) {
                return batchJob.getId().toString();
            }
            if (columnIndex == 1) {
                return batchJob.getTaskNum().toString();
            }
            if (columnIndex == 2) {
                return BatchJobState.getNameByCode((int)batchJob.getState());
            }
            if (columnIndex == 3) {
                return batchJob.getCreateTime();
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class TableViewerDialog
    extends Dialog {
        private Table table;
        private TableViewer tableViewer;
        private int page;
        private Text pageText;
        private Button pageUpBtn;
        private Button pageDownBtn;
        private String latestPageInput;
        private Text pageInputText;
        int count;
        private PageInfo<BatchJob> pageInfo;
        private List<BatchJob> row;
        private List<Composite> buttonPanes;
        BatchDataCenter batchDataCenter;

        public TableViewerDialog(Shell parentShell) {
            super(parentShell);
            this.page = 1;
            this.latestPageInput = "";
            this.count = 25;
            this.row = new ArrayList<BatchJob>();
            this.buttonPanes = new ArrayList<Composite>();
            this.batchDataCenter = BatchDataCenter.getInstance();
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Batch History");
            Composite composite = new Composite(parent, 0);
            this.tableViewer = new TableViewer(composite, 67618);
            this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
            this.table = this.tableViewer.getTable();
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setBounds(10, 10, 780, 525);
            TableColumn newyable_1 = new TableColumn(this.table, 0);
            newyable_1.setText("Job Id");
            newyable_1.setWidth(100);
            TableColumn newyable_2 = new TableColumn(this.table, 0);
            newyable_2.setText("Task Count");
            newyable_2.setWidth(100);
            TableColumn newyable_3 = new TableColumn(this.table, 0);
            newyable_3.setText("Status");
            newyable_3.setWidth(100);
            TableColumn newyable_4 = new TableColumn(this.table, 0);
            newyable_4.setText("Create Date");
            newyable_4.setWidth(150);
            TableColumn newyable_5 = new TableColumn(this.table, 0);
            newyable_5.setText("Operation");
            newyable_5.setWidth(300);
            this.updateTable();
            Composite pageBtnsComposite = new Composite(parent, 16);
            pageBtnsComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
            pageBtnsComposite.setLayout((Layout)new GridLayout(6, true));
            this.pageUpBtn = new Button(pageBtnsComposite, 0);
            this.pageUpBtn.setImage(ImageRegistry.getImage(ImageRegistry.PAGE_UP));
            this.pageUpBtn.setLayoutData((Object)new GridData(131072, 4, true, true, 1, 1));
            this.pageText = new Text(pageBtnsComposite, 8);
            this.pageText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
            this.pageDownBtn = new Button(pageBtnsComposite, 0);
            this.pageDownBtn.setImage(ImageRegistry.getImage(ImageRegistry.PAGE_DOWN));
            this.pageDownBtn.setLayoutData((Object)new GridData(16384, 4, true, true, 1, 1));
            this.pageInputText = new Text(pageBtnsComposite, 0);
            this.pageInputText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
            this.pageInputText.setText(String.valueOf(this.page));
            this.latestPageInput = this.pageInputText.getText();
            this.pageInputText.addListener(27, e -> {
                String pageInputStr = this.pageInputText.getText();
                if (!pageInputStr.matches("-?\\d+(\\.\\d+)?")) {
                    this.pageInputText.setText(this.latestPageInput);
                    return;
                }
                int inputPage = Integer.valueOf(pageInputStr);
                if (inputPage > this.pageInfo.getPages()) {
                    inputPage = this.pageInfo.getPages();
                }
                if (inputPage < 1) {
                    inputPage = 1;
                }
                this.pageInputText.setText(String.valueOf(inputPage));
                this.latestPageInput = this.pageInputText.getText();
            });
            Button pageJumpBtn = new Button(pageBtnsComposite, 0);
            pageJumpBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            pageJumpBtn.setText("Jump To");
            pageJumpBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewerDialog.this.page = Integer.valueOf(TableViewerDialog.this.pageInputText.getText());
                    TableViewerDialog.this.updatePageButton();
                    TableViewerDialog.this.updateTable();
                }
            });
            this.updatePageButton();
            this.pageUpBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewerDialog tableViewerDialog = TableViewerDialog.this;
                    tableViewerDialog.page = tableViewerDialog.page - 1;
                    TableViewerDialog.this.updatePageButton();
                    TableViewerDialog.this.updateTable();
                }
            });
            this.pageDownBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewerDialog tableViewerDialog = TableViewerDialog.this;
                    tableViewerDialog.page = tableViewerDialog.page + 1;
                    TableViewerDialog.this.updatePageButton();
                    TableViewerDialog.this.updateTable();
                }
            });
            this.table.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] tableItemArray = TableViewerDialog.this.table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getChecked()) {
                            item.setBackground(Display.getCurrent().getSystemColor(15));
                        } else {
                            item.setBackground(Display.getCurrent().getSystemColor(1));
                        }
                        ++n2;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return composite;
        }

        private void updatePageButton() {
            this.pageUpBtn.setEnabled(this.page > 1);
            this.pageDownBtn.setEnabled(this.page < this.pageInfo.getPages());
            this.pageText.setText(String.valueOf(this.page) + "/" + this.pageInfo.getPages());
            this.pageInputText.setText(String.valueOf(this.page));
        }

        private void updateTable() {
            this.row.clear();
            this.batchDataCenter.commit();
            PageHelper.startPage((int)this.page, (int)this.count);
            this.row = this.batchDataCenter.getAllRecords();
            this.pageInfo = new PageInfo(this.row);
            List doList = this.pageInfo.getList();
            this.tableViewer.setInput((Object)doList);
            for (Composite buttonpane : this.buttonPanes) {
                buttonpane.dispose();
            }
            this.buttonPanes.clear();
            int size = this.tableViewer.getTable().getItemCount();
            int i = 0;
            while (i < size) {
                final TableItem itemi = this.tableViewer.getTable().getItem(i);
                TableEditor editor = new TableEditor(this.tableViewer.getTable());
                editor.grabHorizontal = true;
                editor.grabVertical = true;
                Composite buttonPane = new Composite((Composite)this.table, 0);
                buttonPane.setLayout((Layout)new FillLayout());
                Button showBtn = new Button(buttonPane, 0);
                showBtn.setText("Show");
                showBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableViewerDialog.this.table.setSelection(itemi);
                        int id = ((BatchJob)TableViewerDialog.this.row.get(TableViewerDialog.this.table.getSelectionIndex())).getId();
                        Shell shell = new Shell(Display.getCurrent().getActiveShell(), 67680);
                        class ShowHistroyBatchJobWizard
                        extends BatchJobWizard {
                            private final /* synthetic */ int val$id;

                            ShowHistroyBatchJobWizard(int n) {
                                this.val$id = n;
                            }

                            @Override
                            public void addPages() {
                                BatchResultView batchResultView = new BatchResultView("batch result view");
                                batchResultView.setTitle("RESULT");
                                BatchResultView.jpgImagePath = String.valueOf((this).TableViewerDialog.this.batchDataCenter.getPathById(Integer.valueOf(this.val$id))) + "\\jpg";
                                if (!new File(BatchResultView.jpgImagePath).exists()) {
                                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"This file doesn't exist, Please confirm whether this job has been excuted!");
                                    return;
                                }
                                this.addPage((IWizardPage)batchResultView);
                            }
                        }
                        ShowHistroyBatchJobWizard batchJobWizard = new ShowHistroyBatchJobWizard(id);
                        batchJobWizard.setNeedsProgressMonitor(true);
                        BatchWizardDialog batchWizardDialog = new BatchWizardDialog(shell, (IWizard)batchJobWizard);
                        batchWizardDialog.open();
                    }
                });
                Button editBtn = new Button(buttonPane, 0);
                editBtn.setText("Edit");
                editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableViewerDialog.this.table.setSelection(itemi);
                        Shell shell = new Shell(Display.getCurrent().getActiveShell(), 67680);
                        int id = ((BatchJob)TableViewerDialog.this.row.get(TableViewerDialog.this.table.getSelectionIndex())).getId();
                        BatchJob batchJob = TableViewerDialog.this.batchDataCenter.getJobById(Integer.valueOf(id));
                        class EditHistoryBatchJobWizard
                        extends BatchJobWizard {
                            private final /* synthetic */ BatchJob val$batchJob;

                            EditHistoryBatchJobWizard(BatchJob batchJob) {
                                this.val$batchJob = batchJob;
                            }

                            @Override
                            public void addPages() {
                                BatchJobView batchJobView = new BatchJobView("batch job view");
                                batchJobView.setTitle("Edit Batch Jobs");
                                batchJobView.paramBeanList = JSONUtil.toList((String)this.val$batchJob.getVarJson().toString(), BatchParamBean.class);
                                JSONObject mapObj = JSONUtil.parseObj((Object)this.val$batchJob.getConfigJson());
                                batchJobView.batchJobConfigView.snapNum = Integer.parseInt(mapObj.getStr((Object)"num"));
                                batchJobView.batchJobConfigView.imageType = mapObj.getStr((Object)"type");
                                batchJobView.batchJobConfigView.path = mapObj.getStr((Object)"path");
                                batchJobView.batchJobConfigView.comment = mapObj.getStr((Object)"comment");
                                BatchResultView batchResultView = new BatchResultView("batch result view");
                                batchResultView.setTitle("RESULT");
                                this.addPage((IWizardPage)batchJobView);
                                this.addPage((IWizardPage)batchResultView);
                            }
                        }
                        EditHistoryBatchJobWizard batchJobWizard = new EditHistoryBatchJobWizard(batchJob);
                        BatchWizardDialog batchWizardDialog = new BatchWizardDialog(shell, (IWizard)batchJobWizard);
                        batchJobWizard.setNeedsProgressMonitor(true);
                        batchWizardDialog.open();
                        TableViewerDialog.this.updatePageButton();
                        TableViewerDialog.this.updateTable();
                    }
                });
                Button rerunBtn = new Button(buttonPane, 0);
                rerunBtn.setText("Rerun");
                rerunBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableViewerDialog.this.table.setSelection(itemi);
                        boolean isConfirmed = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm", (String)"Are you sure you want to RERUN this job?");
                        if (!isConfirmed) {
                            return;
                        }
                        Shell shell = new Shell(Display.getCurrent().getActiveShell(), 67680);
                        int id = ((BatchJob)TableViewerDialog.this.row.get(TableViewerDialog.this.table.getSelectionIndex())).getId();
                        BatchJob batchJob = TableViewerDialog.this.batchDataCenter.getJobById(Integer.valueOf(id));
                        class RerunHistoryBatchJobWizard
                        extends BatchJobWizard {
                            private final /* synthetic */ BatchJob val$batchJob;

                            RerunHistoryBatchJobWizard(BatchJob batchJob) {
                                this.val$batchJob = batchJob;
                            }

                            @Override
                            public void addPages() {
                                HashMap<String, String> map = new HashMap<String, String>();
                                JSONObject mapObj = JSONUtil.parseObj((Object)this.val$batchJob.getConfigJson());
                                String path = mapObj.getStr((Object)"path");
                                map.put("type", mapObj.getStr((Object)"type"));
                                map.put("path", path);
                                map.put("num", mapObj.getStr((Object)"num"));
                                map.put("comment", mapObj.getStr((Object)"comment"));
                                List paramBeanList = JSONUtil.toList((String)this.val$batchJob.getVarJson().toString(), BatchParamBean.class);
                                WriteDataBaseProgress writeDataBaseProgress = new WriteDataBaseProgress(map, paramBeanList);
                                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getContainer().getShell());
                                try {
                                    progressDialog.run(true, true, (IRunnableWithProgress)writeDataBaseProgress);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    ConsoleLogger.print((String)e.getMessage());
                                }
                                if (progressDialog.getProgressMonitor().isCanceled()) {
                                    return;
                                }
                                TableViewerDialog.this.updatePageButton();
                                TableViewerDialog.this.updateTable();
                                BatchResultView batchResultView = new BatchResultView("batch result view");
                                batchResultView.setTitle("RESULT");
                                BatchResultView.jpgImagePath = writeDataBaseProgress.getJpgImagePath();
                                if (BatchResultView.jpgImagePath == null) {
                                    ConsoleLogger.print((String)"Fail to Open Jpg Image Files.");
                                    return;
                                }
                                this.addPage((IWizardPage)batchResultView);
                            }
                        }
                        RerunHistoryBatchJobWizard batchJobWizard = new RerunHistoryBatchJobWizard(batchJob);
                        BatchWizardDialog batchWizardDialog = new BatchWizardDialog(shell, (IWizard)batchJobWizard);
                        batchJobWizard.setNeedsProgressMonitor(true);
                        batchWizardDialog.open();
                    }
                });
                Button copyBtn = new Button(buttonPane, 0);
                copyBtn.setText("Copy");
                copyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableViewerDialog.this.table.setSelection(itemi);
                        boolean isConfirmed = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm", (String)"Are you sure you want to COPY this job and GENERATE a new job?");
                        if (isConfirmed) {
                            int id = ((BatchJob)TableViewerDialog.this.row.get(TableViewerDialog.this.table.getSelectionIndex())).getId();
                            BatchJob batchJob = TableViewerDialog.this.batchDataCenter.getJobById(Integer.valueOf(id));
                            HashMap<String, String> map = new HashMap<String, String>();
                            JSONObject mapObj = JSONUtil.parseObj((Object)batchJob.getConfigJson());
                            String path = mapObj.getStr((Object)"path");
                            map.put("type", mapObj.getStr((Object)"type"));
                            map.put("path", path);
                            map.put("num", mapObj.getStr((Object)"num"));
                            map.put("comment", "BatchJob " + String.valueOf(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())));
                            List paramBeanList = JSONUtil.toList((String)batchJob.getVarJson().toString(), BatchParamBean.class);
                            ArrayList paramCountArray = new ArrayList();
                            paramBeanList.stream().forEach(e1 -> paramCountArray.add(e1.getBatchValues().size()));
                            BatchJob cpBatchJob = new BatchJob();
                            cpBatchJob.setComment(batchJob.getComment());
                            cpBatchJob.setConfigJson(map);
                            cpBatchJob.setBaseJson((Object)ModuleDataCenter.getInstance().getCurrentTemplateModuleBeans());
                            cpBatchJob.setVarJson((Object)paramBeanList);
                            cpBatchJob.setTaskNum(batchJob.getTaskNum());
                            TableViewerDialog.this.batchDataCenter.writeJob(cpBatchJob);
                            int currentJobId = cpBatchJob.getId();
                            if (!path.contains("_BatchJob_")) {
                                path = String.valueOf(path) + "/" + mapObj.getStr((Object)"type").substring(0, mapObj.getStr((Object)"type").indexOf(" ")) + "_BatchJob_" + String.valueOf(currentJobId);
                            }
                            map.put("path", path);
                            cpBatchJob.setConfigJson(map);
                            TableViewerDialog.this.batchDataCenter.updateBatchJob(cpBatchJob);
                            File file = new File(path);
                            if (!file.exists() && !file.mkdir()) {
                                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)("Fail to Create Directory: " + path));
                                return;
                            }
                        } else {
                            return;
                        }
                        TableViewerDialog.this.updateTable();
                        TableViewerDialog.this.updatePageButton();
                    }
                });
                this.buttonPanes.add(buttonPane);
                editor.setEditor((Control)buttonPane, itemi, 4);
                editor.layout();
                ++i;
            }
        }

        protected void okPressed() {
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    JSONObject mapObj = JSONUtil.parseObj((Object)this.batchDataCenter.getJobById(Integer.valueOf(Integer.parseInt(item.getText(0)))).getConfigJson());
                    String path = mapObj.getStr((Object)"path");
                    BatchDataCenter.getInstance().deleteFile(new File(path));
                    BatchDataCenter.getInstance().deleteJobByPrimaryKey(Integer.parseInt(item.getText(0)));
                }
                ++n2;
            }
            this.batchDataCenter.commit();
            this.updateTable();
            this.updatePageButton();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Delete", false);
        }
    }
}

