/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.core.util.ImageFormatConverter;
import com.verisilicon.isp.tuning.ui.core.ImageRegistry;
import com.verisilicon.isp.tuning.ui.view.dialog.PreviewDialog;
import com.verisilicon.tuning.core.util.transmit.buffer.BufferQueue;
import com.verisilicon.tuning.core.util.transmit.driver.tcp.TcpClient;
import com.verisilicon.tuning.core.util.transmit.output.Output;
import java.util.ArrayList;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class VideoView {
    private TcpClient tcpClient;
    private boolean isStreaming = false;
    private double rate = 1.0;
    private int startX = 0;
    private int startY = 0;
    private int endX = 0;
    private int endY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private int dx = 0;
    private int dy = 0;

    public VideoView() {
        ClientHolder clientHolder = ClientHolder.getInstance();
        this.tcpClient = ((com.verisilicon.isp.tuning.core.transfer.TcpClient)clientHolder.getClient()).getTcpClient();
    }

    public void start(String startStreamRequestString) {
        this.isStreaming = true;
        try {
            String response = this.tcpClient.request(startStreamRequestString);
            JSONArray jsonAr = JSONUtil.parseArray((String)response);
            int i = 0;
            while (i < jsonAr.size()) {
                JSONObject paramObj = jsonAr.getJSONObject((Object)i);
                String key = paramObj.getStr((Object)"key");
                String message = paramObj.getStr((Object)"message");
                if (!StrUtil.isEmpty((CharSequence)message)) {
                    ConsoleLogger.printErrorMsg((String)("WriteInputModuleData Failed: {" + key + " : " + message + "}"));
                }
                ++i;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return;
        }
        String format = PreviewDialog.getFormat();
        if (!format.startsWith("YUV")) {
            ConsoleLogger.print((String)(String.valueOf(format) + " is not support format to display."));
        }
        ArrayList<ParamBean> params = new ArrayList<ParamBean>();
        ParamBean paramBean = new ParamBean(":bufferLength", "range");
        paramBean.setCategory("OPT");
        params.add(paramBean);
        String requestString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(params, Boolean.valueOf(false));
        Integer bufferLength = 0;
        try {
            String response = this.tcpClient.request(requestString);
            JSONArray jsonArray = JSONUtil.parseArray((String)response);
            JSONObject responseObj = jsonArray.getJSONObject((Object)0);
            JSONObject valueObj = responseObj.getJSONObject((Object)"value");
            assert (valueObj != null);
            bufferLength = valueObj.getInt((Object)"current");
            assert (bufferLength != null && bufferLength != 0);
            this.tcpClient.getLogger().info("bufferLength = " + bufferLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 1232);
        shell.setSize(640, 400);
        shell.setLayout((Layout)new GridLayout(1, false));
        shell.setText("Video Viewer");
        ToolBar toolBar = new ToolBar((Composite)shell, 0);
        toolBar.setBounds(0, 0, 640, 40);
        toolBar.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolItem restoreBtn = new ToolItem(toolBar, 8);
        restoreBtn.setImage(ImageRegistry.getImage(ImageRegistry.RESET));
        ToolItem zoomInBtn = new ToolItem(toolBar, 8);
        zoomInBtn.setImage(ImageRegistry.getImage(ImageRegistry.ZOOM_IN));
        ToolItem zoomOutBtn = new ToolItem(toolBar, 8);
        zoomOutBtn.setImage(ImageRegistry.getImage(ImageRegistry.ZOOM_OUT));
        Canvas canvas = new Canvas((Composite)shell, 0x20000000);
        canvas.setBounds(0, 40, 640, 360);
        GridData canvasGridData = new GridData(4, 4, true, true, 1, 1);
        canvasGridData.grabExcessVerticalSpace = true;
        canvas.setLayoutData((Object)canvasGridData);
        shell.open();
        canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                VideoView.this.endX = e.x;
                VideoView.this.endY = e.y;
                VideoView.this.offsetX = VideoView.this.endX - VideoView.this.startX;
                VideoView.this.offsetY = VideoView.this.endY - VideoView.this.startY;
                VideoView videoView = VideoView.this;
                videoView.dx = videoView.dx + (int)((double)VideoView.this.offsetX * VideoView.this.rate);
                VideoView videoView2 = VideoView.this;
                videoView2.dy = videoView2.dy + (int)((double)VideoView.this.offsetY * VideoView.this.rate);
                canvas.redraw();
                VideoView.this.offsetX = 0;
                VideoView.this.offsetY = 0;
            }

            public void mouseDown(MouseEvent e) {
                VideoView.this.startX = e.x;
                VideoView.this.startY = e.y;
            }
        });
        shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                canvas.redraw();
            }
        });
        canvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if (e.count > 0) {
                    zoomInBtn.notifyListeners(13, new Event());
                } else if (e.count < 0) {
                    zoomOutBtn.notifyListeners(13, new Event());
                }
                canvas.redraw();
            }
        });
        restoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VideoView.this.dx = 0;
                VideoView.this.dy = 0;
                VideoView.this.rate = 1.0;
                canvas.redraw();
            }
        });
        zoomInBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                zoomOutBtn.setEnabled(true);
                VideoView videoView = VideoView.this;
                videoView.rate = videoView.rate + 0.1;
                if (VideoView.this.rate > 2.0) {
                    VideoView.this.rate = 2.0;
                    zoomInBtn.setEnabled(false);
                }
                canvas.redraw();
            }
        });
        zoomOutBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                zoomInBtn.setEnabled(true);
                VideoView videoView = VideoView.this;
                videoView.rate = videoView.rate - 0.1;
                if (VideoView.this.rate < 0.1) {
                    VideoView.this.rate = 0.1;
                    zoomOutBtn.setEnabled(false);
                }
                canvas.redraw();
            }
        });
        int bufferLen = bufferLength;
        new Thread(() -> {
            BufferQueue bufferQueue = this.tcpClient.getBufferQueue();
            bufferQueue.bufferLengthSet(bufferLen);
            this.tcpClient.setOutput(new Output(arg_0 -> ((BufferQueue)bufferQueue).outputPop(arg_0), arg_0 -> ((BufferQueue)bufferQueue).inputPush(arg_0)));
            this.tcpClient.getOutput().streamStart();
            try {
                this.tcpClient.streamStart();
            }
            catch (Exception exception) {
                shell.dispose();
                return;
            }
            int width = PreviewDialog.getWidth();
            int height = PreviewDialog.getHeight();
            while (!shell.isDisposed() && this.isStreaming) {
                try {
                    if (!this.tcpClient.isStreaming) break;
                    byte[] rgbBytes = new byte[width * height * 3];
                    byte[] getData = this.tcpClient.getOutput().getBuffer().dataGet();
                    if (getData == null) continue;
                    if (format.equals("YUV422 Semi-Planar")) {
                        if (getData.length != width * height * 2) {
                            ConsoleLogger.print((String)("Current size is : " + getData.length + " Expect size is : " + width * height * 2 + " Current image size is not correct."));
                            continue;
                        }
                        ImageFormatConverter.NV162RGB((byte[])getData, (int)width, (int)height, (byte[])rgbBytes);
                    } else if (format.equals("YUV422 Interleaved")) {
                        if (getData.length != width * height * 2) {
                            ConsoleLogger.print((String)("Current size is : " + getData.length + " Expect size is : " + width * height * 2 + " Current image size is not correct."));
                            continue;
                        }
                        ImageFormatConverter.YUV422I2RGB((byte[])getData, (int)width, (int)height, (byte[])rgbBytes);
                    } else if (format.equals("YUV420 Semi-Planar")) {
                        if (getData.length != width * height * 3 / 2) {
                            ConsoleLogger.print((String)("Current size is : " + getData.length + " Expect size is : " + width * height * 3 / 2 + " Current image size is not correct."));
                            continue;
                        }
                        ImageFormatConverter.YUV420SP2RGB((byte[])getData, (int)width, (int)height, (byte[])rgbBytes);
                    } else if (format.equals("YUV444 Planer")) {
                        if (getData.length != width * height * 3) {
                            ConsoleLogger.print((String)("Current size is : " + getData.length + " Expect size is : " + width * height * 3 + " Current image size is not correct."));
                            continue;
                        }
                        ImageFormatConverter.YUV444P2RGB((byte[])getData, (int)width, (int)height, (byte[])rgbBytes);
                    } else if (format.equals("YUV444 Interleaved")) {
                        if (getData.length != width * height * 3) {
                            ConsoleLogger.print((String)("Current size is : " + getData.length + " Expect size is : " + width * height * 3 + " Current image size is not correct."));
                            continue;
                        }
                        ImageFormatConverter.YUV444I2RGB((byte[])getData, (int)width, (int)height, (byte[])rgbBytes);
                    } else {
                        Thread.sleep(10L);
                        continue;
                    }
                    ImageData imageData = new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
                    imageData.data = rgbBytes;
                    Image image = new Image((Device)canvas.getDisplay(), imageData);
                    display.asyncExec(() -> {
                        if (!canvas.isDisposed()) {
                            GC gc = new GC((Drawable)canvas);
                            int ww = (int)((double)canvas.getShell().getBounds().width * this.rate);
                            int hh = (int)((double)canvas.getShell().getBounds().height * this.rate);
                            gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, this.dx, this.dy, ww, hh);
                            gc.dispose();
                            image.dispose();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.tcpClient.streamStop();
            this.tcpClient.getOutput().streamStop();
        }).start();
    }

    public void stop(String requestString) {
        try {
            ConsoleLogger.print((String)(" >> " + requestString));
            this.tcpClient.request(requestString);
        }
        catch (Exception e) {
            ConsoleLogger.print((String)e.getMessage());
        }
        this.isStreaming = false;
    }
}

