/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view;

import cn.hutool.core.util.StrUtil;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.bean.UndoBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.ui.core.UIPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class FeaturesView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "com.verisilicon.isp.tuning.ui.view.featuresview";
    private TreeViewer treeViewer;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeNodeLabelProvider());
        this.treeViewer.setInput((Object)this.getData());
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                TreeNode treeNode = (TreeNode)selection.getFirstElement();
                if (treeNode != null) {
                    TreeNode rootTreeNode = treeNode;
                    while (rootTreeNode.getParent() != null) {
                        rootTreeNode = rootTreeNode.getParent();
                    }
                    if (rootTreeNode.getValue() instanceof ModuleBean) {
                        ModuleBean moduleBean = (ModuleBean)rootTreeNode.getValue();
                        if (moduleBean != ModuleDataCenter.getInstance().getCurrentModuleBean()) {
                            if (!($assertionsDisabled || ((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams() != null && ((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().size() > 0)) {
                                throw new AssertionError();
                            }
                            if (((ParamBean)((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().get(0)).getKey().equals("modeSwitch")) {
                                boolean isAuto = ((ParamBean)((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().get(0)).getValue().getCurrentValue().equals("Auto Mode");
                                ModuleBean autoModuleBean = ModuleDataCenter.getInstance().getModuleBeanByShowName("Auto " + moduleBean.getShowName());
                                if (isAuto && autoModuleBean != null) {
                                    moduleBean = autoModuleBean;
                                }
                            }
                            if (moduleBean.getUndoBean() == null) {
                                moduleBean.setUndoBean(new UndoBean());
                            }
                            UIPlugin.getInstance().showDetailEditor();
                            ModuleDataCenter.getInstance().changeCurrentModule(moduleBean);
                            EventManager.getInstance().notifyEvent("EVENT_MODULE_CHANGED", (Object)moduleBean);
                        } else {
                            EventManager.getInstance().notifyEvent("EVENT_GROUP_CHANGED", null);
                        }
                    }
                    if (treeNode.getValue() instanceof ParamGroupBean) {
                        ParamGroupBean paramGroupBean = (ParamGroupBean)treeNode.getValue();
                        EventManager.getInstance().notifyEvent("EVENT_GROUP_CHANGED", (Object)paramGroupBean);
                    }
                }
            }
        });
        EventManager.getInstance().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private TreeNode[] getData() {
        ArrayList<TreeNode> moduleNodeArray = new ArrayList<TreeNode>();
        String templateName = ModuleDataCenter.getInstance().getCurrentTemplateName();
        if (StrUtil.isEmpty((CharSequence)templateName)) {
            return moduleNodeArray.toArray(new TreeNode[0]);
        }
        this.setPartName(templateName);
        List moduleBeans = ModuleDataCenter.getInstance().getCurrentTemplateModuleBeans();
        Map aMMap = ModuleDataCenter.getInstance().getAutoManualMap();
        for (ModuleBean moduleBean : moduleBeans) {
            if (moduleBean.isHide() || aMMap.keySet().contains(moduleBean.getShowName()) && aMMap.get(moduleBean.getShowName()) != null && ((ParamBean)((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().get(0)).getKey().equals("modeSwitch") && ((ParamBean)((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().get(0)).getValue().getCurrentValue() == Integer.valueOf(1) || aMMap.values().contains(moduleBean.getShowName()) && ((ParamBean)((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().get(0)).getKey().equals("modeSwitch") && ((ParamBean)((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().get(0)).getValue().getCurrentValue() == Integer.valueOf(0)) continue;
            TreeNode moduleNode = new TreeNode((Object)moduleBean);
            moduleNodeArray.add(moduleNode);
            ArrayList<TreeNode> groupNodeArray = new ArrayList<TreeNode>();
            for (ParamGroupBean paramGroupBean : moduleBean.getParamGroups()) {
                TreeNode groupNode = new TreeNode((Object)paramGroupBean);
                groupNodeArray.add(groupNode);
                groupNode.setParent(moduleNode);
            }
            moduleNode.setChildren(groupNodeArray.toArray(new TreeNode[groupNodeArray.size()]));
        }
        return moduleNodeArray.toArray(new TreeNode[moduleNodeArray.size()]);
    }

    public void setFocus() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("EVENT_TEMPLATE_CHANGED")) {
            this.treeViewer.setInput((Object)this.getData());
        }
    }

    public void dispose() {
        EventManager.getInstance().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private class TreeNodeLabelProvider
    implements ILabelProvider {
        private TreeNodeLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TreeNode) {
                TreeNode node = (TreeNode)element;
                if (node.getValue() instanceof ModuleBean) {
                    ModuleBean bean = (ModuleBean)node.getValue();
                    return bean.getLabel() != null ? bean.getLabel() : bean.getModuleName();
                }
                if (node.getValue() instanceof ParamGroupBean) {
                    ParamGroupBean bean = (ParamGroupBean)node.getValue();
                    return bean.getGroupName();
                }
                if (node.getValue() instanceof ParamBean) {
                    ParamBean bean = (ParamBean)node.getValue();
                    return bean.getKey();
                }
            }
            return "_";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

