/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view;

import cn.hutool.core.util.StrUtil;
import com.verisilicon.isp.tuning.core.algo.CallbackManager;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import com.verisilicon.isp.tuning.ui.core.ImageRegistry;
import com.verisilicon.isp.tuning.ui.core.UIPlugin;
import com.verisilicon.isp.tuning.ui.view.group.ParamGroupView;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class DetailView
extends EditorPart
implements IPropertyChangeListener {
    public static final String ID = "com.verisilicon.isp.tuning.ui.view.detailview";
    private Composite groupComposite;
    private Composite contentComposite;
    private ScrolledComposite scrolledComposite;
    private ModuleBean currentModuleBean;
    private boolean isDirty;
    private DialogSettingManager dialogSettingManager = DialogSettingManager.getInstance();
    private Button undoBtn;
    private Button redoBtn;
    private Button loadSet1Btn;
    private Button loadSet2Btn;
    private Map<String, Point> groupViewLocationMap = new HashMap<String, Point>();

    public DetailView() {
        EventManager.getInstance().addPropertyChangeListener((IPropertyChangeListener)this);
        this.isDirty = false;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setBackground(Display.getCurrent().getSystemColor(1));
        Composite toolbarComposite = new Composite(composite, 0);
        toolbarComposite.setLayout((Layout)new GridLayout(8, true));
        GridData toolbarGridData = new GridData();
        toolbarGridData.grabExcessHorizontalSpace = true;
        toolbarGridData.horizontalAlignment = 1;
        toolbarComposite.setLayoutData((Object)toolbarGridData);
        this.undoBtn = new Button(toolbarComposite, 0);
        this.undoBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.undoBtn.setImage(ImageRegistry.getImage(ImageRegistry.UNDO));
        this.undoBtn.setEnabled(false);
        this.undoBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParamBean oldValue = DetailView.this.currentModuleBean.getUndoBean().popUndoValue();
                DetailView.this.updateUndoButtonState();
                if (oldValue != null) {
                    DetailView.this.updateParamValue(oldValue);
                    if (DetailView.this.dialogSettingManager.getIsAutoWrite().booleanValue() && DetailView.this.dialogSettingManager.getIsConnected().booleanValue()) {
                        try {
                            ModuleDataCenter.getInstance().writeModuleData(DetailView.this.currentModuleBean, null, null);
                        }
                        catch (Exception ex) {
                            ConsoleLogger.print((String)("Write data failed: " + ex.getMessage()));
                        }
                    }
                }
            }
        });
        this.redoBtn = new Button(toolbarComposite, 0);
        this.redoBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.redoBtn.setImage(ImageRegistry.getImage(ImageRegistry.REDO));
        this.redoBtn.setEnabled(false);
        this.redoBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParamBean newValue = DetailView.this.currentModuleBean.getUndoBean().popRedoValue();
                DetailView.this.updateUndoButtonState();
                if (newValue != null) {
                    DetailView.this.updateParamValue(newValue);
                    if (DetailView.this.dialogSettingManager.getIsAutoWrite().booleanValue() && DetailView.this.dialogSettingManager.getIsConnected().booleanValue()) {
                        try {
                            ModuleDataCenter.getInstance().writeModuleData(DetailView.this.currentModuleBean, null, null);
                        }
                        catch (Exception ex) {
                            ConsoleLogger.print((String)("Write data failed: " + ex.getMessage()));
                        }
                    }
                }
            }
        });
        Button saveSet1Btn = new Button(toolbarComposite, 0);
        saveSet1Btn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        saveSet1Btn.setText("Save Set1");
        saveSet1Btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetailView.this.currentModuleBean.saveToSet(1);
                DetailView.this.loadSet1Btn.setEnabled(true);
            }
        });
        Button saveSet2Btn = new Button(toolbarComposite, 0);
        saveSet2Btn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        saveSet2Btn.setText("Save Set2");
        saveSet2Btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetailView.this.currentModuleBean.saveToSet(2);
                DetailView.this.loadSet2Btn.setEnabled(true);
            }
        });
        this.loadSet1Btn = new Button(toolbarComposite, 0);
        this.loadSet1Btn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.loadSet1Btn.setText("Load Set1");
        this.loadSet1Btn.setEnabled(false);
        this.loadSet1Btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetailView.this.currentModuleBean.loadFromSet(1);
                if (DetailView.this.dialogSettingManager.getIsAutoWrite().booleanValue() && DetailView.this.dialogSettingManager.getIsConnected().booleanValue()) {
                    try {
                        ModuleDataCenter.getInstance().writeModuleData(DetailView.this.currentModuleBean, null, null);
                    }
                    catch (Exception ex) {
                        ConsoleLogger.print((String)("Load Set1 failed: " + ex.getMessage()));
                    }
                }
                EventManager.getInstance().notifyEvent("EVENT_REFRESH_UI", null);
            }
        });
        this.loadSet2Btn = new Button(toolbarComposite, 0);
        this.loadSet2Btn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.loadSet2Btn.setText("Load Set2");
        this.loadSet2Btn.setEnabled(false);
        this.loadSet2Btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetailView.this.currentModuleBean.loadFromSet(2);
                if (DetailView.this.dialogSettingManager.getIsAutoWrite().booleanValue() && DetailView.this.dialogSettingManager.getIsConnected().booleanValue()) {
                    try {
                        ModuleDataCenter.getInstance().writeModuleData(DetailView.this.currentModuleBean, null, null);
                    }
                    catch (Exception ex) {
                        ConsoleLogger.print((String)("Load Set2 failed: " + ex.getMessage()));
                    }
                }
                EventManager.getInstance().notifyEvent("EVENT_REFRESH_UI", null);
            }
        });
        Button readBtn = new Button(toolbarComposite, 0);
        readBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        readBtn.setText("Read Page");
        readBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!DetailView.this.dialogSettingManager.getIsConnected().booleanValue()) {
                        return;
                    }
                    ModuleDataCenter.getInstance().readModuleData(DetailView.this.currentModuleBean);
                }
                catch (Exception ex) {
                    ConsoleLogger.print((String)("Read data failed: " + ex.getMessage()));
                    if (ex.getMessage() == "Connection failed") {
                        DetailView.this.dialogSettingManager.setIsConnected(false);
                    }
                    return;
                }
                DetailView.this.showGroups(DetailView.this.currentModuleBean);
            }
        });
        Button writeBtn = new Button(toolbarComposite, 0);
        writeBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        writeBtn.setText("Write Page");
        writeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!DetailView.this.dialogSettingManager.getIsConnected().booleanValue()) {
                        return;
                    }
                    ModuleDataCenter.getInstance().writeModuleData(DetailView.this.currentModuleBean, null, null);
                }
                catch (Exception ex) {
                    ConsoleLogger.print((String)("Write data failed: " + ex.getMessage()));
                }
            }
        });
        Composite mainComposite = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setLayout((Layout)new FillLayout());
        this.scrolledComposite = new ScrolledComposite(mainComposite, 512);
        this.contentComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setBackground(Display.getCurrent().getSystemColor(1));
        this.scrolledComposite.setContent((Control)this.contentComposite);
        this.scrolledComposite.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                DetailView.this.scrolledComposite.setFocus();
            }
        });
        this.scrolledComposite.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                int wheelCount = event.count;
                wheelCount = (int)Math.ceil((float)wheelCount / 3.0f);
                while (wheelCount < 0) {
                    DetailView.this.scrolledComposite.getVerticalBar().setIncrement(4);
                    ++wheelCount;
                }
                while (wheelCount > 0) {
                    DetailView.this.scrolledComposite.getVerticalBar().setIncrement(-4);
                    --wheelCount;
                }
            }
        });
        this.scrolledComposite.getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DetailView.this.scrolledComposite.setFocus();
            }
        });
    }

    public void showGroups(ModuleBean moduleBean) {
        this.groupViewLocationMap.clear();
        this.currentModuleBean = moduleBean;
        this.updateUndoButtonState();
        this.updateLoadSetButtonState();
        this.setPartName(moduleBean.getModuleName());
        if (this.groupComposite != null) {
            this.groupComposite.dispose();
        }
        this.groupComposite = new Composite(this.contentComposite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 20;
        gridLayout.verticalSpacing = 10;
        this.groupComposite.setBackground(Display.getCurrent().getSystemColor(1));
        this.groupComposite.setLayout((Layout)gridLayout);
        for (ParamGroupBean paramGroupBean : moduleBean.getParamGroups()) {
            Boolean editable = true;
            if (!StrUtil.isBlankIfStr((Object)paramGroupBean.getEditableWhenFalse())) {
                editable = ModuleDataCenter.getInstance().getControlValue(paramGroupBean.getEditableWhenFalse()) == false;
            } else if (!StrUtil.isBlankIfStr((Object)paramGroupBean.getEditableWhenTrue())) {
                editable = ModuleDataCenter.getInstance().getControlValue(paramGroupBean.getEditableWhenTrue());
            }
            ParamGroupView paramGroupView = new ParamGroupView();
            paramGroupView.show(this.groupComposite, paramGroupBean, this.currentModuleBean, editable);
            this.groupViewLocationMap.put(paramGroupBean.getGroupName(), paramGroupView.composite.getLocation());
        }
        this.groupComposite.pack();
        this.contentComposite.pack();
    }

    public void setFocus() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("EVENT_PROJECT_SAVED")) {
            this.isDirty = false;
            this.firePropertyChange(257);
        } else if (event.getProperty().equals("EVENT_MODULE_CHANGED")) {
            ModuleBean moduleBean;
            this.currentModuleBean = moduleBean = (ModuleBean)event.getNewValue();
            if (this.dialogSettingManager.getIsAutoRead().booleanValue() && this.dialogSettingManager.getIsConnected().booleanValue()) {
                try {
                    ModuleDataCenter.getInstance().readModuleData(this.currentModuleBean);
                }
                catch (Exception e) {
                    ConsoleLogger.printWarningMsg((String)e.getMessage());
                }
            }
            this.showGroupsAsync(this.currentModuleBean);
        } else if (event.getProperty().equals("EVENT_GROUP_CHANGED")) {
            if (event.getNewValue() == null) {
                this.contentComposite.setLocation(0, 0);
                if (this.scrolledComposite.getVerticalBar() != null) {
                    this.scrolledComposite.getVerticalBar().setSelection(0);
                }
            } else {
                ParamGroupBean paramGroupBean = (ParamGroupBean)event.getNewValue();
                Point location = this.groupViewLocationMap.get(paramGroupBean.getGroupName());
                if (location != null) {
                    this.contentComposite.setLocation(0, -location.y);
                    if (this.scrolledComposite.getVerticalBar() != null) {
                        this.scrolledComposite.getVerticalBar().setSelection(location.y);
                    }
                }
            }
        } else if (event.getProperty().equals("EVENT_REFRESH_UI")) {
            this.showGroupsAsync(this.currentModuleBean);
        } else if (event.getProperty().equals("EVENT_PARAM_VALUE_CHANGED")) {
            this.isDirty = true;
            this.firePropertyChange(257);
            ParamBean oldValue = (ParamBean)event.getOldValue();
            ParamBean newValue = (ParamBean)event.getNewValue();
            if (oldValue != null && newValue != null) {
                this.currentModuleBean.getUndoBean().pushUndoValue(oldValue, newValue);
                this.updateUndoButtonState();
            }
            if (this.dialogSettingManager.getIsAutoWrite().booleanValue() && this.dialogSettingManager.getIsConnected().booleanValue()) {
                try {
                    ModuleDataCenter.getInstance().writeModuleData(this.currentModuleBean, null, null);
                }
                catch (Exception ex) {
                    ConsoleLogger.print((String)("Write data failed: " + ex.getMessage()));
                }
            }
        }
    }

    private void showGroupsAsync(ModuleBean moduleBean) {
        Display display = Display.getCurrent();
        new Thread(){

            @Override
            public void run() {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DetailView.this.showGroups(moduleBean);
                    }
                });
            }
        }.start();
    }

    private void updateUndoButtonState() {
        if (this.currentModuleBean == null) {
            return;
        }
        int undoLength = this.currentModuleBean.getUndoBean().getUndoLength();
        this.undoBtn.setEnabled(undoLength > 0);
        int redoLength = this.currentModuleBean.getUndoBean().getRedoLength();
        this.redoBtn.setEnabled(redoLength > 0);
    }

    private void updateLoadSetButtonState() {
        if (this.currentModuleBean == null) {
            return;
        }
        this.loadSet1Btn.setEnabled(this.currentModuleBean.hasSetData(1).booleanValue());
        this.loadSet2Btn.setEnabled(this.currentModuleBean.hasSetData(2).booleanValue());
    }

    private void updateParamValue(ParamBean newValue) {
        for (ParamGroupBean paramGroupBean : this.currentModuleBean.getParamGroups()) {
            for (ParamBean paramBean : paramGroupBean.getParams()) {
                if (!newValue.getKey().equals(paramBean.getKey())) continue;
                paramBean.getValue().setCurrentValue(newValue.getValue().getValue());
                if (paramBean.getValue().getRelateCurve() != null) {
                    CallbackManager cbManager = CallbackManager.getInstance();
                    CallbackManager.processCallback((ModuleBean)this.currentModuleBean, (String)paramBean.getCategory(), (String)paramBean.getValue().getRelateCurve());
                }
                Display display = Display.getCurrent();
                new Thread(){

                    @Override
                    public void run() {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DetailView.this.showGroups(DetailView.this.currentModuleBean);
                            }
                        });
                    }
                }.start();
                return;
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        UIPlugin.getInstance().saveProjectSettings();
        this.isDirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        EventManager.getInstance().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

