/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.handler;

import com.verisilicon.isp.tuning.core.util.ImageFormatConverter;
import com.verisilicon.isp.tuning.ui.core.ImageRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TcpPreviewHandler
extends AbstractHandler {
    private double rate = 1.0;
    private int startX = 0;
    private int startY = 0;
    private int endX = 0;
    private int endY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private int dx = 0;
    private int dy = 0;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 1232);
        shell.setText("ImageReader");
        shell.setSize(640, 400);
        shell.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar((Composite)shell, 0);
        toolBar.setBounds(0, 0, 640, 40);
        toolBar.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolItem restoreBtn = new ToolItem(toolBar, 8);
        restoreBtn.setImage(ImageRegistry.getImage(ImageRegistry.RESET));
        ToolItem zoomInBtn = new ToolItem(toolBar, 8);
        zoomInBtn.setImage(ImageRegistry.getImage(ImageRegistry.ZOOM_IN));
        ToolItem zoomOutBtn = new ToolItem(toolBar, 8);
        zoomOutBtn.setImage(ImageRegistry.getImage(ImageRegistry.ZOOM_OUT));
        Canvas canvas = new Canvas((Composite)shell, 0x20000000);
        canvas.setBounds(0, 40, 640, 360);
        GridData canvasGridData = new GridData(4, 4, true, true, 1, 1);
        canvasGridData.grabExcessVerticalSpace = true;
        canvas.setLayoutData((Object)canvasGridData);
        shell.open();
        canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TcpPreviewHandler.this.endX = e.x;
                TcpPreviewHandler.this.endY = e.y;
                TcpPreviewHandler.this.offsetX = TcpPreviewHandler.this.endX - TcpPreviewHandler.this.startX;
                TcpPreviewHandler.this.offsetY = TcpPreviewHandler.this.endY - TcpPreviewHandler.this.startY;
                TcpPreviewHandler tcpPreviewHandler = TcpPreviewHandler.this;
                tcpPreviewHandler.dx = tcpPreviewHandler.dx + (int)((double)TcpPreviewHandler.this.offsetX * TcpPreviewHandler.this.rate);
                TcpPreviewHandler tcpPreviewHandler2 = TcpPreviewHandler.this;
                tcpPreviewHandler2.dy = tcpPreviewHandler2.dy + (int)((double)TcpPreviewHandler.this.offsetY * TcpPreviewHandler.this.rate);
                canvas.redraw();
                TcpPreviewHandler.this.offsetX = 0;
                TcpPreviewHandler.this.offsetY = 0;
            }

            public void mouseDown(MouseEvent e) {
                TcpPreviewHandler.this.startX = e.x;
                TcpPreviewHandler.this.startY = e.y;
            }
        });
        shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                canvas.redraw();
            }
        });
        restoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TcpPreviewHandler.this.dx = 0;
                TcpPreviewHandler.this.dy = 0;
                TcpPreviewHandler.this.rate = 1.0;
                canvas.redraw();
            }
        });
        zoomInBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                zoomOutBtn.setEnabled(true);
                TcpPreviewHandler tcpPreviewHandler = TcpPreviewHandler.this;
                tcpPreviewHandler.rate = tcpPreviewHandler.rate + 0.1;
                if (TcpPreviewHandler.this.rate > 2.0) {
                    TcpPreviewHandler.this.rate = 2.0;
                    zoomInBtn.setEnabled(false);
                }
                canvas.redraw();
            }
        });
        zoomOutBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                zoomInBtn.setEnabled(true);
                TcpPreviewHandler tcpPreviewHandler = TcpPreviewHandler.this;
                tcpPreviewHandler.rate = tcpPreviewHandler.rate - 0.1;
                if (TcpPreviewHandler.this.rate < 0.1) {
                    TcpPreviewHandler.this.rate = 0.1;
                    zoomOutBtn.setEnabled(false);
                }
                canvas.redraw();
            }
        });
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        fileDialog.setFilterNames(new String[]{"image"});
        fileDialog.setFilterExtensions(new String[]{"*.*"});
        fileDialog.setFilterPath(System.getProperty("user.dir"));
        fileDialog.setText("Open");
        String fileName = fileDialog.open();
        Path filePath = Paths.get(fileName, new String[0]);
        File file = new File(filePath.toString());
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        byte[] bytes = new byte[(int)file.length()];
        try {
            in.read(bytes);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int width = 1920;
        int height = 1080;
        new Thread(() -> {
            while (!shell.isDisposed()) {
                byte[] rgbBytes = new byte[width * height * 3];
                ImageFormatConverter.YUV444P2RGB((byte[])bytes, (int)width, (int)height, (byte[])rgbBytes);
                ImageData imageData = new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
                imageData.data = rgbBytes;
                Image image = new Image((Device)canvas.getDisplay(), imageData);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!canvas.isDisposed()) {
                            System.out.printf("update image \n", new Object[0]);
                            GC gc = new GC((Drawable)canvas);
                            int ww = (int)((double)canvas.getShell().getBounds().width * TcpPreviewHandler.this.rate);
                            int hh = (int)((double)canvas.getShell().getBounds().height * TcpPreviewHandler.this.rate);
                            gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, TcpPreviewHandler.this.dx, TcpPreviewHandler.this.dy, ww, hh);
                            gc.dispose();
                            image.dispose();
                        }
                    }
                });
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return null;
    }
}

