/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.handler;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import com.verisilicon.isp.tuning.ui.view.DetailView;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;

public class ImportHandler
extends AbstractHandler {
    private static final String BASE64_PREFIX_XML = "data:text/xml;base64,";
    private static final String BASE64_PREFIX_JSON = "data:text/json;base64,";
    private int timeout = 0;

    protected void warningWindow(String message) {
        Shell shell = new Shell();
        MessageBox mb = new MessageBox(shell, 0);
        mb.setText("Warning");
        mb.setMessage(message);
        mb.open();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.timeout = DialogSettingManager.getInstance().getServerType() == "UART" ? 120000 : 10000;
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        fileDialog.setFilterNames(new String[]{"TuningTool Sava data(*.json *.xml)", "All Files(*.*)"});
        fileDialog.setFilterExtensions(new String[]{"*.json;*.xml", "*.*"});
        fileDialog.setFilterPath(System.getProperty("user.dir"));
        fileDialog.setText("Open");
        String fileName = fileDialog.open();
        if (fileName != null) {
            if (DialogSettingManager.getInstance().getIsConnected().booleanValue()) {
                boolean xmlOrjson = fileName.contains(".xml");
                Path filePath = Paths.get(fileName, new String[0]);
                File file = new File(filePath.toString());
                ClientHolder cl = ClientHolder.getInstance();
                Display display = Display.getCurrent();
                Shell shell = new Shell(display, 65632);
                Thread thread = new Thread(() -> {
                    try {
                        shell.setText("Import");
                        shell.setSize(400, 200);
                        shell.setLayout((Layout)new GridLayout(3, true));
                        Label label = new Label((Composite)shell, 0);
                        label.setText("Waiting for Importing......");
                        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 3, 1));
                        shell.open();
                        FileInputStream in = new FileInputStream(file);
                        byte[] bytes = new byte[(int)file.length()];
                        in.read(bytes);
                        StringBuffer encode = new StringBuffer();
                        encode.append(Base64.getEncoder().encodeToString(bytes));
                        ArrayList<ParamBean> params = new ArrayList<ParamBean>();
                        ParamBean fileParamBean = new ParamBean("setting", "file");
                        if (xmlOrjson) {
                            fileParamBean.getValue().setCurrentValue((Object)(BASE64_PREFIX_XML + encode.toString()));
                        } else {
                            fileParamBean.getValue().setCurrentValue((Object)(BASE64_PREFIX_JSON + encode.toString()));
                        }
                        params.add(fileParamBean);
                        JSONArray array = new JSONArray();
                        array.add(((ParamBean)params.get(0)).getValue().getValue());
                        JSONObject paramObject = new JSONObject();
                        paramObject.set("category", (Object)"ST");
                        paramObject.set("key", (Object)"setting");
                        paramObject.set("type", (Object)"file");
                        JSONObject valueObject = new JSONObject();
                        valueObject.set("current", (Object)array);
                        paramObject.set("value", (Object)valueObject);
                        cl.sendAsyncRequest(paramObject.toString(), new ClientHolder.ResponseListener(){

                            public void success(String response) {
                                JSONObject responseJson = new JSONObject((Object)response);
                                String message = responseJson.getStr((Object)"message");
                                if (!StrUtil.isEmpty((CharSequence)message)) {
                                    ConsoleLogger.printErrorMsg((String)("Import Failed: " + message));
                                    return;
                                }
                                final ModuleBean currentModuleBean = ModuleDataCenter.getInstance().getCurrentModuleBean();
                                if (currentModuleBean != null) {
                                    try {
                                        ModuleDataCenter.getInstance().readModuleData(currentModuleBean);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                            if (window != null) {
                                                IWorkbenchPage page = window.getActivePage();
                                                DetailView dView = (DetailView)((WorkbenchPage)page).getActiveEditor();
                                                dView.showGroups(currentModuleBean);
                                            }
                                        }
                                    });
                                }
                                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)("Import data from " + fileName + " success!"));
                                shell.close();
                            }

                            public void failed(String response) {
                                if (!shell.isDisposed()) {
                                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)("Import data from " + fileName + " failed: " + response));
                                    shell.close();
                                }
                            }
                        }, this.timeout);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                Display.getCurrent().asyncExec((Runnable)thread);
            } else {
                this.warningWindow("Connection Failed. Must Establish Connection Firstly");
            }
        }
        return null;
    }
}

