/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.handler;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import com.verisilicon.isp.tuning.ui.view.chart.AeStatistic;
import com.verisilicon.isp.tuning.ui.view.chart.AwbStatistic;
import com.verisilicon.isp.tuning.ui.view.dialog.JsonXmlEditDialog;
import java.io.IOException;
import java.util.Base64;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ExtraComponentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = new Shell();
        shell.setLayout((Layout)new RowLayout());
        Menu menu = new Menu((Decorations)shell, 8);
        MenuItem editItem = new MenuItem(menu, 8);
        editItem.setText("Json/Xml Edit");
        editItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = new Shell(Display.getCurrent().getActiveShell(), 67680);
                JsonXmlEditDialog jsonEditDialog = new JsonXmlEditDialog(shell);
                jsonEditDialog.open();
            }
        });
        MenuItem calibrationItem = new MenuItem(menu, 8);
        calibrationItem.setText("Calibration Tool");
        calibrationItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Runtime.getRuntime().exec("../cmdtools/extra/calibration/CalibrationToolSuite.exe");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        MenuItem awbItem = new MenuItem(menu, 8);
        awbItem.setText("AWB Tool");
        awbItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    System.loadLibrary("opencv_java460");
                }
                catch (UnsatisfiedLinkError error) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Load Library Failed! " + error.getMessage()));
                    return;
                }
                if (!DialogSettingManager.getInstance().getIsConnected().booleanValue()) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warrning", (String)"Please Connect With Server!");
                    return;
                }
                final String BASE64_PREFIX = "data:text/json;base64,";
                int timeout = 0;
                timeout = DialogSettingManager.getInstance().getServerType() == "UART" ? 120000 : 10000;
                JSONObject paramObject = new JSONObject();
                paramObject.set("category", (Object)"ST");
                paramObject.set("key", (Object)"Setting");
                paramObject.set("type", (Object)"file");
                ClientHolder cl = ClientHolder.getInstance();
                cl.sendAsyncRequest(paramObject.toString(), new ClientHolder.ResponseListener(){

                    public void success(String response) {
                        JSONObject responseJson = new JSONObject((Object)response).getJSONObject((Object)"value");
                        JSONArray arrayJson = responseJson.getJSONArray((Object)"current");
                        String base64Str = arrayJson.getStr((Object)0);
                        base64Str = base64Str.replaceFirst(BASE64_PREFIX, "");
                        byte[] decode = Base64.getDecoder().decode(base64Str);
                        JSONObject jsonObj = (JSONObject)JSONUtil.parse((Object)new String(decode));
                        JSONObject awbObj = new JSONObject((Object)((JSONObject)JSONUtil.parse((Object)jsonObj.getStr((Object)"sensor"))).getStr((Object)"AWB"));
                        JSONArray globals = JSONUtil.parseArray((String)awbObj.getStr((Object)"globals"));
                        JSONArray illumination = JSONUtil.parseArray((String)awbObj.getStr((Object)"illumination"));
                        if (!($assertionsDisabled || globals != null && illumination != null)) {
                            throw new AssertionError();
                        }
                        new AwbStatistic(globals, illumination);
                    }

                    public void failed(String response) {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)("Failed to Export: " + response));
                    }
                }, timeout);
            }
        });
        MenuItem aeItem = new MenuItem(menu, 8);
        aeItem.setText("AE Tool");
        aeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    System.loadLibrary("opencv_java460");
                }
                catch (UnsatisfiedLinkError error) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Load Library Failed! " + error.getMessage()));
                    return;
                }
                if (!DialogSettingManager.getInstance().getIsConnected().booleanValue()) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warrning", (String)"Please Connect With Server!");
                    return;
                }
                new AeStatistic();
            }
        });
        menu.setVisible(true);
        return null;
    }
}

