/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.handler;

import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ExportHandler
extends AbstractHandler {
    private static final String BASE64_PREFIX = "data:text/json;base64,";
    private int timeout = 0;

    protected void warningWindow(String message) {
        Shell shell = new Shell();
        MessageBox mb = new MessageBox(shell, 0);
        mb.setText("Warning");
        mb.setMessage(message);
        mb.open();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.timeout = DialogSettingManager.getInstance().getServerType() == "UART" ? 120000 : 10000;
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        fileDialog.setFilterNames(new String[]{"TuningTool Sava data(*.json)", "All Files(*.*)"});
        fileDialog.setFilterExtensions(new String[]{"*.json", "*.*"});
        fileDialog.setFilterPath(System.getProperty("user.dir"));
        fileDialog.setFileName(String.valueOf(ModuleDataCenter.getInstance().getCurrentTemplateName()) + "_" + System.currentTimeMillis() + ".json");
        fileDialog.setText("Save");
        String fileName = fileDialog.open();
        Display display = Display.getCurrent();
        Shell shell = new Shell(display, 65632);
        if (fileName != null) {
            if (DialogSettingManager.getInstance().getIsConnected().booleanValue()) {
                Path filePath = Paths.get(fileName, new String[0]);
                ClientHolder cl = ClientHolder.getInstance();
                Thread thread = new Thread(() -> {
                    shell.setText("Export");
                    shell.setSize(400, 200);
                    shell.setLayout((Layout)new GridLayout(3, true));
                    Label label = new Label((Composite)shell, 0);
                    label.setText("Waiting for Exporting......");
                    label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 3, 1));
                    shell.open();
                    JSONObject paramObject = new JSONObject();
                    paramObject.set("category", (Object)"ST");
                    paramObject.set("key", (Object)"Setting");
                    paramObject.set("type", (Object)"file");
                    cl.sendAsyncRequest(paramObject.toString(), new ClientHolder.ResponseListener(){

                        public void success(String response) {
                            String message = new JSONObject((Object)response).getStr((Object)"message");
                            if (!StrUtil.isEmpty((CharSequence)message)) {
                                ConsoleLogger.printErrorMsg((String)("Export Failed: " + message));
                                return;
                            }
                            JSONObject responseJson = new JSONObject((Object)response).getJSONObject((Object)"value");
                            JSONArray arrayJson = responseJson.getJSONArray((Object)"current");
                            String base64Str = arrayJson.getStr((Object)0);
                            base64Str = base64Str.replaceFirst(ExportHandler.BASE64_PREFIX, "");
                            byte[] decode = Base64.getDecoder().decode(base64Str);
                            FileWriter fileWriter = new FileWriter(filePath.toString());
                            fileWriter.write(new String(decode));
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)("Export data to " + fileName + " success!"));
                            shell.close();
                        }

                        public void failed(String response) {
                            if (!shell.isDisposed()) {
                                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)("Export data to " + fileName + " failed: " + response));
                                shell.close();
                            }
                        }
                    }, this.timeout);
                });
                Display.getCurrent().asyncExec((Runnable)thread);
            } else {
                this.warningWindow("Connection Failed. Must Establish Connection Firstly");
            }
        }
        return null;
    }
}

