/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.handler;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import com.verisilicon.isp.tuning.ui.view.chart.AwbStatistic;
import java.util.Base64;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AwbToolHandler
extends AbstractHandler {
    private static final String BASE64_PREFIX = "data:text/json;base64,";
    private int timeout = 0;
    private JSONArray globals;
    private JSONArray illumination;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            System.loadLibrary("opencv_java460");
        }
        catch (UnsatisfiedLinkError error) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Load Library Failed! " + error.getMessage()));
            return null;
        }
        if (!DialogSettingManager.getInstance().getIsConnected().booleanValue()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warrning", (String)"Please Connect With Server!");
            return null;
        }
        JSONObject paramObject = new JSONObject();
        paramObject.set("category", (Object)"ST");
        paramObject.set("key", (Object)"Setting");
        paramObject.set("type", (Object)"file");
        ClientHolder cl = ClientHolder.getInstance();
        this.timeout = DialogSettingManager.getInstance().getServerType() == "UART" ? 120000 : 10000;
        cl.sendAsyncRequest(paramObject.toString(), new ClientHolder.ResponseListener(){

            public void success(String response) {
                JSONObject responseJson = new JSONObject((Object)response).getJSONObject((Object)"value");
                JSONArray arrayJson = responseJson.getJSONArray((Object)"current");
                String base64Str = arrayJson.getStr((Object)0);
                base64Str = base64Str.replaceFirst(AwbToolHandler.BASE64_PREFIX, "");
                byte[] decode = Base64.getDecoder().decode(base64Str);
                JSONObject jsonObj = (JSONObject)JSONUtil.parse((Object)new String(decode));
                JSONObject awbObj = new JSONObject((Object)((JSONObject)JSONUtil.parse((Object)jsonObj.getStr((Object)"sensor"))).getStr((Object)"AWB"));
                AwbToolHandler.this.globals = JSONUtil.parseArray((String)awbObj.getStr((Object)"globals"));
                AwbToolHandler.this.illumination = JSONUtil.parseArray((String)awbObj.getStr((Object)"illumination"));
                if (!($assertionsDisabled || AwbToolHandler.this.globals != null && AwbToolHandler.this.illumination != null)) {
                    throw new AssertionError();
                }
                new AwbStatistic(AwbToolHandler.this.globals, AwbToolHandler.this.illumination);
            }

            public void failed(String response) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)("Failed to Export: " + response));
            }
        }, this.timeout);
        return null;
    }
}

