/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.core;

import cn.hutool.core.io.FileUtil;
import com.verisilicon.isp.tuning.core.bean.TemplateBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.manager.StorageManager;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.AbsConsoleLog;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.core.ConsoleLog;
import com.verisilicon.isp.tuning.ui.core.ImageRegistry;
import com.verisilicon.isp.tuning.ui.core.StatusContributionItem;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.internal.provisional.action.CoolBarManager2;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class UIPlugin
extends AbstractUIPlugin
implements IStartup,
IPropertyChangeListener {
    private IProject currentProject;
    private static UIPlugin projectController;
    private boolean initialized = false;
    private StatusContributionItem statusItem = new StatusContributionItem("ISP status");
    private StorageManager storageManager = new StorageManager();
    public static final String ISPTUNER_PERSPECTIVE = "com.verisilicon.isp.tuning.ui.perspective";
    public static final String PLUGIN_ID = "com.verisilicon.isp.tuning.ui.view";
    public static final String ID_FEATURES_VIEW = "com.verisilicon.isp.tuning.ui.view.featuresview";
    public static final String ID_DETAIL_EDITOR = "com.verisilicon.isp.tuning.ui.view.detailview";
    private String ISP_TOOLBAR_ID = "com.verisilicon.isp.tuning.ui.toolbar";

    public UIPlugin() {
        EventManager.getInstance().addPropertyChangeListener((IPropertyChangeListener)this);
        ClientHolder.getInstance().setPluginId(PLUGIN_ID);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("EVENT_STATUS_UPDATE")) {
            this.updateServerStatus(ClientHolder.getInstance().getURI(), (Boolean)event.getNewValue());
        }
    }

    public static UIPlugin getInstance() {
        assert (projectController != null);
        return projectController;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        projectController = this;
        this.init();
    }

    private void init() {
        ConsoleLog consoleLog = new ConsoleLog();
        ConsoleLogger.initConsoleLogger((AbsConsoleLog)consoleLog);
        if (this.initialized) {
            return;
        }
        this.initDB();
        this.initDataJSON();
        this.initConfigIni();
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            window.getSelectionService().addSelectionListener("org.eclipse.ui.navigator.ProjectExplorer", new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    IProject selectedProject = null;
                    if (selection instanceof TreeSelection) {
                        TreePath[] paths;
                        TreePath[] treePathArray = paths = ((TreeSelection)selection).getPaths();
                        int n = paths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project;
                            TreePath path = treePathArray[n2];
                            if (path.getFirstSegment() instanceof IProject && (project = (IProject)path.getFirstSegment()).isOpen()) {
                                try {
                                    if (project.hasNature("com.verisilicon.isp.tuning.ui.nature")) {
                                        selectedProject = (IProject)path.getFirstSegment();
                                    }
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                            ++n2;
                        }
                    }
                    UIPlugin.this.changeCurrentProject(selectedProject, null);
                }
            });
            window.addPerspectiveListener(new IPerspectiveListener(){

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                    WorkbenchWindow workbenchWindow = (WorkbenchWindow)window;
                    StatusLineManager statusLineManager = workbenchWindow.getStatusLineManager();
                    if (page != null) {
                        Perspective activePersp = ((WorkbenchPage)page).getActivePerspective();
                        String perspectiveId = perspective.getId();
                        if (perspectiveId != null && perspectiveId.equals(UIPlugin.ISPTUNER_PERSPECTIVE)) {
                            if (statusLineManager != null) {
                                statusLineManager.add((IContributionItem)UIPlugin.this.statusItem);
                            }
                        } else {
                            if (statusLineManager != null) {
                                statusLineManager.remove((IContributionItem)UIPlugin.this.statusItem);
                            }
                            CoolBarManager2 tools = (CoolBarManager2)workbenchWindow.getCoolBarManager2();
                            IContributionItem[] toolItems = tools.getItems();
                            Collection hiddenTools = activePersp.getHiddenToolbarItems();
                            IContributionItem[] iContributionItemArray = toolItems;
                            int n = toolItems.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IContributionItem item = iContributionItemArray[n2];
                                if (UIPlugin.this.ISP_TOOLBAR_ID.equals(item.getId())) {
                                    if (hiddenTools.contains(UIPlugin.this.ISP_TOOLBAR_ID)) break;
                                    hiddenTools.add(UIPlugin.this.ISP_TOOLBAR_ID);
                                    break;
                                }
                                ++n2;
                            }
                        }
                        activePersp.updateActionBars();
                    }
                }

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                }
            });
            this.initialized = true;
        }
    }

    private void initDB() {
        IPath dbPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String dbFilePath = String.valueOf(dbPath.toString()) + "/isp_tuningtool.db";
        if (!FileUtil.exist((String)dbFilePath)) {
            Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
            URL bundleDbUrl = bundle.getResource("/data/isp_tuningtool.db");
            assert (bundleDbUrl != null);
            try {
                URL sourceDbUrl = FileLocator.toFileURL((URL)bundleDbUrl);
                FileUtil.copy((String)sourceDbUrl.getPath(), (String)dbFilePath, (boolean)false);
                File dbFile = new File(dbFilePath);
                dbFile.setWritable(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void initDataJSON() {
        File file;
        String jsonString;
        IPath jsonPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String jsonFilePath = String.valueOf(jsonPath.toString()) + "/isp_modules.json";
        if (!FileUtil.exist((String)jsonFilePath)) {
            jsonString = ModuleDataCenter.getInstance().getAllTemplateModuleBeansString();
            file = FileUtil.writeString((String)jsonString, (String)jsonFilePath, (String)"UTF-8");
            assert (file != null);
        }
        if (!FileUtil.exist((String)(jsonFilePath = String.valueOf(jsonPath.toString()) + "/isp_sensor.json"))) {
            jsonString = ModuleDataCenter.getInstance().getAllSensorBeansString();
            file = FileUtil.writeString((String)jsonString, (String)jsonFilePath, (String)"UTF-8");
            assert (file != null);
            ModuleDataCenter.getInstance().loadAllSensorBeansFromWorkspace();
        }
    }

    private void initConfigIni() {
        IPath iniPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String iniFilePath = String.valueOf(iniPath.toString()) + "/isp_config.ini";
        if (!FileUtil.exist((String)iniFilePath)) {
            Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
            URL bundleIniUrl = bundle.getResource("/data/isp_config.ini");
            assert (bundleIniUrl != null);
            try {
                URL sourceIniUrl = FileLocator.toFileURL((URL)bundleIniUrl);
                FileUtil.copy((String)sourceIniUrl.getPath(), (String)iniFilePath, (boolean)false);
                File iniFile = new File(iniFilePath);
                iniFile.setWritable(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadProjectData(IProject project, String target) {
        if (project == null) {
            ModuleDataCenter.getInstance().clear();
        } else {
            String projectFileContent = this.storageManager.readProjectFile(project);
            if (projectFileContent != null) {
                ModuleDataCenter.getInstance().importFromExportedSetting(projectFileContent);
            } else if (target != null) {
                TemplateBean templateBean = ModuleDataCenter.getInstance().getTemplateWithName(target);
                ModuleDataCenter.getInstance().changeToTemplate(templateBean);
                ModuleDataCenter.getInstance().updateAMMap();
                ModuleDataCenter.getInstance().addManualAutoMode();
            }
        }
    }

    public void saveProjectSettings() {
        assert (this.currentProject != null);
        String jsonString = ModuleDataCenter.getInstance().getExportingSetting(0);
        if (jsonString != null) {
            this.storageManager.writeProjectFile(this.currentProject, jsonString);
            String projectName = this.currentProject.getName();
            String templateName = ModuleDataCenter.getInstance().getCurrentTemplateName();
            ConsoleLogger.print((String)("saveProjectSettings => Project: " + projectName + "   Template:" + templateName));
            EventManager.getInstance().notifyEvent("EVENT_PROJECT_SAVED", null);
        }
    }

    public void changeCurrentProject(IProject project, String target) {
        if (this.currentProject != null && this.currentProject == project) {
            return;
        }
        if (this.currentProject != null && this.currentProject != project) {
            this.saveProjectSettings();
        }
        this.loadProjectData(project, target);
        this.updateFeatureView();
        this.currentProject = project;
        String projectName = project == null ? "" : project.getName();
        String templateName = target == null ? ModuleDataCenter.getInstance().getCurrentTemplateName() : target;
        ConsoleLogger.print((String)("ChangeCurrentProject =>  Project:" + projectName + "   Template:" + templateName));
    }

    public void showDetailEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                IEditorReference[] editorRefs = page.findEditors((IEditorInput)new NullEditorInput(), ID_DETAIL_EDITOR, 2);
                if (editorRefs.length == 1) {
                    page.showEditor(editorRefs[0]);
                } else {
                    page.openEditor((IEditorInput)new NullEditorInput(), ID_DETAIL_EDITOR);
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateFeatureView() {
        EventManager.getInstance().notifyEvent("EVENT_TEMPLATE_CHANGED", (Object)ModuleDataCenter.getInstance().getCurrentTemplate());
    }

    public void updateServerStatus(String address, boolean connected) {
        if (connected) {
            this.statusItem.setImage(ImageRegistry.getImage(ImageRegistry.SERVER_STATUS_PASS));
        } else {
            this.statusItem.setImage(ImageRegistry.getImage(ImageRegistry.SERVER_STATUS_FAIL));
        }
        this.statusItem.setText(address);
    }

    public void earlyStartup() {
    }
}

