/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.core;

import com.verisilicon.isp.tuning.core.bean.ServerConfigBean;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.ui.core.UIPlugin;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IDialogSettings;

public class DialogSettingManager {
    private static final String DIALOG_SETTINGS_SECTION = "com.verisilicon.isp.tuning.ui";
    private static final String DIALOG_SETTING_ID_SERVER_TYPE = "ServerConfigDialog.SERVER.TYPE";
    private static final String DIALOG_SETTING_ID_SERVER_HTTP_INDEX = "ServerConfigDialog.HTTP.INDEX";
    private static final String DIALOG_SETTING_ID_SERVER_HTTP_LIST = "ServerConfigDialog.HTTP.LIST";
    private static final String DIALOG_SETTING_ID_SERVER_CONNECTION_TYPE = "ServerConfigDialog.CONNECTION.TYPE.LIST";
    private static final String DIALOG_SETTING_ID_SERVER_UART_NAME = "ServerConfigDialog.UART.NAME";
    private static final String DIALOG_SETTING_ID_SERVER_UART_BAUDRATE = "ServerConfigDialog.UART.BAUDRATE";
    private static final String DIALOG_SETTING_ID_CAPTURE_SAVE_PATH = "CaptureDialog.SAVE.PATH";
    private static final String DIALOG_SETTING_ID_PREFERENCES_DB_PATH = "PreferencesDialog.DB.PATH";
    private static final String DIALOG_SETTING_ID_PREFERENCES_IS_AUTO_READ = "PreferencesDialog.IS.AUTOREAD";
    private static final String DIALOG_SETTING_ID_PREFERENCES_IS_AUTO_WRITE = "PreferencesDialog.IS.AUTOWRITE";
    private String serverType = "HTTP";
    private String[] httpList = new String[]{"192.168.0.1:8080"};
    private String[] connectionTypeList = new String[]{"HTTP"};
    private int httpIndex = 0;
    private String uartName = "COM1";
    private String captureSavePath;
    private String dbPath;
    private Boolean isAutoRead;
    private Boolean isAutoWrite;
    private Boolean isConnected;
    private int baudRate = 115200;
    private static DialogSettingManager dialogSettingManager;

    public static DialogSettingManager getInstance() {
        if (dialogSettingManager == null) {
            dialogSettingManager = new DialogSettingManager();
        }
        return dialogSettingManager;
    }

    private DialogSettingManager() {
        this.restoreDialogSettings();
        this.setClientHolder();
        this.isAutoRead = true;
        this.isAutoWrite = false;
        this.isConnected = false;
    }

    private void restoreDialogSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] values;
            String value = settings.get(DIALOG_SETTING_ID_SERVER_TYPE);
            if (value != null) {
                this.serverType = value;
            }
            value = settings.get(DIALOG_SETTING_ID_SERVER_HTTP_INDEX);
            try {
                this.httpIndex = Integer.parseUnsignedInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
            value = settings.get(DIALOG_SETTING_ID_SERVER_UART_NAME);
            if (value != null) {
                this.uartName = value;
            }
            if ((values = settings.getArray(DIALOG_SETTING_ID_SERVER_HTTP_LIST)) != null && values.length > 0) {
                this.setHttpList(values);
            }
            if ((values = settings.getArray(DIALOG_SETTING_ID_SERVER_CONNECTION_TYPE)) != null && values.length > 0) {
                this.setConnectionTypeList(values);
            }
            if ((value = settings.get(DIALOG_SETTING_ID_PREFERENCES_DB_PATH)) != null) {
                this.dbPath = value;
            }
            if ((value = settings.get(DIALOG_SETTING_ID_PREFERENCES_IS_AUTO_READ)) != null) {
                this.isAutoRead = Boolean.parseBoolean(value);
            }
            if ((value = settings.get(DIALOG_SETTING_ID_PREFERENCES_IS_AUTO_WRITE)) != null) {
                this.isAutoWrite = Boolean.parseBoolean(value);
            }
            if ((value = settings.get(DIALOG_SETTING_ID_SERVER_UART_BAUDRATE)) != null) {
                this.baudRate = Integer.parseInt(value);
            }
        }
    }

    public void saveServerConfig() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(DIALOG_SETTING_ID_SERVER_TYPE, this.serverType);
            settings.put(DIALOG_SETTING_ID_SERVER_HTTP_INDEX, this.httpIndex);
            settings.put(DIALOG_SETTING_ID_SERVER_HTTP_LIST, this.httpList);
            settings.put(DIALOG_SETTING_ID_SERVER_CONNECTION_TYPE, this.connectionTypeList);
            settings.put(DIALOG_SETTING_ID_SERVER_UART_NAME, this.uartName);
        }
        this.setClientHolder();
    }

    public void saveCaptureConfig() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(DIALOG_SETTING_ID_CAPTURE_SAVE_PATH, this.captureSavePath);
        }
    }

    public void saveDdPath(String dbPath) {
        this.dbPath = dbPath;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(DIALOG_SETTING_ID_PREFERENCES_DB_PATH, dbPath);
        }
    }

    public void saveIsAutoRead(Boolean isAutoRead) {
        this.isAutoRead = isAutoRead;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(DIALOG_SETTING_ID_PREFERENCES_IS_AUTO_READ, isAutoRead.booleanValue());
        }
    }

    public void saveIsAutoWrite(Boolean isAutoWrite) {
        this.isAutoWrite = isAutoWrite;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(DIALOG_SETTING_ID_PREFERENCES_IS_AUTO_WRITE, isAutoWrite.booleanValue());
        }
    }

    private IDialogSettings getDialogSettings() {
        UIPlugin plugin = UIPlugin.getInstance();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    public void setClientHolder() {
        ServerConfigBean configBean = new ServerConfigBean();
        if (this.serverType.equals("UART")) {
            configBean.setServerType(ServerConfigBean.ServerType.UART);
            configBean.setUartName(this.uartName);
        } else if (this.serverType.equals("HTTP")) {
            String httpAddr;
            String[] subStrs;
            configBean.setServerType(ServerConfigBean.ServerType.HTTP);
            if (this.httpList.length > this.httpIndex && (subStrs = (httpAddr = this.httpList[this.httpIndex]).split(":")).length == 2) {
                configBean.setHttpHost(subStrs[0]);
                configBean.setHttpPort(subStrs[1]);
            }
        } else if (this.serverType.equals("TCP")) {
            String httpAddr;
            String[] subStrs;
            configBean.setServerType(ServerConfigBean.ServerType.TCP);
            if (this.httpList.length > this.httpIndex && (subStrs = (httpAddr = this.httpList[this.httpIndex]).split(":")).length == 2) {
                configBean.setHttpHost(subStrs[0]);
                configBean.setHttpPort(subStrs[1]);
            }
        }
        ClientHolder.getInstance().updateServerConfig(configBean);
    }

    public String getServerType() {
        return this.serverType;
    }

    public String[] getHttpList() {
        return this.httpList;
    }

    public String[] getConnectionTypeList() {
        return this.connectionTypeList;
    }

    public int getHttpIndex() {
        return this.httpIndex;
    }

    public String getUartName() {
        return this.uartName;
    }

    public String getCaptureSavePath() {
        return this.captureSavePath;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public Boolean getIsAutoRead() {
        return this.isAutoRead;
    }

    public Boolean getIsAutoWrite() {
        return this.isAutoWrite;
    }

    public Boolean getIsConnected() {
        return this.isConnected;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public void setHttpList(String[] httpList) {
        this.httpList = httpList;
    }

    public void setConnectionTypeList(String[] connectionTypeList) {
        this.connectionTypeList = connectionTypeList;
    }

    public void setHttpIndex(int httpIndex) {
        this.httpIndex = httpIndex;
    }

    public void setUartName(String uartName) {
        this.uartName = uartName;
    }

    public void setCaptureSavePath(String captureSavePath) {
        this.captureSavePath = captureSavePath;
    }

    public void setDbPath(String dbPath) {
        this.dbPath = dbPath;
    }

    public void setIsAutoRead(Boolean isAutoRead) {
        this.isAutoRead = isAutoRead;
    }

    public void setIsAutoWrite(Boolean isAutoWrite) {
        this.isAutoWrite = isAutoWrite;
    }

    public void setIsConnected(Boolean isConnected) {
        this.isConnected = isConnected;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialogSettingManager)) {
            return false;
        }
        DialogSettingManager other = (DialogSettingManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHttpIndex() != other.getHttpIndex()) {
            return false;
        }
        if (this.getBaudRate() != other.getBaudRate()) {
            return false;
        }
        Boolean this$isAutoRead = this.getIsAutoRead();
        Boolean other$isAutoRead = other.getIsAutoRead();
        if (this$isAutoRead == null ? other$isAutoRead != null : !((Object)this$isAutoRead).equals(other$isAutoRead)) {
            return false;
        }
        Boolean this$isAutoWrite = this.getIsAutoWrite();
        Boolean other$isAutoWrite = other.getIsAutoWrite();
        if (this$isAutoWrite == null ? other$isAutoWrite != null : !((Object)this$isAutoWrite).equals(other$isAutoWrite)) {
            return false;
        }
        Boolean this$isConnected = this.getIsConnected();
        Boolean other$isConnected = other.getIsConnected();
        if (this$isConnected == null ? other$isConnected != null : !((Object)this$isConnected).equals(other$isConnected)) {
            return false;
        }
        String this$serverType = this.getServerType();
        String other$serverType = other.getServerType();
        if (this$serverType == null ? other$serverType != null : !this$serverType.equals(other$serverType)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHttpList(), other.getHttpList())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getConnectionTypeList(), other.getConnectionTypeList())) {
            return false;
        }
        String this$uartName = this.getUartName();
        String other$uartName = other.getUartName();
        if (this$uartName == null ? other$uartName != null : !this$uartName.equals(other$uartName)) {
            return false;
        }
        String this$captureSavePath = this.getCaptureSavePath();
        String other$captureSavePath = other.getCaptureSavePath();
        if (this$captureSavePath == null ? other$captureSavePath != null : !this$captureSavePath.equals(other$captureSavePath)) {
            return false;
        }
        String this$dbPath = this.getDbPath();
        String other$dbPath = other.getDbPath();
        return !(this$dbPath == null ? other$dbPath != null : !this$dbPath.equals(other$dbPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DialogSettingManager;
    }

    public int hashCode() {
        int result = 1;
        result = result * 59 + this.getHttpIndex();
        result = result * 59 + this.getBaudRate();
        Boolean $isAutoRead = this.getIsAutoRead();
        result = result * 59 + ($isAutoRead == null ? 43 : ((Object)$isAutoRead).hashCode());
        Boolean $isAutoWrite = this.getIsAutoWrite();
        result = result * 59 + ($isAutoWrite == null ? 43 : ((Object)$isAutoWrite).hashCode());
        Boolean $isConnected = this.getIsConnected();
        result = result * 59 + ($isConnected == null ? 43 : ((Object)$isConnected).hashCode());
        String $serverType = this.getServerType();
        result = result * 59 + ($serverType == null ? 43 : $serverType.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getHttpList());
        result = result * 59 + Arrays.deepHashCode(this.getConnectionTypeList());
        String $uartName = this.getUartName();
        result = result * 59 + ($uartName == null ? 43 : $uartName.hashCode());
        String $captureSavePath = this.getCaptureSavePath();
        result = result * 59 + ($captureSavePath == null ? 43 : $captureSavePath.hashCode());
        String $dbPath = this.getDbPath();
        result = result * 59 + ($dbPath == null ? 43 : $dbPath.hashCode());
        return result;
    }

    public String toString() {
        return "DialogSettingManager(serverType=" + this.getServerType() + ", httpList=" + Arrays.deepToString(this.getHttpList()) + ", connectionTypeList=" + Arrays.deepToString(this.getConnectionTypeList()) + ", httpIndex=" + this.getHttpIndex() + ", uartName=" + this.getUartName() + ", captureSavePath=" + this.getCaptureSavePath() + ", dbPath=" + this.getDbPath() + ", isAutoRead=" + this.getIsAutoRead() + ", isAutoWrite=" + this.getIsAutoWrite() + ", isConnected=" + this.getIsConnected() + ", baudRate=" + this.getBaudRate() + ")";
    }
}

