/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.core;

import com.verisilicon.isp.tuning.core.util.AbsConsoleLog;
import com.verisilicon.tuning.ui.util.CommonConsoleManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.PageBookView;

public class ConsoleLog
extends CommonConsoleManager
implements AbsConsoleLog {
    private static ConsoleLog consoleLogger;
    private static String VISP_CONSOLE_NAME;
    private static String CONSOLE_VIEW_ID;

    static {
        VISP_CONSOLE_NAME = "ISP Tuning trace";
        CONSOLE_VIEW_ID = "org.eclipse.ui.console.ConsoleView";
    }

    public ConsoleLog() {
        MessageConsole console = this.findConsole(VISP_CONSOLE_NAME);
        this.setConsole(console);
        this.showConsoleView();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    Control control;
                    IWorkbenchPage page = window.getActivePage();
                    ViewFactory viewFactory = ((WorkbenchPage)page).getViewFactory();
                    IViewReference viewRef = viewFactory.getView(CONSOLE_VIEW_ID);
                    if (viewRef == null) {
                        return;
                    }
                    IWorkbenchPart viewPart = viewRef.getPart(false);
                    if (viewPart instanceof PageBookView && (control = ((PageBookView)viewPart).getCurrentPage().getControl()) instanceof StyledText) {
                        ((StyledText)control).setWordWrap(true);
                    }
                }
            }
        });
    }

    public void print(String msg) {
        if (consoleLogger == null) {
            consoleLogger = new ConsoleLog();
        }
        consoleLogger.printNone(new Object[]{msg});
    }

    public void printWarningMsg(String msg) {
        if (consoleLogger == null) {
            consoleLogger = new ConsoleLog();
        }
        consoleLogger.printWarning(new Object[]{msg});
    }

    public void printErrorMsg(String msg) {
        if (consoleLogger == null) {
            consoleLogger = new ConsoleLog();
        }
        consoleLogger.printError(new Object[]{msg});
    }
}

