/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.tuning.ui.util.widgets;

import java.text.Format;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class RangeSlider
extends Canvas {
    private int minimum = 0;
    private int maximum = 100;
    private int fValue;
    private final Image slider = SWTGraphicUtil.createImageFromFile((String)"images/slider-normal.png");
    private final Image sliderSelected = SWTGraphicUtil.createImageFromFile((String)"images/slider-selected.png");
    private final Image vSlider = SWTGraphicUtil.createImageFromFile((String)"images/h-slider-normal.png");
    private final Image vSliderSelected = SWTGraphicUtil.createImageFromFile((String)"images/h-slider-selected.png");
    private int orientation;
    private int increment = 1;
    private int pageIncrement = 10;
    private boolean dragInProgress;
    private boolean fHover;
    private int previousValue;
    private int startDragValue;
    private boolean hasFocus;
    private final boolean isSmooth;
    private final boolean isHighQuality;
    private final boolean isOn;
    private int tickDivisions = 10;
    private int stride = 1;
    private float tickFactor;
    private Format toolTipFormatter;
    private String clientToolTipText;
    private StringBuffer toolTip;
    private Point coordKnob;

    public RangeSlider(Composite parent, int style) {
        super(parent, 0x20000000 | ((style & 0x800) == 2048 ? 2048 : 0));
        this.orientation = (style & 0x200) == 512 ? 512 : 256;
        this.isSmooth = (style & 0x10000) == 65536;
        this.isHighQuality = (style & 2) == 2;
        this.isOn = (style & 1) == 1;
        this.addListener(12, event -> {
            SWTGraphicUtil.safeDispose((Resource)this.slider);
            SWTGraphicUtil.safeDispose((Resource)this.sliderSelected);
            SWTGraphicUtil.safeDispose((Resource)this.vSlider);
            SWTGraphicUtil.safeDispose((Resource)this.vSliderSelected);
        });
        this.addMouseListeners();
        this.addListener(11, event -> {
            if (this.isHighQuality) {
                this.setTickFactors();
            } else {
                this.tickFactor = ((float)(this.orientation == 256 ? this.getClientArea().width : this.getClientArea().height) - 20.0f) / (float)this.tickDivisions;
            }
        });
        this.addListener(15, e -> {
            this.hasFocus = true;
            this.redraw();
        });
        this.addListener(16, e -> {
            this.hasFocus = false;
            this.redraw();
        });
        this.addListener(1, event -> this.handleKeyDown(event));
        this.addPaintListener(event -> this.drawWidget(event));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redraw();
    }

    protected void setTickFactors() {
        int breadth;
        int n = breadth = this.orientation == 256 ? this.getClientArea().width : this.getClientArea().height;
        if (breadth > 40) {
            this.setTickFactors((float)breadth - 20.0f);
        } else {
            this.tickDivisions = 0;
        }
    }

    protected void setTickFactors(float breadth) {
        int fullRange = this.maximum - this.minimum;
        int division = this.pageIncrement;
        this.tickDivisions = fullRange / division;
        float limit = Math.max(10.0f, breadth / 20.0f);
        while ((float)this.tickDivisions < limit && division > 2 && division % 2 == 0) {
            this.tickDivisions = fullRange / (division >>= 1);
        }
        if ((float)this.tickDivisions < limit) {
            division = this.increment;
            this.tickDivisions = fullRange / division;
            while ((float)this.tickDivisions < limit && division > 2 && division % 2 == 0) {
                this.tickDivisions = fullRange / (division >>= 1);
            }
        }
        if ((float)this.tickDivisions < limit && this.isSmooth) {
            division = 1;
            this.tickDivisions = fullRange;
        }
        this.stride = 1;
        if (this.tickDivisions > 0) {
            int range = fullRange - fullRange % division;
            float tickRange = breadth * (float)range / (float)fullRange;
            float pixelSize = tickRange / (float)range;
            limit = Math.max(10.0f, tickRange / 20.0f);
            while ((float)(this.tickDivisions / this.stride) > limit) {
                this.stride <<= 1;
            }
            this.tickFactor = pixelSize * (float)range / (float)this.tickDivisions;
            if (range != fullRange) {
                ++this.tickDivisions;
            }
        }
    }

    public int getStyle() {
        return super.getStyle() | this.orientation | (this.isSmooth ? 65536 : 0) | (this.isOn ? 1 : 0) | (this.isHighQuality ? 2 : 0);
    }

    private void addMouseListeners() {
        this.addListener(3, event -> this.handleMouseDown(event));
        this.addListener(4, event -> this.handleMouseUp(event));
        this.addListener(5, event -> this.handleMouseMove(event));
        this.addListener(37, event -> this.handleMouseWheel(event));
        this.addListener(32, event -> this.handleMouseHover(event));
        this.addListener(8, event -> this.handleMouseDoubleClick(event));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.addSelectionListener((Control)this, (SelectionListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.removeSelectionListener((Control)this, (SelectionListener)listener);
    }

    private void handleMouseDown(Event e) {
        this.selectKnobs(e);
        if (this.fHover) {
            this.dragInProgress = true;
            this.startDragValue = this.previousValue = this.fValue;
        }
    }

    private void handleMouseUp(Event e) {
        if (this.dragInProgress) {
            this.validateNewValues(e);
            this.dragInProgress = false;
            super.setToolTipText(this.clientToolTipText);
        }
    }

    private void handleKeyDown(Event event) {
        int accelerator;
        int n = (event.stateMask & 0x20000) != 0 ? 10 : (accelerator = (event.stateMask & 0x40000) != 0 ? 2 : 1);
        if (this.dragInProgress) {
            switch (event.keyCode) {
                case 27: {
                    this.fValue = this.startDragValue;
                    this.validateNewValues(event);
                    this.dragInProgress = false;
                    if (!this.isOn) {
                        this.redraw();
                    }
                    event.doit = false;
                    break;
                }
                case 0x1000001: {
                    accelerator = this.orientation == 256 ? -accelerator : accelerator;
                }
                case 0x1000003: {
                    if (this.orientation == 512) {
                        this.moveCursorPosition(0, -accelerator);
                    } else {
                        this.moveCursorPosition(-accelerator, 0);
                    }
                    event.doit = false;
                    break;
                }
                case 0x1000002: {
                    accelerator = this.orientation == 256 ? -accelerator : accelerator;
                }
                case 0x1000004: {
                    if (this.orientation == 512) {
                        this.moveCursorPosition(0, accelerator);
                    } else {
                        this.moveCursorPosition(accelerator, 0);
                    }
                    event.doit = false;
                }
            }
            return;
        }
        this.previousValue = this.fValue;
        switch (event.keyCode) {
            case 0x1000007: {
                this.fValue = this.maximum;
                break;
            }
            case 0x1000008: {
                this.fValue = this.minimum;
                break;
            }
            case 0x1000005: {
                accelerator = this.orientation == 256 ? -accelerator : accelerator;
                this.fValue -= this.pageIncrement * accelerator;
                break;
            }
            case 0x1000006: {
                accelerator = this.orientation == 256 ? -accelerator : accelerator;
                this.fValue += this.pageIncrement * accelerator;
                break;
            }
            case 0x1000002: {
                accelerator = this.orientation == 256 ? -accelerator : accelerator;
            }
            case 0x1000004: {
                this.fValue += accelerator * this.increment;
                break;
            }
            case 0x1000001: {
                accelerator = this.orientation == 256 ? -accelerator : accelerator;
            }
            case 0x1000003: {
                this.fValue -= accelerator * this.increment;
                break;
            }
            case 9: {
                boolean next;
                boolean bl = next = (event.stateMask & 0x20000) == 0;
                if (!next) {
                    this.redraw();
                }
                return;
            }
        }
        if (this.previousValue != this.fValue) {
            this.checkValue();
            this.validateNewValues(event);
        }
    }

    private void handleMouseMove(Event e) {
        if (!this.dragInProgress) {
            boolean wasHover = this.fHover;
            this.selectKnobs(e);
            if (wasHover != this.fHover) {
                this.redraw();
            }
        } else {
            int x = e.x;
            int y = e.y;
            if (this.orientation == 256) {
                this.fValue = Math.round((float)x / this.computePixelSizeForHorizontalSlider()) + this.minimum;
                if (!this.isSmooth) {
                    this.fValue = (int)(Math.ceil(this.fValue / this.increment) * (double)this.increment) - this.increment;
                }
                this.checkValue();
                this.handleToolTip(this.fValue);
            } else {
                this.fValue = Math.round((float)y / this.computePixelSizeForVerticalSlider()) + this.minimum;
                if (!this.isSmooth) {
                    this.fValue = (int)(Math.ceil(this.fValue / this.increment) * (double)this.increment) - this.increment;
                }
                this.checkValue();
                this.handleToolTip(this.fValue);
            }
            if (this.isOn) {
                this.validateNewValues(e);
            } else {
                this.redraw();
            }
        }
    }

    private void handleMouseHover(Event e) {
        if (!this.dragInProgress && this.toolTipFormatter != null) {
            int value = this.getCursorValue(e.x, e.y);
            if (value >= 0) {
                try {
                    this.toolTip.setLength(0);
                    this.toolTipFormatter.format(value, this.toolTip, null);
                    super.setToolTipText(this.toolTip.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    super.setToolTipText(this.clientToolTipText);
                }
            } else {
                super.setToolTipText(this.clientToolTipText);
            }
        }
    }

    private void handleMouseWheel(Event e) {
        if (this.dragInProgress) {
            e.doit = false;
            return;
        }
        this.previousValue = this.fValue;
        int amount = this.increment * ((e.stateMask & 0x20000) != 0 ? 10 : ((e.stateMask & 0x40000) != 0 ? 2 : 1));
        this.fValue += e.count * amount;
        this.checkValue();
        this.validateNewValues(e);
        e.doit = false;
    }

    private void handleMouseDoubleClick(Event e) {
        int value = this.getCursorValue(e.x, e.y);
        if (value >= 0) {
            if (value > this.fValue && value < this.maximum || value < this.fValue && value > this.minimum) {
                this.fValue = value;
            } else if (value + this.fValue > this.maximum) {
                this.fValue = this.maximum;
            } else if (value + this.fValue < this.minimum) {
                this.fValue = this.minimum;
            }
            this.validateNewValues(e);
        }
    }

    private void selectKnobs(Event e) {
        Image img = this.orientation == 256 ? this.slider : this.vSlider;
        int x = e.x;
        int y = e.y;
        this.fHover = x >= this.coordKnob.x && x <= this.coordKnob.x + img.getBounds().width && y >= this.coordKnob.y && y <= this.coordKnob.y + img.getBounds().height;
    }

    private void moveCursorPosition(int xDelta, int yDelta) {
        Point cursorPosition = this.getDisplay().getCursorLocation();
        cursorPosition.x += xDelta;
        cursorPosition.y += yDelta;
        this.getDisplay().setCursorLocation(cursorPosition);
    }

    private int getCursorValue(int x, int y) {
        int value = -1;
        Rectangle clientArea = this.getClientArea();
        if (this.orientation == 256) {
            if (x < 9 + clientArea.width - 20 && x >= 9 && y >= 9 && y <= 9 + clientArea.height - 20) {
                value = (int)Math.round(((double)x - 9.0) / (double)this.computePixelSizeForHorizontalSlider()) + this.minimum;
            }
        } else if (y < 9 + clientArea.height - 20 && y >= 9 && x >= 9 && x <= 9 + clientArea.width - 20) {
            value = (int)Math.round(((double)y - 9.0) / (double)this.computePixelSizeForVerticalSlider()) + this.minimum;
        }
        return value;
    }

    private void validateNewValues(Event e) {
        if (this.fValue != this.previousValue) {
            if (!SelectionListenerUtil.fireSelectionListeners((Control)this, (Event)e)) {
                this.fValue = this.previousValue;
            }
            this.previousValue = this.fValue;
            this.redraw();
        }
    }

    private void handleToolTip(int ... values) {
        if (this.toolTipFormatter != null) {
            try {
                if (values.length == 1) {
                    this.toolTip.setLength(0);
                    this.toolTipFormatter.format(values[0], this.toolTip, null);
                    super.setToolTipText(this.toolTip.toString());
                } else if (values.length == 2) {
                    this.toolTip.setLength(0);
                    this.toolTipFormatter.format(values[0], this.toolTip, null);
                    this.toolTip.append(" \u2194 ");
                    this.toolTipFormatter.format(values[1], this.toolTip, null);
                    super.setToolTipText(this.toolTip.toString());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                super.setToolTipText(this.clientToolTipText);
            }
        }
    }

    public void setToolTipFormatter(Format formatter) {
        this.toolTip = formatter != null ? new StringBuffer() : null;
        this.toolTipFormatter = formatter;
    }

    public void setToolTipText(String string) {
        this.clientToolTipText = string;
        super.setToolTipText(this.clientToolTipText);
    }

    private void checkValue() {
        if (this.fValue < this.minimum) {
            this.fValue = this.minimum;
        }
        if (this.fValue > this.maximum) {
            this.fValue = this.maximum;
        }
    }

    private void drawWidget(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        e.gc.setAdvanced(true);
        e.gc.setAntialias(1);
        if (this.orientation == 256) {
            this.drawHorizontalRangeSlider(e.gc);
        } else {
            this.drawVerticalRangeSlider(e.gc);
        }
    }

    private void drawHorizontalRangeSlider(GC gc) {
        this.drawBackgroundHorizontal(gc);
        this.coordKnob = this.drawHorizontalKnob(gc, this.fValue);
    }

    private void drawBackgroundHorizontal(GC gc) {
        Rectangle clientArea = this.getClientArea();
        if (this.isEnabled()) {
            gc.setForeground(this.getForeground());
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        gc.drawRoundRectangle(0, 10, clientArea.width - 1, 5, 3, 3);
        gc.setBackground(new Color(null, 185, 187, 215));
        gc.fillRectangle(1, 11, clientArea.width - 2, 4);
    }

    private float computePixelSizeForHorizontalSlider() {
        return ((float)this.getClientArea().width - 9.0f) / (float)(this.maximum - this.minimum);
    }

    private Point drawHorizontalKnob(GC gc, int value) {
        float pixelSize = this.computePixelSizeForHorizontalSlider();
        int x = (int)(pixelSize * (float)value);
        Image image = this.fHover ? this.sliderSelected : (this.hasFocus ? this.sliderSelected : this.slider);
        if (this.isEnabled()) {
            gc.drawImage(image, x, 5);
        } else {
            Image temp = new Image((Device)this.getDisplay(), image, 1);
            gc.drawImage(temp, x, 5);
            temp.dispose();
        }
        return new Point(x, 5);
    }

    private void drawVerticalRangeSlider(GC gc) {
        this.drawBackgroundVertical(gc);
        this.coordKnob = this.drawVerticalKnob(gc, this.fValue);
    }

    private void drawBackgroundVertical(GC gc) {
        Rectangle clientArea = this.getClientArea();
        if (this.isEnabled()) {
            gc.setForeground(this.getForeground());
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        gc.drawRoundRectangle(10, 0, 5, clientArea.height - 1, 3, 3);
        gc.setBackground(new Color(null, 185, 187, 215));
        gc.fillRectangle(11, 1, 4, clientArea.height - 2);
    }

    private float computePixelSizeForVerticalSlider() {
        return ((float)this.getClientArea().height - 9.0f) / (float)(this.maximum - this.minimum);
    }

    private Point drawVerticalKnob(GC gc, int value) {
        float pixelSize = this.computePixelSizeForVerticalSlider();
        int y = (int)(pixelSize * (float)value);
        Image image = this.fHover ? this.vSliderSelected : (this.hasFocus ? this.vSliderSelected : this.vSlider);
        if (this.isEnabled()) {
            gc.drawImage(image, 5, y - 1);
        } else {
            Image temp = new Image((Device)this.getDisplay(), image, 1);
            gc.drawImage(temp, 5, y - 1);
            temp.dispose();
        }
        return new Point(5, y - 1);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        this.checkWidget();
        if (this.orientation == 256) {
            width = wHint < 100 ? 100 : wHint;
            height = hHint < 30 ? 30 : hHint;
        } else {
            width = wHint < 30 ? 30 : wHint;
            height = hHint < 100 ? 100 : hHint;
        }
        return new Point(width, height);
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        return this.fValue;
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        this.increment = increment;
        if (this.isHighQuality) {
            this.setTickFactors();
        }
        this.redraw();
    }

    public void setMaximum(int value) {
        this.setExtrema(this.minimum, value);
    }

    public void setMinimum(int value) {
        this.setExtrema(value, this.maximum);
    }

    public void setExtrema(int min, int max) {
        this.checkWidget();
        if (min >= 0 && min < max && (min != this.minimum || max != this.maximum)) {
            this.minimum = min;
            this.maximum = max;
            if (this.fValue < this.minimum) {
                this.fValue = this.minimum;
            } else if (this.fValue > this.maximum) {
                this.fValue = this.maximum;
            }
            if (this.isHighQuality) {
                this.setTickFactors();
            }
            this.redraw();
        }
    }

    public void setPageIncrement(int pageIncrement) {
        this.checkWidget();
        this.pageIncrement = pageIncrement;
        if (this.isHighQuality) {
            this.setTickFactors();
        }
        this.redraw();
    }

    public void setSelection(int value) {
        this.checkWidget();
        if (value > this.minimum && value < this.maximum && this.fValue != value) {
            this.fValue = value;
        } else if (value <= this.minimum) {
            this.fValue = this.minimum;
        } else if (value >= this.maximum) {
            this.fValue = this.maximum;
        }
        this.redraw();
    }
}

