/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.tuning.ui.util.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CustomSpinnerLayout
extends Layout {
    public static final int TEXT = 0;
    public static final int UP = 1;
    public static final int DOWN = 2;
    static final int buttonWidth = 16;
    public Control[] controls = new Control[3];
    Point[] sizes;
    int width;
    int height;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (this.sizes == null || flushCache) {
            this.refreshSizes(composite.getChildren());
        }
        int w = wHint;
        int h = hHint;
        if (w == -1) {
            w = this.width;
        }
        if (h == -1) {
            h = this.height;
        }
        return new Point(w, h);
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (flushCache || this.sizes == null) {
            this.refreshSizes(composite.getChildren());
        }
        Rectangle clientArea = composite.getClientArea();
        composite.getRegion();
        composite.getSize();
        if (this.controls[0] != null) {
            this.controls[0].setBounds(clientArea.x, clientArea.y, clientArea.width - this.sizes[1].x, clientArea.height);
        }
        if (this.controls[1] != null) {
            this.controls[1].setBounds(clientArea.x + clientArea.width - this.sizes[1].x, clientArea.y, this.sizes[1].x, this.sizes[1].y);
        }
        if (this.controls[2] != null) {
            this.controls[2].setBounds(clientArea.x + clientArea.width - this.sizes[2].x, clientArea.y + this.sizes[1].y, this.sizes[2].x, this.sizes[2].y);
        }
    }

    private void refreshSizes(Control[] children) {
        int i = 0;
        while (i < children.length) {
            Object layoutData = children[i].getLayoutData();
            if (layoutData != null && layoutData instanceof CustomLayoutData) {
                CustomLayoutData customLayoutData = (CustomLayoutData)layoutData;
                if (customLayoutData.region >= 0 && customLayoutData.region <= 2) {
                    this.controls[customLayoutData.region] = children[i];
                }
            }
            ++i;
        }
        this.width = 0;
        this.height = 0;
        if (this.sizes == null) {
            this.sizes = new Point[3];
        }
        i = 0;
        while (i < this.controls.length) {
            Control control = this.controls[i];
            if (control == null) {
                this.sizes[i] = new Point(0, 0);
            } else if (i == 0) {
                this.sizes[i] = control.computeSize(-1, -1, true);
            } else if (i != 0) {
                this.sizes[i] = control.computeSize(16, -1, true);
            }
            ++i;
        }
        this.width = Math.max(Math.max(16, this.sizes[0].x + this.sizes[1].x), this.sizes[0].x + this.sizes[2].x);
        this.height = Math.max(this.sizes[2].y + this.sizes[1].y, this.sizes[0].y);
    }

    public static class CustomLayoutData {
        public int region = 0;

        public CustomLayoutData() {
        }

        public CustomLayoutData(int region) {
            this.region = region;
        }
    }
}

