/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.tuning.ui.util.widgets;

import com.verisilicon.tuning.ui.util.UIUtilImageRegistry;
import com.verisilicon.tuning.ui.util.listeners.ISpinnerChangedListener;
import com.verisilicon.tuning.ui.util.widgets.CustomSpinnerLayout;
import java.util.ArrayList;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CustomSpinner
extends Composite {
    private boolean willDispose = false;
    private Text fText;
    private Label fUpLabel;
    private Label fDownLabel;
    private int fIncrement = 1;
    private int digits = 0;
    private int fRadix = 10;
    private int maximum = Integer.MAX_VALUE;
    private int minimum = Integer.MIN_VALUE;
    private boolean textFocusLost = false;
    private boolean textExit = true;
    private boolean upExit = true;
    private boolean downExit = true;
    private boolean isEdited = false;
    private String fPreValue;
    private ArrayList<ISpinnerChangedListener> listenerList = new ArrayList();

    public CustomSpinner(Composite parent, int style, boolean willDispose) {
        super(parent, CustomSpinner.checkStyle(style));
        super.setLayout((Layout)new CustomSpinnerLayout());
        this.willDispose = willDispose;
        this.fPreValue = String.valueOf(this.minimum);
        this.createContentArea(this);
    }

    protected void createContentArea(Composite parent) {
        this.fText = new Text(parent, 3076);
        this.fText.setLayoutData((Object)new CustomSpinnerLayout.CustomLayoutData(0));
        if (this.willDispose) {
            this.fText.forceFocus();
            this.fText.setFocus();
            this.fText.selectAll();
        }
        this.fUpLabel = new Label(parent, 0x1000800);
        this.fUpLabel.setImage(UIUtilImageRegistry.getImage(UIUtilImageRegistry.SPINNER_UP));
        this.fUpLabel.setLayoutData((Object)new CustomSpinnerLayout.CustomLayoutData(1));
        this.fDownLabel = new Label(parent, 0x1000800);
        this.fDownLabel.setImage(UIUtilImageRegistry.getImage(UIUtilImageRegistry.SPINNER_DOWN));
        this.fDownLabel.setLayoutData((Object)new CustomSpinnerLayout.CustomLayoutData(2));
        this.addBasicListener();
    }

    private void addBasicListener() {
        this.fText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (CustomSpinner.this.fRadix == 10) {
                    if (!Character.isDigit(e.character) && e.character != '.' && e.character != '\b' && e.character != '\u0000') {
                        e.doit = false;
                        return;
                    }
                } else if (!(Character.isDigit(e.character) || e.character >= 'a' && e.character <= 'f' || e.character == '\b' || e.character == '\u0000')) {
                    e.doit = false;
                    return;
                }
            }
        });
        this.fText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                CustomSpinner.this.textFocusLost = true;
                if (!CustomSpinner.this.fPreValue.equals(CustomSpinner.this.getValue())) {
                    CustomSpinner.this.isEdited = true;
                }
                CustomSpinner.this.couldDispose();
            }

            public void focusGained(FocusEvent e) {
                CustomSpinner.this.textFocusLost = false;
            }
        });
        this.fText.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                CustomSpinner.this.textExit = true;
            }

            public void mouseEnter(MouseEvent e) {
                CustomSpinner.this.textExit = false;
            }
        });
        this.fText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    String textVal = CustomSpinner.this.getValue();
                    if (CustomSpinner.this.willDispose) {
                        CustomSpinner.this.dispose();
                    }
                    if (!CustomSpinner.this.fPreValue.equals(textVal)) {
                        int value = CustomSpinner.this.getIntegerValue(textVal);
                        CustomSpinner.this.setSelection(value);
                        CustomSpinner.this.notifyValueChanged(true);
                        CustomSpinner.this.isEdited = false;
                    }
                } else if (!CustomSpinner.this.fText.isDisposed() && e.keyCode == 0x1000001) {
                    CustomSpinner.this.handleUpSelected(true);
                } else if (!CustomSpinner.this.fText.isDisposed() && e.keyCode == 0x1000002) {
                    CustomSpinner.this.handleUpSelected(false);
                }
            }
        });
        this.fUpLabel.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                CustomSpinner.this.fUpLabel.setBackground(new Color(null, 240, 240, 240));
                CustomSpinner.this.upExit = true;
            }

            public void mouseEnter(MouseEvent e) {
                CustomSpinner.this.fUpLabel.setBackground(new Color(null, 170, 230, 255));
                CustomSpinner.this.upExit = false;
            }
        });
        this.fUpLabel.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                CustomSpinner.this.handleUpSelected(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.fDownLabel.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                CustomSpinner.this.fDownLabel.setBackground(new Color(null, 240, 240, 240));
                CustomSpinner.this.downExit = true;
            }

            public void mouseEnter(MouseEvent e) {
                CustomSpinner.this.fDownLabel.setBackground(new Color(null, 170, 230, 255));
                CustomSpinner.this.downExit = false;
            }
        });
        this.fDownLabel.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                CustomSpinner.this.handleUpSelected(false);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private int getIntegerValue(String str) {
        int value = 0;
        double textVal = 0.0;
        try {
            if (this.fRadix != 10) {
                value = Integer.parseInt(str, this.fRadix);
            } else {
                textVal = Double.parseDouble(str);
                value = (int)(textVal * Math.pow(10.0, this.digits));
            }
        }
        catch (Exception exception) {}
        return value;
    }

    private void handleUpSelected(boolean upSelected) {
        int value = this.getIntegerValue(this.getValue());
        value = upSelected ? (value += this.fIncrement) : (value -= this.fIncrement);
        this.setSelection(value);
        this.isEdited = value <= this.maximum && value >= this.minimum;
        this.fText.forceFocus();
        this.fText.setFocus();
        this.fText.selectAll();
        this.notifyValueChanged(this.isEdited);
    }

    private void couldDispose() {
        if (this.textFocusLost && this.textExit && this.upExit && this.downExit) {
            String textVal = this.getValue();
            if (this.willDispose) {
                this.dispose();
            }
            if (this.isEdited) {
                this.fPreValue = textVal;
                this.notifyValueChanged(this.isEdited);
                this.isEdited = false;
            }
        }
    }

    public void addSpinnerChangedListener(ISpinnerChangedListener listener) {
        this.listenerList.add(listener);
    }

    public void removeValueChangedListener(ISpinnerChangedListener listener) {
        this.listenerList.remove(listener);
    }

    public void fireValueChanged() {
        for (ISpinnerChangedListener listener : this.listenerList) {
            listener.valueChanged();
        }
    }

    private void notifyValueChanged(boolean curveChanged) {
        if (curveChanged) {
            this.fireValueChanged();
        }
    }

    public void setDigits(int value) {
        if (value < 0 || value == this.digits) {
            return;
        }
        this.digits = value;
    }

    public void setIncrement(int value) {
        if (value < 1) {
            return;
        }
        this.fIncrement = value;
    }

    public void setMaximum(int value) {
        this.maximum = value;
    }

    public void setMinimum(int value) {
        this.minimum = value;
    }

    public void setRadix(int radix) {
        this.fRadix = radix;
    }

    public void setSelection(int value) {
        String string;
        if (value < this.minimum) {
            value = this.minimum;
        }
        if (value > this.maximum) {
            value = this.maximum;
        }
        if (this.fRadix != 10) {
            string = Integer.toString(value, this.fRadix);
        } else if (this.digits == 0) {
            string = String.valueOf(value);
        } else {
            double textValue = (double)value / Math.pow(10.0, this.digits);
            string = String.valueOf(textValue);
            if (value < 0) {
                string = "-" + string;
            }
        }
        if (!this.isDisposed()) {
            this.fText.setText(string);
        }
        this.fPreValue = string;
    }

    public void setText(String string) {
        this.fText.setText(string);
    }

    public Control getControl() {
        return this;
    }

    public int getDigits() {
        return this.digits;
    }

    public int getIncrement() {
        return this.fIncrement;
    }

    public int getRadix() {
        return this.fRadix;
    }

    public int getSelection() {
        double textValue;
        int selection = 0;
        double val = 0.0;
        try {
            val = Double.parseDouble(this.getValue());
            selection = (int)(val * Math.pow(10.0, this.digits));
        }
        catch (Exception exception) {}
        if (selection < this.minimum) {
            selection = this.minimum;
            textValue = (double)selection / Math.pow(10.0, this.digits);
            this.fText.setText(String.valueOf(textValue));
        }
        if (selection > this.maximum) {
            selection = this.maximum;
            textValue = (double)selection / Math.pow(10.0, this.digits);
            this.fText.setText(String.valueOf(textValue));
        }
        return selection;
    }

    public int getSelection(int radix) {
        int selection = 0;
        try {
            selection = Integer.parseInt(this.getValue(), radix);
        }
        catch (Exception exception) {
            this.fText.setText(this.getValue());
        }
        return selection;
    }

    public void setTextLimit(int limit) {
        this.fText.setTextLimit(limit);
    }

    public String getText() {
        this.getSelection();
        return this.getValue();
    }

    private String getValue() {
        String text = "";
        if (this.fText.isDisposed()) {
            text = this.fPreValue;
        } else {
            text = this.fText.getText();
            if (text.isEmpty()) {
                text = this.fPreValue;
            }
        }
        return text;
    }

    public int getTextLimit() {
        return this.fText.getTextLimit();
    }

    public boolean getWillDispose() {
        return this.willDispose;
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    public void setBackground(Color color) {
        this.fText.setBackground(color);
    }
}

