/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.tuning.ui.util;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class CommonConsoleManager {
    private MessageConsole console = null;
    private MessageConsoleStream outStream = null;
    private MessageConsoleStream errStream = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void setConsole(MessageConsole console) {
        this.console = console;
        if (console == null) {
            this.outStream = null;
            this.errStream = null;
        } else {
            this.outStream = console.newMessageStream();
            this.errStream = console.newMessageStream();
            this.errStream.setColor(new Color((Device)Display.getDefault(), new RGB(255, 0, 0)));
        }
    }

    public void closeConsole() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        if (this.console != null) {
            manager.removeConsoles(new IConsole[]{this.console});
            this.console = null;
            this.outStream = null;
            this.errStream = null;
        }
    }

    public MessageConsole findConsole(String name) {
        boolean found = false;
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        MessageConsole console = null;
        if (name != null) {
            int i = 0;
            while (i < consoles.length) {
                if (name.equals(consoles[i].getName())) {
                    console = (MessageConsole)consoles[i];
                    found = true;
                    break;
                }
                ++i;
            }
        }
        if (!found) {
            console = new MessageConsole(name, null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        }
        return console;
    }

    public void showConsoleView() {
        if (this.console != null) {
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.console);
        }
    }

    public synchronized void printMessage(InfoType type, Object ... arg) {
        if (this.console != null) {
            this.console.activate();
        }
        if (arg == null) {
            return;
        }
        MessageConsoleStream output = null;
        String prefix = this.dateFormat.format(new Date());
        String format = (String)arg[0];
        Object[] extra = Arrays.copyOfRange(arg, 1, arg.length);
        switch (type) {
            case INFO: {
                output = this.outStream;
                prefix = String.valueOf(prefix) + " Info: ";
                break;
            }
            case WARNING: {
                output = this.errStream;
                prefix = String.valueOf(prefix) + " Warning: ";
                break;
            }
            case ERROR: {
                output = this.errStream;
                prefix = String.valueOf(prefix) + " Error: ";
                break;
            }
            default: {
                prefix = String.valueOf(prefix) + " ";
                output = this.outStream;
            }
        }
        String error = String.format(String.valueOf(prefix) + format, extra);
        if (output != null) {
            output.println(error);
        }
    }

    public void printNone(Object ... arg) {
        this.printMessage(InfoType.NONE, arg);
    }

    public void printWarning(Object ... arg) {
        this.printMessage(InfoType.WARNING, arg);
    }

    public void printError(Object ... arg) {
        this.printMessage(InfoType.ERROR, arg);
    }

    public void printInfo(Object ... arg) {
        this.printMessage(InfoType.INFO, arg);
    }

    public static enum InfoType {
        NONE,
        INFO,
        WARNING,
        ERROR;

    }
}

