/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.internal.TextEditorPropertyAction;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.WhitespaceCharacterPainter;

public class ShowWhitespaceAction
extends TextEditorPropertyAction {
    private Map fPainters;
    private boolean isWhitespaceShowing;
    private boolean[] fNeedsPainters;

    public ShowWhitespaceAction(MergeSourceViewer[] viewers, boolean[] needsPainters) {
        super(CompareMessages.ShowWhitespaceAction_0, viewers, "showWhitespaceCharacters");
        this.fNeedsPainters = needsPainters;
        this.synchronizeWithPreference();
    }

    protected boolean toggleState(boolean checked) {
        if (this.fNeedsPainters == null) {
            return false;
        }
        if (checked) {
            this.showWhitespace();
        } else {
            this.hideWhitespace();
        }
        return true;
    }

    private synchronized Map getPainters() {
        if (this.fPainters == null) {
            this.fPainters = new HashMap();
        }
        return this.fPainters;
    }

    private void showWhitespace() {
        if (this.isWhitespaceShowing) {
            return;
        }
        try {
            Map painters = this.getPainters();
            MergeSourceViewer[] viewers = this.getViewers();
            int i = 0;
            while (i < viewers.length) {
                if (this.fNeedsPainters[i]) {
                    MergeSourceViewer viewer = viewers[i];
                    WhitespaceCharacterPainter painter = new WhitespaceCharacterPainter((ITextViewer)viewer.getSourceViewer());
                    viewer.getSourceViewer().addPainter((IPainter)painter);
                    painters.put(viewer, painter);
                }
                ++i;
            }
        }
        finally {
            this.isWhitespaceShowing = true;
        }
    }

    private void hideWhitespace() {
        Map painters = this.getPainters();
        Iterator iterator = painters.keySet().iterator();
        while (iterator.hasNext()) {
            MergeSourceViewer viewer = (MergeSourceViewer)iterator.next();
            WhitespaceCharacterPainter painter = (WhitespaceCharacterPainter)painters.get(viewer);
            if (painter == null) continue;
            viewer.getSourceViewer().removePainter((IPainter)painter);
            painter.deactivate(true);
        }
        painters.clear();
        this.isWhitespaceShowing = false;
    }
}

