/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.tuning.core.util.transmit.driver.uart;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class UartClient {
    String portControl;
    SerialPort serialPort;
    static final String PROTOCOL_PREFIX = "uart://";
    Logger logger = Logger.getLogger(UartClient.class.getName());

    public UartClient(String portControl) {
        this.portControl = portControl;
    }

    public void connect(String port, int timeout, int buadRate) throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)port);
        if (portIdentifier.isCurrentlyOwned()) {
            this.logger.info("Error: Port is currently in use");
            return;
        }
        CommPort commPort = portIdentifier.open(this.getClass().getName(), timeout);
        if (commPort instanceof SerialPort) {
            this.serialPort = (SerialPort)commPort;
            this.serialPort.setSerialPortParams(buadRate, 8, 1, 0);
        }
    }

    String receive(DataInputStream in) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int nb = 0;
        byte[] inputData = new byte[1025];
        do {
            if ((nb = in.read(inputData, 0, inputData.length - 1)) <= 0) continue;
            if (inputData[nb - 1] == 0) {
                --nb;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            stringBuilder.append(new String(inputData, 0, nb));
        } while (in.available() > 0);
        String response = stringBuilder.toString();
        this.logger.info(() -> "uart://:" + this.portControl + " << " + response);
        return response;
    }

    public void request(String query, Complete complete) {
        String response = this.request(query);
        if (response != null && complete != null) {
            complete.run(response);
        }
    }

    /*
     * Loose catch block
     */
    public String request(String query, int timeout) {
        if (this.serialPort == null) {
            try {
                this.connect(this.portControl, timeout, 115200);
            }
            catch (Exception e2222) {
                e2222.printStackTrace();
                return null;
            }
        }
        try {
            Throwable e2222 = null;
            Object var4_7 = null;
            try {
                String string;
                DataOutputStream out;
                DataInputStream in;
                block21: {
                    block20: {
                        in = new DataInputStream(this.serialPort.getInputStream());
                        out = new DataOutputStream(this.serialPort.getOutputStream());
                        this.send(out, query);
                        string = this.receive(in);
                        if (out == null) break block20;
                        out.close();
                    }
                    if (in == null) break block21;
                    in.close();
                }
                return string;
                {
                    catch (Throwable e2222) {
                        try {
                            if (out != null) {
                                out.close();
                            }
                            throw e2222;
                        }
                        catch (Throwable throwable) {
                            if (e2222 == null) {
                                e2222 = throwable;
                            } else if (e2222 != throwable) {
                                e2222.addSuppressed(throwable);
                            }
                            if (in != null) {
                                in.close();
                            }
                            throw e2222;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (e2222 == null) {
                    e2222 = throwable;
                } else if (e2222 != throwable) {
                    e2222.addSuppressed(throwable);
                }
                throw e2222;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String request(String query) {
        return this.request(query, 120000);
    }

    void send(DataOutputStream out, String query) throws IOException {
        out.writeBytes(query);
        out.writeByte(0);
        out.flush();
        this.logger.info(() -> "uart://:" + this.portControl + " >> " + query);
    }

    public static interface Complete {
        public void run(String var1);
    }
}

