/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.tuning.core.util.transmit.driver.tcp;

import com.verisilicon.tuning.core.util.transmit.buffer.Buffer;
import com.verisilicon.tuning.core.util.transmit.buffer.BufferQueue;
import com.verisilicon.tuning.core.util.transmit.exception.MyRuntimeException;
import com.verisilicon.tuning.core.util.transmit.output.Output;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Logger;

public class TcpClient {
    String ip;
    int portControl;
    int portStream;
    Socket socketControl;
    Socket socketStream;
    public boolean isStreaming;
    public static int streamTimeout = 5;
    public static int controlTimeout = 5;
    Streaming streaming;
    Output output;
    BufferQueue bufferQueue = new BufferQueue(4);
    BufferHandler dqBufferHandler;
    BufferHandler qBufferHandler;
    static final String PROTOCOL_PREFIX = "tcp://";
    Logger logger = Logger.getLogger(TcpClient.class.getName());

    public Output getOutput() {
        return this.output;
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    public BufferQueue getBufferQueue() {
        return this.bufferQueue;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TcpClient(String ip, int portControl, int portStream, BufferHandler dqBufferHandler, BufferHandler qBufferHandler) {
        this.ip = ip;
        this.portControl = portControl;
        this.portStream = portStream;
        this.dqBufferHandler = this.bufferQueue::inputPop;
        this.qBufferHandler = this.bufferQueue::outputPush;
    }

    String receive(DataInputStream in) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int nb = 0;
        byte[] inputData = new byte[3200000];
        boolean isFinished = false;
        do {
            if ((nb = in.read(inputData, 0, inputData.length)) <= 0) continue;
            if (inputData[nb - 1] == 0) {
                isFinished = true;
                --nb;
            }
            stringBuilder.append(new String(inputData, 0, nb));
        } while (!isFinished);
        String response = stringBuilder.toString();
        this.logger.info(() -> PROTOCOL_PREFIX + this.ip + ":" + this.portControl + " << " + response);
        return response;
    }

    void receive(DataInputStream in, Buffer buffer) throws MyRuntimeException, IOException {
        int nb;
        int count = 0;
        do {
            if ((nb = in.read(buffer.dataGet(), count, buffer.lengthGet() - count)) < 0) {
                throw new MyRuntimeException("Connection error...");
            }
            if (nb != 0) continue;
            throw new MyRuntimeException("Connection closed...");
        } while ((count += nb) < buffer.lengthGet());
    }

    public void request(String query, Complete complete) throws Exception {
        String response = this.request(query);
        if (response != null && complete != null) {
            complete.run(response);
        }
    }

    public String request(String query, int timeout) throws Exception {
        if (this.socketControl == null || this.socketControl.isClosed()) {
            try {
                this.socketControl = new Socket(this.ip, this.portControl);
                this.socketControl.setSoTimeout(controlTimeout * 1000);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
        DataInputStream in = new DataInputStream(this.socketControl.getInputStream());
        DataOutputStream out = new DataOutputStream(this.socketControl.getOutputStream());
        this.send(out, query);
        return this.receive(in);
    }

    public String request(String query) throws Exception {
        return this.request(query, 5000);
    }

    public void close() throws IOException {
        if (this.socketControl != null && !this.socketControl.isClosed()) {
            this.socketControl.close();
        }
    }

    void send(DataOutputStream out, String query) throws IOException {
        BufferedOutputStream bo = new BufferedOutputStream(out);
        byte[] buff = query.getBytes();
        bo.write(buff, 0, query.length());
        bo.write(0);
        bo.flush();
        this.logger.info(() -> PROTOCOL_PREFIX + this.ip + ":" + this.portControl + " >> " + query);
    }

    void loopStream(DataInputStream in, Buffer buffer) throws Exception {
        this.receive(in, buffer);
    }

    public void streamStart() throws Exception {
        this.isStreaming = true;
        if (this.socketStream == null || this.socketStream.isClosed()) {
            try {
                this.socketStream = new Socket(this.ip, this.portStream);
                this.socketStream.setSoTimeout(streamTimeout * 1000);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.isStreaming = false;
                throw e;
            }
        }
        this.streaming = new Streaming(this);
        this.streaming.start();
    }

    public void streamStop() {
        this.isStreaming = false;
        try {
            this.streaming.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    public static interface BufferHandler {
        public void run(Buffer var1);
    }

    public static interface Complete {
        public void run(String var1);
    }

    class Streaming
    extends Thread {
        TcpClient tcpClient;

        public Streaming(TcpClient tcpClient2) {
            this.tcpClient = tcpClient2;
        }

        @Override
        public void run() {
            try {
                Buffer buffer = new Buffer();
                DataInputStream in = new DataInputStream(this.tcpClient.socketStream.getInputStream());
                while (TcpClient.this.isStreaming) {
                    try {
                        TcpClient.this.dqBufferHandler.run(buffer);
                    }
                    catch (MyRuntimeException myRuntimeException) {
                        continue;
                    }
                    try {
                        TcpClient.this.loopStream(in, buffer);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        TcpClient.this.isStreaming = false;
                    }
                    TcpClient.this.qBufferHandler.run(buffer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

