/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.tuning.core.util.transmit.buffer;

import com.verisilicon.tuning.core.util.transmit.buffer.Buffer;
import com.verisilicon.tuning.core.util.transmit.exception.MyRuntimeException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;

public class BufferQueue {
    int maxSize = 0;
    Logger logger = Logger.getLogger(BufferQueue.class.getName());
    Queue<Buffer> queueInput = new LinkedList<Buffer>();
    Queue<Buffer> queueOutput = new LinkedList<Buffer>();
    private final Semaphore mutexProtect = new Semaphore(1);
    private final Semaphore mutexSync = new Semaphore(1);

    public BufferQueue(int maxSize) {
        this.maxSize = maxSize;
    }

    public BufferQueue(int maxSize, int bufferLength) {
        Buffer buffer = new Buffer(bufferLength);
        int i = 0;
        while (i < maxSize) {
            this.inputPush(buffer);
            ++i;
        }
    }

    public void inputPop(Buffer buffer) throws MyRuntimeException {
        this.mutexProtect.acquireUninterruptibly();
        if (this.queueInput.isEmpty()) {
            this.mutexProtect.release();
            throw new MyRuntimeException("Overflow");
        }
        buffer.copy(this.queueInput.poll());
        this.mutexProtect.release();
    }

    public void inputPush(Buffer buffer) {
        this.mutexProtect.acquireUninterruptibly();
        this.queueInput.add(buffer);
        this.mutexProtect.release();
    }

    public void outputPop(Buffer buffer) throws MyRuntimeException {
        if (this.queueOutput.isEmpty()) {
            this.mutexSync.acquireUninterruptibly();
        }
        this.mutexProtect.acquireUninterruptibly();
        if (this.queueOutput.isEmpty()) {
            this.mutexProtect.release();
            throw new MyRuntimeException("Underflow");
        }
        buffer.copy(this.queueOutput.poll());
        this.mutexProtect.release();
    }

    public void outputPush(Buffer buffer) {
        this.mutexProtect.acquireUninterruptibly();
        this.queueOutput.add(buffer);
        this.mutexProtect.release();
        if (!this.queueOutput.isEmpty()) {
            this.mutexSync.release();
        }
    }

    public void bufferLengthSet(int newBufferLength) {
        this.mutexProtect.acquireUninterruptibly();
        while (!this.queueInput.isEmpty()) {
            this.queueInput.poll();
        }
        while (!this.queueOutput.isEmpty()) {
            this.queueOutput.poll();
        }
        Buffer buffer = new Buffer(newBufferLength);
        int i = 0;
        while (i < this.maxSize) {
            this.queueInput.add(buffer);
            ++i;
        }
        this.mutexProtect.release();
    }
}

