/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.util;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.nebula.visualization.xygraph.util.SingleSourceHelper2;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Transform;

public final class GraphicsUtil {
    private static boolean isRAP = SWT.getPlatform().startsWith("rap");

    public static final void drawVerticalText(Graphics graphics, String text, int x, int y, boolean upToDown) {
        block11: {
            try {
                if (SWT.getPlatform().startsWith("rap")) {
                    throw new Exception();
                }
                try {
                    graphics.pushState();
                    graphics.translate(x, y);
                    if (upToDown) {
                        graphics.rotate(90.0f);
                        graphics.drawText(text, 0, -FigureUtilities.getTextExtents((String)text, (Font)graphics.getFont()).height);
                    } else {
                        graphics.rotate(270.0f);
                        graphics.drawText(text, -FigureUtilities.getTextWidth((String)text, (Font)graphics.getFont()), 0);
                    }
                }
                finally {
                    graphics.popState();
                }
            }
            catch (Exception exception) {
                Image image = null;
                try {
                    image = SingleSourceHelper2.createVerticalTextImage(text, graphics.getFont(), graphics.getForegroundColor().getRGB(), upToDown);
                    graphics.drawImage(image, x, y);
                }
                finally {
                    if (image == null) break block11;
                    image.dispose();
                }
            }
        }
    }

    public static final void drawVerticalText(Graphics graphics, String text, Point location, boolean upToDown) {
        GraphicsUtil.drawVerticalText(graphics, text, location.x, location.y, upToDown);
    }

    public static final boolean isRAP() {
        return isRAP;
    }

    public static GC createGC(Drawable image) {
        try {
            return (GC)GC.class.getConstructor(Drawable.class).newInstance(image);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setTransform(GC gc, Transform transform) {
        try {
            GC.class.getMethod("setTransform", Transform.class).invoke((Object)gc, transform);
        }
        catch (Exception exception) {
            return;
        }
    }

    public static Cursor createCursor(Device device, ImageData imageData, int width, int height) {
        try {
            return (Cursor)Cursor.class.getConstructor(Device.class, ImageData.class, Integer.TYPE, Integer.TYPE).newInstance(device, imageData, width, height);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

