/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.linearscale;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.visualization.internal.xygraph.utils.LargeNumberUtils;
import org.eclipse.nebula.visualization.xygraph.linearscale.IScaleProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.Tick;

public class TickFactory {
    private TickFormatting formatOfTicks;
    private static final BigDecimal EPSILON = new BigDecimal("1.0E-20");
    private static final int DIGITS_UPPER_LIMIT = 6;
    private static final int DIGITS_LOWER_LIMIT = -6;
    private static final double ROUND_FRACTION = 2.0E-6;
    private static final BigDecimal BREL_ERROR = new BigDecimal("1e-15");
    private static final double REL_ERROR = BREL_ERROR.doubleValue();
    private double graphMin;
    private double graphMax;
    private String tickFormat;
    private IScaleProvider scale;
    private int numberOfIntervals;
    private boolean isReversed;
    private static final DecimalFormat INDEX_FORMAT = new DecimalFormat("0");
    private static final int LOWEST_LOG_10 = -323;
    private static final int LOWER_LOG_10 = -311;
    private static final int HIGHEST_LOG_10 = 308;

    public TickFactory(IScaleProvider scale) {
        this(TickFormatting.useCustom, scale);
    }

    public TickFactory(TickFormatting format, IScaleProvider scale) {
        this.formatOfTicks = format;
        this.scale = scale;
    }

    private String getTickString(double value) {
        if (this.scale != null) {
            value = this.scale.getLabel(value);
        }
        String returnString = "";
        if (Double.isNaN(value)) {
            return returnString;
        }
        switch (this.formatOfTicks) {
            case autoMode: {
                returnString = String.format(this.tickFormat, value);
                break;
            }
            case useExponent: {
                returnString = String.format(this.tickFormat, value);
                break;
            }
            case roundAndChopMode: {
                returnString = String.format("%d", Math.round(value));
                break;
            }
            case useSIunits: {
                double absValue = Math.abs(value);
                if (absValue == 0.0) {
                    returnString = String.format("%6.2f", value);
                    break;
                }
                if (absValue <= 1.0E-15) {
                    returnString = String.format("%6.2ff", value * 1.0E15);
                    break;
                }
                if (absValue <= 1.0E-12) {
                    returnString = String.format("%6.2fp", value * 1.0E12);
                    break;
                }
                if (absValue <= 1.0E-9) {
                    returnString = String.format("%6.2fn", value * 1.0E9);
                    break;
                }
                if (absValue <= 1.0E-6) {
                    returnString = String.format("%6.2f\u00c2\u00b5", value * 1000000.0);
                    break;
                }
                if (absValue <= 0.001) {
                    returnString = String.format("%6.2fm", value * 1000.0);
                    break;
                }
                if (absValue < 1000.0) {
                    returnString = String.format("%6.2f", value);
                    break;
                }
                if (absValue < 1000000.0) {
                    returnString = String.format("%6.2fk", value * 0.001);
                    break;
                }
                if (absValue < 1.0E9) {
                    returnString = String.format("%6.2fM", value * 1.0E-6);
                    break;
                }
                if (absValue < 1.0E12) {
                    returnString = String.format("%6.2fG", value * 1.0E-9);
                    break;
                }
                if (absValue < 1.0E15) {
                    returnString = String.format("%6.2fT", value * 1.0E-12);
                    break;
                }
                if (!(absValue < 1.0E18)) break;
                returnString = String.format("%6.2fP", value * 1.0E-15);
                break;
            }
            case useCustom: {
                returnString = this.scale.format(value);
            }
        }
        return returnString;
    }

    private void createFormatString(int precision, boolean useExponent) {
        switch (this.formatOfTicks) {
            case autoMode: {
                this.tickFormat = useExponent ? String.format("%%.%de", precision) : String.format("%%.%df", precision);
                break;
            }
            case useExponent: {
                this.tickFormat = String.format("%%.%de", precision);
                break;
            }
            default: {
                this.tickFormat = null;
            }
        }
    }

    protected static double roundDown(BigDecimal numerator, BigDecimal denominator) {
        int ns = numerator.signum();
        if (ns == 0) {
            return 0.0;
        }
        int ds = denominator.signum();
        if (ds == 0) {
            throw new IllegalArgumentException("Zero denominator is not allowed");
        }
        BigDecimal[] x = (numerator = numerator.abs()).divideAndRemainder(denominator = denominator.abs());
        double rx = x[1].doubleValue();
        if (rx > 0.999998 * denominator.doubleValue()) {
            x[1] = BigDecimal.ZERO;
            x[0] = x[0].add(BigDecimal.ONE);
        } else if (rx < 2.0E-6 * denominator.doubleValue()) {
            x[1] = BigDecimal.ZERO;
        }
        int xs = x[1].signum();
        if (xs == 0) {
            return ns != ds ? -x[0].multiply(denominator).doubleValue() : x[0].multiply(denominator).doubleValue();
        }
        if (xs < 0) {
            throw new IllegalStateException("Cannot happen!");
        }
        if (ns != ds) {
            return x[0].signum() == 0 ? -denominator.doubleValue() : -x[0].add(BigDecimal.ONE).multiply(denominator).doubleValue();
        }
        return x[0].multiply(denominator).doubleValue();
    }

    protected static double roundUp(BigDecimal numerator, BigDecimal denominator) {
        int xs;
        int ns = numerator.signum();
        if (ns == 0) {
            return 0.0;
        }
        int ds = denominator.signum();
        if (ds == 0) {
            throw new IllegalArgumentException("Zero denominator is not allowed");
        }
        BigDecimal[] x = (numerator = numerator.abs()).divideAndRemainder(denominator = denominator.abs());
        double rx = x[1].doubleValue();
        if (rx != 0.0) {
            if (rx < 2.0E-6 * denominator.doubleValue()) {
                x[1] = BigDecimal.ZERO;
            } else if (rx > 0.999998 * denominator.doubleValue()) {
                x[1] = BigDecimal.ZERO;
                x[0] = x[0].add(BigDecimal.ONE);
            }
        }
        if ((xs = x[1].signum()) == 0) {
            return ns != ds ? -x[0].multiply(denominator).doubleValue() : x[0].multiply(denominator).doubleValue();
        }
        if (xs < 0) {
            throw new IllegalStateException("Cannot happen!");
        }
        if (ns != ds) {
            return x[0].signum() == 0 ? 0.0 : -x[0].multiply(denominator).doubleValue();
        }
        return x[0].add(BigDecimal.ONE).multiply(denominator).doubleValue();
    }

    private static int log10(BigDecimal x) {
        int c = x.compareTo(BigDecimal.ONE);
        int e = 0;
        while (c < 0) {
            --e;
            x = x.scaleByPowerOfTen(1);
            c = x.compareTo(BigDecimal.ONE);
        }
        c = x.compareTo(BigDecimal.TEN);
        while (c >= 0) {
            ++e;
            x = x.scaleByPowerOfTen(-1);
            c = x.compareTo(BigDecimal.TEN);
        }
        return e;
    }

    private static BigDecimal divide(BigDecimal dividend, int divisor) {
        return dividend.divide(BigDecimal.valueOf(divisor), dividend.scale() + 2, RoundingMode.DOWN);
    }

    protected static BigDecimal nicenum(BigDecimal x, boolean round) {
        boolean negative = x.signum() == -1;
        x = x.abs();
        int expv = TickFactory.log10(x);
        BigDecimal bf = x.scaleByPowerOfTen(-expv);
        double f = bf.doubleValue();
        double nf = round ? (f < 1.5 ? 1.0 : (f < 2.25 ? 2.0 : (f < 3.25 ? 2.5 : (f < 7.5 ? 5.0 : 10.0)))) : (f <= 1.0 ? 1.0 : (f <= 2.0 ? 2.0 : (f <= 5.0 ? 5.0 : 10.0)));
        if (negative) {
            nf = -nf;
        }
        return BigDecimal.valueOf(nf).scaleByPowerOfTen(expv).stripTrailingZeros();
    }

    private double determineNumTicks(double min, double max, int maxTicks, boolean allowMinMaxOver) {
        BigDecimal bUnit;
        BigDecimal bMin = BigDecimal.valueOf(min);
        BigDecimal bMax = BigDecimal.valueOf(max);
        BigDecimal bRange = bMax.subtract(bMin);
        if (bRange.signum() < 0) {
            BigDecimal bt = bMin;
            bMin = bMax;
            bMax = bt;
            bRange = bRange.negate();
            this.isReversed = true;
        } else {
            this.isReversed = false;
        }
        BigDecimal magnitude = BigDecimal.valueOf(Math.max(Math.abs(min), Math.abs(max)));
        if (bRange.compareTo(EPSILON.multiply(magnitude)) < 0) {
            return 0.0;
        }
        try {
            if (magnitude.doubleValue() <= Double.MIN_VALUE) {
                return 0.0;
            }
        }
        catch (Throwable throwable) {}
        bRange = TickFactory.nicenum(bRange, false);
        int nTicks = maxTicks - 1;
        if (Math.signum(min) * Math.signum(max) < 0.0) {
            ++nTicks;
        }
        while (true) {
            long n;
            if ((n = bRange.divideToIntegralValue(bUnit = TickFactory.nicenum(TickFactory.divide(bRange, nTicks), true)).longValue()) > (long)maxTicks && --nTicks > 0) {
                continue;
            }
            if (allowMinMaxOver) {
                this.graphMin = TickFactory.roundDown(bMin, bUnit);
                if (this.graphMin == 0.0) {
                    this.graphMin = 0.0;
                } else if (Double.isInfinite(this.graphMin) && this.graphMin < 0.0) {
                    this.graphMin = TickFactory.roundUp(bMin, bUnit);
                }
                this.graphMax = TickFactory.roundUp(bMax, bUnit);
                if (this.graphMax == 0.0) {
                    this.graphMax = 0.0;
                } else if (Double.isInfinite(this.graphMax) && this.graphMax > 0.0) {
                    this.graphMax = TickFactory.roundDown(bMax, bUnit);
                }
            } else if (this.isReversed) {
                this.graphMin = max;
                this.graphMax = min;
            } else {
                this.graphMin = min;
                this.graphMax = max;
            }
            if (bUnit.compareTo(BREL_ERROR.multiply(magnitude)) <= 0) {
                this.numberOfIntervals = -1;
            } else {
                double factor = LargeNumberUtils.maxMagnitude(this.graphMin, this.graphMax);
                double tmp = this.graphMax / factor - this.graphMin / factor;
                this.numberOfIntervals = (int)Math.round(tmp / (bUnit.doubleValue() / factor));
            }
            if (this.numberOfIntervals <= maxTicks || --nTicks <= 0) break;
        }
        if (this.isReversed) {
            double t = this.graphMin;
            this.graphMin = this.graphMax;
            this.graphMax = t;
        }
        double tickUnit = this.isReversed ? -bUnit.doubleValue() : bUnit.doubleValue();
        int d = bUnit.scale() < 0 ? bUnit.precision() + bUnit.scale() - 1 : bUnit.scale();
        int p = (int)Math.max(Math.floor(Math.log10(Math.abs(this.graphMin))), Math.floor(Math.log10(Math.abs(this.graphMax))));
        if (p <= -6 || p >= 6) {
            this.createFormatString(Math.max(d + p, 0), true);
        } else {
            this.createFormatString(Math.max(d, 0), false);
        }
        return tickUnit;
    }

    private boolean inRange(double x, double min, double max) {
        if (this.isReversed) {
            return x >= max && x <= min;
        }
        return x >= min && x <= max;
    }

    public List<Tick> generateTicks(double min, double max, int maxTicks, boolean allowMinMaxOver, boolean tight) {
        double lo;
        ArrayList<Tick> ticks = new ArrayList<Tick>();
        double tickUnit = this.determineNumTicks(min, max, maxTicks, allowMinMaxOver);
        if (tickUnit == 0.0) {
            return ticks;
        }
        double tmin = this.graphMin / tickUnit;
        int i = 0;
        while (i <= this.numberOfIntervals) {
            block19: {
                double p;
                block18: {
                    block17: {
                        p = (tmin + (double)i) * tickUnit;
                        if (!(Math.abs(p / tickUnit) < REL_ERROR)) break block17;
                        p = 0.0;
                        break block18;
                    }
                    if (Double.isInfinite(p)) break block19;
                }
                if (!tight || this.inRange(p, min, max)) {
                    Tick newTick = new Tick();
                    newTick.setValue(p);
                    newTick.setText(this.getTickString(p));
                    ticks.add(newTick);
                }
            }
            ++i;
        }
        int imax = ticks.size();
        if (imax > 1) {
            if (!tight && allowMinMaxOver) {
                Tick t = (Tick)ticks.get(imax - 1);
                if (!this.isReversed && t.getValue() < max) {
                    t.setValue(this.graphMax);
                    t.setText(this.getTickString(this.graphMax));
                }
            }
        } else if (maxTicks > 1) {
            if (imax == 0) {
                ++imax;
                Tick newTick = new Tick();
                newTick.setValue(this.graphMin);
                newTick.setText(this.getTickString(this.graphMin));
                ticks.add(newTick);
            }
            if (imax == 1) {
                Tick t = (Tick)ticks.get(0);
                Tick newTick = new Tick();
                if (t.getText().equals(this.getTickString(this.graphMax))) {
                    newTick.setValue(this.graphMin);
                    newTick.setText(this.getTickString(this.graphMin));
                    ticks.add(0, newTick);
                } else {
                    newTick.setValue(this.graphMax);
                    newTick.setText(this.getTickString(this.graphMax));
                    ticks.add(newTick);
                }
                ++imax;
            }
        }
        double d = lo = tight || TickFactory.compare(this.isReversed, min, this.graphMin) ? min : ((Tick)ticks.get(0)).getValue();
        double hi = tight || TickFactory.compare(!this.isReversed, max, this.graphMax) ? max : (imax > 1 ? ((Tick)ticks.get(imax - 1)).getValue() : lo);
        double factor = LargeNumberUtils.maxMagnitude(lo, hi);
        double range = imax > 1 ? (hi /= factor) - (lo /= factor) : 1.0;
        for (Tick t : ticks) {
            t.setPosition((t.getValue() / factor - lo) / range);
        }
        return ticks;
    }

    private static boolean compare(boolean isGreaterThan, double a, double b) {
        if (isGreaterThan) {
            return a > b;
        }
        return a < b;
    }

    public List<Tick> generateIndexBasedTicks(double min, double max, int maxTicks) {
        ArrayList<Tick> ticks;
        block17: {
            block18: {
                double v;
                double vmax;
                double vmin;
                block19: {
                    double p0;
                    boolean bl = this.isReversed = min > max;
                    if (this.isReversed) {
                        double t = max;
                        max = min;
                        min = t;
                    }
                    ticks = new ArrayList<Tick>();
                    double gRange = TickFactory.nicenum(BigDecimal.valueOf(max - min), false).doubleValue();
                    double tickUnit = 1.0;
                    this.numberOfIntervals = 0;
                    int it = maxTicks - 1;
                    while (this.numberOfIntervals < 1) {
                        tickUnit = Math.max(1.0, TickFactory.nicenum(BigDecimal.valueOf(gRange / (double)it++), true).doubleValue());
                        tickUnit = Math.floor(tickUnit);
                        this.graphMin = Math.ceil(Math.ceil(min / tickUnit) * tickUnit);
                        this.graphMax = Math.floor(Math.floor(max / tickUnit) * tickUnit);
                        this.numberOfIntervals = (int)Math.floor((this.graphMax - this.graphMin) / tickUnit);
                        if (tickUnit == 1.0) break;
                    }
                    switch (this.formatOfTicks) {
                        case autoMode: {
                            this.tickFormat = "%g";
                            break;
                        }
                        case useExponent: {
                            this.tickFormat = "%e";
                            break;
                        }
                        default: {
                            this.tickFormat = null;
                        }
                    }
                    if (this.isReversed) {
                        p0 = this.graphMax;
                        tickUnit = -tickUnit;
                    } else {
                        p0 = this.graphMin;
                    }
                    int i = 0;
                    while (i <= this.numberOfIntervals) {
                        double p = p0 + (double)i * tickUnit;
                        Tick newTick = new Tick();
                        newTick.setValue(p);
                        newTick.setText(this.getTickString(p));
                        ticks.add(newTick);
                        ++i;
                    }
                    double lo = Math.min(min, this.graphMin);
                    double hi = Math.max(max, this.graphMax);
                    if (this.isReversed) {
                        double t = hi;
                        hi = lo;
                        lo = t;
                    }
                    double range = this.numberOfIntervals > 0 ? hi - lo : 1.0;
                    for (Tick t : ticks) {
                        t.setPosition((t.getValue() - lo) / range);
                    }
                    if (this.formatOfTicks != TickFormatting.autoMode) break block17;
                    if (this.scale == null || !this.scale.isLabelCustomised()) break block18;
                    vmin = Double.POSITIVE_INFINITY;
                    vmax = Double.NEGATIVE_INFINITY;
                    boolean allInts = true;
                    for (Tick t : ticks) {
                        v = Math.abs(this.scale.getLabel(t.getValue()));
                        if (Double.isNaN(v)) continue;
                        if (allInts) {
                            boolean bl2 = allInts = Math.abs(v - Math.floor(v)) == 0.0;
                        }
                        if ((v = Math.abs(v)) < vmin && v > 0.0) {
                            vmin = v;
                        }
                        if (!(v > vmax)) continue;
                        vmax = v;
                    }
                    if (!allInts) break block19;
                    for (Tick t : ticks) {
                        v = this.scale.getLabel(t.getValue());
                        if (Double.isNaN(v)) continue;
                        t.setText(INDEX_FORMAT.format(v));
                    }
                    break block17;
                }
                if (!(Math.log10(vmin) >= -6.0) && !(Math.log10(vmax) <= 6.0)) break block17;
                for (Tick t : ticks) {
                    v = this.scale.getLabel(t.getValue());
                    if (Double.isNaN(v)) continue;
                    t.setText(this.scale.format(v));
                }
                break block17;
            }
            for (Tick t : ticks) {
                t.setText(INDEX_FORMAT.format(t.getValue()));
            }
        }
        return ticks;
    }

    private int determineNumLogTicks(double min, double max, int maxTicks, boolean allowMinMaxOver) {
        BigDecimal bd;
        boolean bl = this.isReversed = min > max;
        if (this.isReversed) {
            double t = min;
            min = max;
            max = t;
        }
        this.graphMin = Math.log10(min);
        this.graphMax = Math.log10(max);
        int loDecade = (int)Math.floor(this.graphMin);
        if (loDecade < -323) {
            loDecade = -323;
        } else if (loDecade < -311 && (bd = BigDecimal.valueOf(min).scaleByPowerOfTen(-loDecade)).doubleValue() >= 10.0) {
            ++loDecade;
        }
        int hiDecade = (int)Math.ceil(this.graphMax);
        if (hiDecade > 308) {
            hiDecade = 308;
        }
        int decades = hiDecade - loDecade;
        int unit = (decades + maxTicks - 1) / maxTicks;
        if (allowMinMaxOver) {
            this.graphMin = loDecade;
            this.numberOfIntervals = (decades + unit - 1) / unit;
            if (hiDecade < 308) {
                this.graphMax = this.numberOfIntervals * unit + loDecade;
            } else if (loDecade > -323) {
                this.graphMax = hiDecade;
            } else {
                this.graphMax = hiDecade;
                unit = decades / this.numberOfIntervals;
                this.graphMin = hiDecade - this.numberOfIntervals * unit;
            }
        } else {
            this.numberOfIntervals = (int)Math.floor(this.graphMax - this.graphMin) / unit;
        }
        if (this.isReversed) {
            double t = this.graphMin;
            this.graphMin = this.graphMax;
            this.graphMax = t;
        }
        if (loDecade < -3 || hiDecade > 3 || decades > 6) {
            this.createFormatString(0, true);
        } else {
            this.createFormatString(Math.max(-loDecade, 0), false);
        }
        return this.isReversed ? -unit : unit;
    }

    private boolean inRangeLog(double x, double min, double max) {
        if (this.isReversed) {
            return x >= (max -= BREL_ERROR.doubleValue()) && x <= min;
        }
        return x >= (min -= BREL_ERROR.doubleValue()) && x <= max;
    }

    public List<Tick> generateLogTicks(double min, double max, int maxTicks, boolean allowMinMaxOver, boolean tight) {
        Tick newTick;
        boolean r;
        double x;
        if (min <= 0.0 || max <= 0.0) {
            throw new IllegalArgumentException("Non-positive minimum and maximum values are not allowed");
        }
        ArrayList<Tick> ticks = new ArrayList<Tick>();
        int tickUnit = this.determineNumLogTicks(min, max, maxTicks, allowMinMaxOver);
        double p = this.graphMin;
        int i = 0;
        while (i <= this.numberOfIntervals) {
            x = Math.pow(10.0, p);
            r = this.inRangeLog(x, min, max);
            if (!tight || r) {
                newTick = new Tick();
                newTick.setValue(x);
                newTick.setText(this.getTickString(x));
                ticks.add(newTick);
            }
            p += (double)tickUnit;
            ++i;
        }
        int imax = ticks.size();
        if (imax < this.numberOfIntervals) {
            x = Math.pow(10.0, p);
            r = this.inRangeLog(x, min, max);
            if (!tight || r) {
                newTick = new Tick();
                newTick.setValue(x);
                newTick.setText(this.getTickString(x));
                ticks.add(newTick);
                ++imax;
            }
        }
        if (imax > 1) {
            if (!tight && allowMinMaxOver) {
                Tick t = (Tick)ticks.get(imax - 1);
                if (!this.isReversed && t.getValue() < max) {
                    double x2 = Math.pow(10.0, this.graphMax);
                    t.setValue(x2);
                    t.setText(this.getTickString(x2));
                }
            }
        } else if (maxTicks > 1) {
            if (imax == 0) {
                ++imax;
                Tick newTick2 = new Tick();
                double x3 = Math.pow(10.0, this.isReversed ? this.graphMax : this.graphMin);
                newTick2.setValue(x3);
                newTick2.setText(this.getTickString(x3));
                ticks.add(newTick2);
            }
            if (imax == 1 && !tight && allowMinMaxOver) {
                Tick t = (Tick)ticks.get(0);
                Tick newTick3 = new Tick();
                double x4 = Math.pow(10.0, this.graphMax);
                if (t.getText().equals(this.getTickString(x4))) {
                    x4 = Math.pow(10.0, this.graphMin);
                    newTick3.setValue(x4);
                    newTick3.setText(this.getTickString(x4));
                    ticks.add(0, newTick3);
                } else {
                    newTick3.setValue(x4);
                    newTick3.setText(this.getTickString(x4));
                    ticks.add(newTick3);
                }
                ++imax;
            }
        }
        double lo = Math.log(tight ? min : ((Tick)ticks.get(0)).getValue());
        double hi = Math.log(tight ? max : ((Tick)ticks.get(imax - 1)).getValue());
        double range = hi - lo;
        for (Tick t : ticks) {
            t.setPosition((Math.log(t.getValue()) - lo) / range);
        }
        return ticks;
    }

    public static enum TickFormatting {
        autoMode,
        roundAndChopMode,
        useExponent,
        useSIunits,
        useCustom;

    }
}

