/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.util;

import java.util.Arrays;

public class LinearFitter {
    private int length;
    private double[] xSample;
    private double[] ySample;

    public void setSamples(double[] _xSample, double[] _ySample) {
        this.length = Math.min(_xSample.length, _ySample.length);
        this.xSample = Arrays.copyOf(_xSample, _xSample.length);
        this.ySample = Arrays.copyOf(_ySample, _ySample.length);
    }

    public double spline(double x) {
        if (this.length == 0) {
            return 0.0;
        }
        int klo = 0;
        int khi = this.length - 1;
        while (khi - klo > 1) {
            int k = khi + klo >> 1;
            if (this.xSample[k] > x) {
                khi = k;
                continue;
            }
            klo = k;
        }
        double h = this.xSample[khi] - this.xSample[klo];
        if (h == 0.0) {
            throw new ArithmeticException();
        }
        double a = (this.xSample[khi] - x) / h;
        return this.ySample[khi] - a * (this.ySample[khi] - this.ySample[klo]);
    }
}

