/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ImageFormatConverter {
    public static void YUV444P2RGB(byte[] input, int width, int height, byte[] output) {
        if (input == null) {
            return;
        }
        int rgbIndex = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                int index = j * width + i;
                int y = input[index] & 0xFF;
                int u = input[index + width * height] & 0xFF;
                int v = input[index + width * height * 2] & 0xFF;
                int r = y + 1 * (v - 128);
                int g = y - (int)(0.698001f * (float)(u - 128) + 0.337633f * (float)(v - 128));
                int b = y + 1 * (u - 128);
                int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
                int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
                b = b > 255 ? 255 : (b < 0 ? 0 : b);
                output[rgbIndex++] = (byte)r;
                output[rgbIndex++] = (byte)g;
                output[rgbIndex++] = (byte)b;
                ++i;
            }
            ++j;
        }
    }

    public static void YUV444I2RGB(byte[] input, int width, int height, byte[] output) {
        if (input == null) {
            return;
        }
        int yuvIndex = 0;
        int rgbIndex = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                int y = input[yuvIndex++] & 0xFF;
                int u = input[yuvIndex++] & 0xFF;
                int v = input[yuvIndex++] & 0xFF;
                int r = y + 1 * (v - 128);
                int g = y - (int)(0.698001f * (float)(u - 128) + 0.337633f * (float)(v - 128));
                int b = y + 1 * (u - 128);
                int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
                int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
                b = b > 255 ? 255 : (b < 0 ? 0 : b);
                output[rgbIndex++] = (byte)r;
                output[rgbIndex++] = (byte)g;
                output[rgbIndex++] = (byte)b;
                ++i;
            }
            ++j;
        }
    }

    public static void YUV422I2RGB(byte[] input, int width, int height, byte[] output) {
        if (input == null) {
            return;
        }
        int size = width * height;
        int rgbIndex = 0;
        int i = 0;
        while (i < width * height) {
            int y = input[i] & 0xFF;
            int u = input[size + i / 2] & 0xFF;
            int v = input[size + size / 2 + i / 2] & 0xFF;
            int r = y + 1 * (v - 128);
            int g = y - (int)(0.344136 * (double)(u - 128) + 0.714136 * (double)(v - 128));
            int b = y + 1 * (u - 128);
            int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
            int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
            b = b > 255 ? 255 : (b < 0 ? 0 : b);
            output[rgbIndex++] = (byte)r;
            output[rgbIndex++] = (byte)g;
            output[rgbIndex++] = (byte)b;
            ++i;
        }
    }

    public static void YUV422P2RGB(byte[] input, int width, int height, byte[] output) {
        if (input == null) {
            return;
        }
        int size = width * height;
        int rgbIndex = 0;
        int i = 0;
        while (i < width * height) {
            int y = input[i] & 0xFF;
            int v = input[size + i / 2] & 0xFF;
            int u = input[size + size / 2 + i / 2] & 0xFF;
            int r = y + 1 * (v - 128);
            int g = y - (int)(0.344136 * (double)(u - 128) + 0.714136 * (double)(v - 128));
            int b = y + 1 * (u - 128);
            int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
            int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
            b = b > 255 ? 255 : (b < 0 ? 0 : b);
            output[rgbIndex++] = (byte)r;
            output[rgbIndex++] = (byte)g;
            output[rgbIndex++] = (byte)b;
            ++i;
        }
    }

    public static void NV162RGB(byte[] input, int width, int height, byte[] output) {
        if (input == null) {
            return;
        }
        int nvOff = width * height;
        int yIndex = 0;
        int nvIndex = 0;
        int rgbIndex = 0;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                nvIndex = i * width / 2 + j / 2;
                int y = input[yIndex] & 0xFF;
                int u = input[nvOff + nvIndex * 2] & 0xFF;
                int v = input[nvOff + nvIndex * 2 + 1] & 0xFF;
                int r = y + (360 * (v - 128) >> 8);
                int g = y - (184 * (v - 128) + 88 * (u - 128) >> 8);
                int b = y + (455 * (u - 128) >> 8);
                int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
                int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
                b = b > 255 ? 255 : (b < 0 ? 0 : b);
                output[rgbIndex++] = (byte)r;
                output[rgbIndex++] = (byte)g;
                output[rgbIndex++] = (byte)b;
                ++j;
                ++yIndex;
            }
            ++i;
        }
    }

    public static void YUV420SP2RGB(byte[] input, int width, int height, byte[] output) {
        if (input == null) {
            return;
        }
        int size = width * height;
        int nvIndex = 0;
        int rgbIndex = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                int index = j * width + i;
                nvIndex = j / 2 * width + i - i % 2;
                int y = input[index] & 0xFF;
                int u = input[size + nvIndex] & 0xFF;
                int v = input[size + nvIndex + 1] & 0xFF;
                int r = y + 1 * (v - 128);
                int g = y - (int)(0.698001 * (double)(u - 128) + 0.337633 * (double)(v - 128));
                int b = y + 1 * (u - 128);
                int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
                int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
                b = b > 255 ? 255 : (b < 0 ? 0 : b);
                output[rgbIndex++] = (byte)r;
                output[rgbIndex++] = (byte)g;
                output[rgbIndex++] = (byte)b;
                ++i;
            }
            ++j;
        }
    }

    public static void YUV420P2RGB(byte[] input, int width, int height, byte[] output) {
        if (input == null) {
            return;
        }
        int size = width * height;
        int rgbIndex = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                int index = j * width + i;
                int y = input[index] & 0xFF;
                int u = input[size + j / 2 * (width / 2) + i / 2] & 0xFF;
                int v = input[size + size / 4 + j / 2 * (width / 2) + i / 2] & 0xFF;
                int r = y + 1 * (v - 128);
                int g = y - (int)(0.344136 * (double)(u - 128) + 0.714136 * (double)(v - 128));
                int b = y + 1 * (u - 128);
                int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
                int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
                b = b > 255 ? 255 : (b < 0 ? 0 : b);
                output[rgbIndex++] = (byte)r;
                output[rgbIndex++] = (byte)g;
                output[rgbIndex++] = (byte)b;
                ++i;
            }
            ++j;
        }
    }

    public static int[] rgb24ToPixel(byte[] rgb24, int width, int height) {
        int[] pix = new int[rgb24.length / 3];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int color;
                int idx = width * i + j;
                int rgbIdx = idx * 3;
                byte r = rgb24[rgbIdx];
                byte g = rgb24[rgbIdx + 1];
                byte b = rgb24[rgbIdx + 2];
                pix[idx] = color = b & 0xFF | g << 8 & 0xFF00 | r << 16 & 0xFF0000;
                ++j;
            }
            ++i;
        }
        return pix;
    }

    public static byte[] joinByteArray(byte[] byte1, byte[] byte2) {
        return ByteBuffer.allocate(byte1.length + byte2.length).put(byte1).put(byte2).array();
    }

    public static byte[] convertToByte(String fileName, int width, int height) {
        byte[] bytes;
        int len;
        DataInputStream dis;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        int size = width * height * 2;
        byte[] raw8Data = new byte[width * height];
        if (fileName.indexOf("RAW10") >= 0) {
            dis = new DataInputStream(is);
            len = (int)new File(fileName).length();
            bytes = new byte[len];
            try {
                dis.readFully(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] raw10Data = new byte[width * height * 2];
            len -= 2;
            int k = size - 1;
            while (k >= 0) {
                raw10Data[k] = bytes[len--];
                --k;
            }
            int[] pixels = new int[size / 2];
            int x = 0;
            int k2 = 0;
            while (x < size / 2) {
                int b0 = Byte.toUnsignedInt(raw10Data[k2]);
                int b1 = Byte.toUnsignedInt(raw10Data[k2 + 1]);
                pixels[x] = (b0 & 3) << 8 | b1;
                ++x;
                k2 += 2;
            }
            int min = Arrays.stream(pixels).min().getAsInt();
            int max = Arrays.stream(pixels).max().getAsInt();
            double scale = 256.0 / (double)(max - min + 1);
            int k3 = 0;
            while (k3 < size / 2) {
                int value = (pixels[k3] & 0xFFFF) - min;
                if (value < 0) {
                    value = 0;
                }
                if ((value = (int)((double)value * scale + 0.5)) > 255) {
                    value = 255;
                }
                raw8Data[k3] = (byte)value;
                ++k3;
            }
        } else if (fileName.indexOf("RAW12") >= 0) {
            dis = new DataInputStream(is);
            len = (int)new File(fileName).length();
            bytes = new byte[len];
            try {
                dis.readFully(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] raw12Data = new byte[width * height * 2];
            len -= 2;
            int k = size - 1;
            while (k >= 0) {
                raw12Data[k] = bytes[len--];
                --k;
            }
            int[] pixels = new int[size / 2];
            int x = 0;
            int k4 = 0;
            while (x < size / 2) {
                int b0 = Byte.toUnsignedInt(raw12Data[k4]);
                int b1 = Byte.toUnsignedInt(raw12Data[k4 + 1]);
                pixels[x] = (b0 & 0xF) << 8 | b1;
                ++x;
                k4 += 2;
            }
            int min = Arrays.stream(pixels).min().getAsInt();
            int max = Arrays.stream(pixels).max().getAsInt();
            double scale = 256.0 / (double)(max - min + 1);
            int k5 = 0;
            while (k5 < size / 2) {
                int value = (pixels[k5] & 0xFFFF) - min;
                if (value < 0) {
                    value = 0;
                }
                if ((value = (int)((double)value * scale + 0.5)) > 255) {
                    value = 255;
                }
                raw8Data[k5] = (byte)value;
                ++k5;
            }
        } else if (fileName.indexOf("RAW16") >= 0) {
            byte[] bytes2 = new byte[size];
            int count = 0;
            while (count < size && count >= 0) {
                try {
                    count = ((InputStream)is).read(bytes2, count, size - count);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            int[] pixels = new int[size / 2];
            int x = 0;
            int k = 0;
            while (x < size / 2) {
                int b0 = Byte.toUnsignedInt(bytes2[k]);
                int b1 = Byte.toUnsignedInt(bytes2[k + 1]);
                pixels[x] = b0 << 8 | b1;
                int grayData = pixels[x] * 255 / 65535 & 0xFF;
                raw8Data[x] = (byte)grayData;
                ++x;
                k += 2;
            }
        }
        byte[] magic = ImageFormatConverter.joinByteArray("P5".getBytes(), "\n".getBytes());
        byte[] wid = ImageFormatConverter.joinByteArray(ImageFormatConverter.joinByteArray(magic, Integer.toString(width).getBytes()), " ".getBytes());
        byte[] he = ImageFormatConverter.joinByteArray(ImageFormatConverter.joinByteArray(wid, Integer.toString(height).getBytes()), "\n".getBytes());
        byte[] maxVal = ImageFormatConverter.joinByteArray(ImageFormatConverter.joinByteArray(he, Integer.toString(255).getBytes()), "\n".getBytes());
        byte[] innnn = ImageFormatConverter.joinByteArray(maxVal, raw8Data);
        return innnn;
    }
}

