/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.util;

import java.util.Arrays;

public class CubicSplineFitter {
    private int length;
    private double[] xSample;
    private double[] ySample;
    private boolean initialized = false;
    private double[] splineYSample;

    public void setSamples(double[] _xSample, double[] _ySample) {
        this.length = Math.min(_xSample.length, _ySample.length);
        this.xSample = Arrays.copyOf(_xSample, _xSample.length);
        this.ySample = Arrays.copyOf(_ySample, _ySample.length);
        this.initialized = false;
    }

    public double spline(double x) {
        if (this.length == 0) {
            return 0.0;
        }
        if (!this.initialized) {
            double[] us = new double[this.length - 1];
            this.splineYSample = new double[this.length];
            this.splineYSample[0] = 0.0;
            us[0] = 0.0;
            int i = 1;
            while (i <= this.length - 2) {
                double sig = (this.xSample[i] - this.xSample[i - 1]) / (this.xSample[i + 1] - this.xSample[i - 1]);
                double p = sig * this.splineYSample[i - 1] + 2.0;
                this.splineYSample[i] = (sig - 1.0) / p;
                us[i] = (this.ySample[i + 1] - this.ySample[i]) / (this.xSample[i + 1] - this.xSample[i]) - (this.ySample[i] - this.ySample[i - 1]) / (this.xSample[i] - this.xSample[i - 1]);
                us[i] = (6.0 * us[i] / (this.xSample[i + 1] - this.xSample[i - 1]) - sig * us[i - 1]) / p;
                ++i;
            }
            double un = 0.0;
            double qn = 0.0;
            this.splineYSample[this.length - 1] = (un - qn * us[this.length - 2]) / (qn * this.splineYSample[this.length - 2] + 1.0);
            int k = this.length - 2;
            while (k >= 0) {
                this.splineYSample[k] = this.splineYSample[k] * this.splineYSample[k + 1] + us[k];
                --k;
            }
            this.initialized = true;
        }
        int klo = 0;
        int khi = this.length - 1;
        while (khi - klo > 1) {
            int k = khi + klo >> 1;
            if (this.xSample[k] > x) {
                khi = k;
                continue;
            }
            klo = k;
        }
        double h = this.xSample[khi] - this.xSample[klo];
        if (h == 0.0) {
            throw new ArithmeticException();
        }
        double a = (this.xSample[khi] - x) / h;
        double b = (x - this.xSample[klo]) / h;
        return a * this.ySample[klo] + b * this.ySample[khi] + ((a * a * a - a) * this.splineYSample[klo] + (b * b * b - b) * this.splineYSample[khi]) * (h * h) / 6.0;
    }
}

