/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.transfer;

import com.verisilicon.isp.tuning.core.bean.ServerConfigBean;
import com.verisilicon.isp.tuning.core.transfer.IClient;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.tuning.core.util.transmit.buffer.BufferQueue;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TcpClient
implements IClient {
    private String httpHost;
    private String httpPort;
    private String uri;
    private static com.verisilicon.tuning.core.util.transmit.driver.tcp.TcpClient tcpClient;
    private Lock lock = new ReentrantLock();

    public TcpClient(ServerConfigBean config) {
        this.httpHost = config.getHttpHost();
        this.httpPort = config.getHttpPort();
        this.uri = "tcp://" + this.httpHost + ":" + this.httpPort;
        BufferQueue bufferQueue = new BufferQueue(4);
        tcpClient = new com.verisilicon.tuning.core.util.transmit.driver.tcp.TcpClient(this.httpHost, Integer.parseInt(this.httpPort), 45679, arg_0 -> ((BufferQueue)bufferQueue).inputPop(arg_0), arg_0 -> ((BufferQueue)bufferQueue).outputPush(arg_0));
    }

    public com.verisilicon.tuning.core.util.transmit.driver.tcp.TcpClient getTcpClient() {
        return tcpClient;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String request(String request, int timeout) throws Exception {
        String response = null;
        try {
            try {
                this.lock.lock();
                response = tcpClient.request(request, timeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
        return response;
    }

    @Override
    public String request(String request) throws Exception {
        return this.request(request, 5000);
    }

    @Override
    public boolean testConnection() {
        boolean connected = false;
        try {
            InetAddress serverAddr = InetAddress.getByName(this.httpHost);
            Socket s = new Socket(serverAddr, Integer.parseInt(this.httpPort));
            connected = s.isConnected();
            ConsoleLogger.print("Tcp connection successful");
            s.close();
        }
        catch (IOException e) {
            ConsoleLogger.print("Error: " + e.getMessage());
        }
        return connected;
    }

    @Override
    public void dispose() {
    }
}

