/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.transfer;

import cn.hutool.http.HttpRequest;
import com.verisilicon.isp.tuning.core.bean.ServerConfigBean;
import com.verisilicon.isp.tuning.core.transfer.IClient;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;

public class HttpClient
implements IClient {
    private String httpHost;
    private String httpPort;
    private String uri;
    private static final int TIME_OUT = 5000;

    public HttpClient(ServerConfigBean config) {
        this.httpHost = config.getHttpHost();
        this.httpPort = config.getHttpPort();
        this.uri = "http://" + this.httpHost + ":" + this.httpPort;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String request(String request, int timeout) throws Exception {
        return HttpRequest.post((String)(String.valueOf(this.httpHost) + ":" + this.httpPort)).body(request).timeout(timeout).execute().body();
    }

    @Override
    public String request(String request) throws Exception {
        return this.request(request, 5000);
    }

    @Override
    public boolean testConnection() {
        System.out.println("HttpClient.testConnection()");
        boolean connected = false;
        try {
            this.request("{\"category\":\"ISP\",\"key\":\"isEnable\"}");
            connected = true;
            System.out.println("connected: " + connected);
            ConsoleLogger.print("Http connection successful");
        }
        catch (Exception e) {
            ConsoleLogger.print("Error: " + e.getMessage());
            e.printStackTrace();
        }
        return connected;
    }

    @Override
    public void dispose() {
    }
}

