/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.transfer;

import cn.hutool.setting.Setting;
import com.verisilicon.isp.tuning.core.bean.ServerConfigBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.manager.StorageManager;
import com.verisilicon.isp.tuning.core.transfer.HttpClient;
import com.verisilicon.isp.tuning.core.transfer.IClient;
import com.verisilicon.isp.tuning.core.transfer.TcpClient;
import com.verisilicon.isp.tuning.core.transfer.UartClient;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import java.net.SocketTimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;

public class ClientHolder {
    private static ClientHolder clientHolder;
    private IClient client;
    public static final String MSG_CONNECTION_FAILED = "Connection failed";
    public static final String MSG_TIME_OUT = "Timeout";
    public static final Object SET_CONFIG_REQUEST_FAMILY;
    public static final Object GET_CONFIG_REQUEST_FAMILY;
    private final int TIME_OUT = 5000;
    private String responseString = null;
    private String responseSendStr = null;
    private String pluginId = "";

    static {
        SET_CONFIG_REQUEST_FAMILY = new Object();
        GET_CONFIG_REQUEST_FAMILY = new Object();
    }

    public ClientHolder(ServerConfigBean config) {
        this.updateServerConfig(config);
    }

    public void setPluginId(String id) {
        this.pluginId = id;
    }

    public IClient getClient() {
        return this.client;
    }

    public static ClientHolder getInstance() {
        if (clientHolder == null) {
            clientHolder = new ClientHolder(new ServerConfigBean());
        }
        return clientHolder;
    }

    public void updateServerConfig(ServerConfigBean config) {
        if (this.client != null) {
            this.client.dispose();
        }
        if (config == null) {
            return;
        }
        if (config.getServerType() == ServerConfigBean.ServerType.HTTP) {
            this.client = new HttpClient(config);
        } else if (config.getServerType() == ServerConfigBean.ServerType.TCP) {
            Setting setting = StorageManager.getSettingFromConfigIniFile();
            com.verisilicon.tuning.core.util.transmit.driver.tcp.TcpClient.controlTimeout = setting.getInt((Object)"tcp.controlTimeout", Integer.valueOf(10));
            com.verisilicon.tuning.core.util.transmit.driver.tcp.TcpClient.streamTimeout = setting.getInt((Object)"tcp.streamTimeout", Integer.valueOf(10));
            System.out.println("tcp.controlTimeout = " + com.verisilicon.tuning.core.util.transmit.driver.tcp.TcpClient.controlTimeout);
            System.out.println("tcp.streamTimeout = " + com.verisilicon.tuning.core.util.transmit.driver.tcp.TcpClient.streamTimeout);
            this.client = new TcpClient(config);
        } else if (config.getServerType() == ServerConfigBean.ServerType.UART) {
            this.client = new UartClient(config);
        }
    }

    public boolean testConnection(ServerConfigBean config) {
        boolean ret = false;
        if (config == null) {
            if (this.client != null) {
                ret = this.client.testConnection();
            }
        } else {
            if (config.getServerType() == ServerConfigBean.ServerType.HTTP) {
                this.client = new HttpClient(config);
            } else if (config.getServerType() == ServerConfigBean.ServerType.TCP) {
                this.client = new TcpClient(config);
            } else if (config.getServerType() == ServerConfigBean.ServerType.UART) {
                this.client = new UartClient(config);
            } else assert (false);
            if (this.client != null) {
                ret = this.client.testConnection();
            }
        }
        return ret;
    }

    private void handleJobStatus(IStatus status) {
        if (status == null) {
            return;
        }
        int severity = status.getSeverity();
        String message = status.getMessage();
        boolean connectStatus = true;
        if (severity == 2) {
            ConsoleLogger.printWarningMsg(message);
        } else if (severity == 4) {
            ConsoleLogger.printErrorMsg(message);
        }
        if (message != null && message.equals(MSG_CONNECTION_FAILED)) {
            connectStatus = false;
        }
        boolean connected = connectStatus;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EventManager.getInstance().notifyEvent("EVENT_STATUS_UPDATE", connected);
            }
        });
    }

    public void sendAsyncLastChangeWriteRequest(String requestString, Object familyObject, ResponseListener listener) {
        this.sendAsyncLastChangeWriteRequest(requestString, familyObject, listener, 5000);
    }

    public void sendAsyncLastChangeWriteRequest(String requestString, Object familyObject, ResponseListener listener, int timeout) {
        System.out.println("ClientHolder.sendLastChangedRequest() => " + requestString);
        Job.getJobManager().cancel(familyObject);
        Job requestJob = new Job("Request"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    ConsoleLogger.print(" >> " + requestString);
                    ClientHolder.this.responseString = ClientHolder.this.client.request(requestString, timeout);
                    ConsoleLogger.print(" << " + ClientHolder.this.responseString);
                }
                catch (Exception exception) {
                    monitor.done();
                    return new Status(2, ClientHolder.this.pluginId, ClientHolder.MSG_CONNECTION_FAILED);
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == familyObject;
            }
        };
        requestJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                ClientHolder.this.handleJobStatus(event.getResult());
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (event.getResult() == Status.OK_STATUS) {
                            listener.success(ClientHolder.this.responseString);
                        } else {
                            listener.failed(ClientHolder.this.responseString);
                        }
                    }
                });
            }
        });
        requestJob.schedule(500L);
    }

    public void sendAsyncRequest(String requestString, ResponseListener listener) {
        this.sendAsyncRequest(requestString, listener, 5000);
    }

    public void sendAsyncRequest(String requestString, ResponseListener listener, int timeout) {
        Job requestSendJob = new Job("Send Request"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    ConsoleLogger.print(" >> " + ClientHolder.this.shortenLogString(requestString));
                    ClientHolder.this.responseSendStr = ClientHolder.this.client.request(requestString, timeout);
                    ConsoleLogger.print(" << " + ClientHolder.this.shortenLogString(ClientHolder.this.responseSendStr));
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    monitor.done();
                    ConsoleLogger.printErrorMsg(" << request timed out!");
                    return new Status(2, ClientHolder.this.pluginId, ClientHolder.MSG_TIME_OUT);
                }
                catch (Exception exception) {
                    monitor.done();
                    return new Status(2, ClientHolder.this.pluginId, ClientHolder.MSG_CONNECTION_FAILED);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        requestSendJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                ClientHolder.this.handleJobStatus(event.getResult());
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (event.getResult() == Status.OK_STATUS) {
                            listener.success(ClientHolder.this.responseSendStr);
                        } else {
                            listener.failed(event.getResult().getMessage());
                        }
                    }
                });
            }
        });
        requestSendJob.schedule();
    }

    public String sendSyncRequest(String requestString) {
        return this.sendSyncRequest(requestString, 5000);
    }

    public String sendSyncRequest(String requestString, int timeout) {
        try {
            ConsoleLogger.print(" >> " + this.shortenLogString(requestString));
            this.responseSendStr = this.client.request(requestString);
            ConsoleLogger.print(" << " + this.shortenLogString(this.responseSendStr));
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ConsoleLogger.printErrorMsg(" << request timed out!");
        }
        catch (Exception e) {
            ConsoleLogger.printErrorMsg(e.getMessage());
            EventManager.getInstance().notifyEvent("EVENT_STATUS_UPDATE", false);
            this.responseSendStr = null;
        }
        return this.responseSendStr;
    }

    public void dispose() {
        this.client.dispose();
    }

    public String getURI() {
        return this.client.getURI();
    }

    public String shortenLogString(String logString) {
        String keyword = ";base64,";
        String dots = "......";
        int base64KeepHeadLength = 5;
        int base64KeepTailLength = 5;
        int currentPos = 0;
        int base64indexPos = logString.indexOf(keyword);
        while (base64indexPos > 0) {
            int base64endPos = logString.indexOf("\"", base64indexPos);
            String head = logString.substring(0, base64indexPos += keyword.length() + base64KeepHeadLength);
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(head);
            currentPos = head.length();
            strBuilder.append(dots);
            String tail = logString.substring(base64endPos -= base64KeepTailLength, logString.length());
            strBuilder.append(tail);
            logString = strBuilder.toString();
            base64indexPos = logString.indexOf(keyword, currentPos += dots.length());
        }
        return logString;
    }

    public static interface ResponseListener {
        public void success(String var1);

        public void failed(String var1);
    }
}

