/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.test;

import com.verisilicon.isp.tuning.core.util.ImageFormatConverter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UtilTest {
    public static void main(String[] args) {
        UtilTest.testYUV2RGB();
    }

    public static void testYUV2RGB() {
        long currentTime = System.currentTimeMillis();
        File imagefile = new File("D:\\CD_ISP_SW\\cn9452\\YUV_20230506095140913.yuv");
        ByteArrayOutputStream os = new ByteArrayOutputStream((int)imagefile.length());
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(imagefile));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        byte[] buffer = new byte[1024];
        try {
            while (in.read(buffer) > 0) {
                os.write(buffer);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int width = 1920;
        int height = 1080;
        byte[] yuvByte = os.toByteArray();
        byte[] rgbByte = new byte[width * height * 3];
        System.out.println("Read image data cost time: " + String.valueOf(System.currentTimeMillis() - currentTime));
        currentTime = System.currentTimeMillis();
        ImageFormatConverter.YUV444P2RGB(yuvByte, width, height, rgbByte);
        ImageData imageData = new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
        imageData.data = rgbByte;
        System.out.println("Convert YUV to RGB cost time: " + String.valueOf(System.currentTimeMillis() - currentTime));
        currentTime = System.currentTimeMillis();
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 1232);
        shell.setSize(500, 400);
        shell.setLayout((Layout)new GridLayout());
        Canvas canvas = new Canvas((Composite)shell, 0x20000000);
        canvas.setBounds(0, 40, 640, 360);
        GridData canvasGridData = new GridData(4, 4, true, true, 1, 1);
        canvasGridData.grabExcessVerticalSpace = true;
        canvas.setLayoutData((Object)canvasGridData);
        Image image = new Image((Device)canvas.getDisplay(), imageData);
        canvas.getDisplay().asyncExec(() -> {
            if (!canvas.isDisposed()) {
                GC gc = new GC((Drawable)canvas);
                int ww = canvas.getShell().getBounds().width * 1;
                int hh = canvas.getShell().getBounds().height * 1;
                long time = System.currentTimeMillis();
                gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, ww, hh);
                System.out.println("Draw image to canvas cost time: " + String.valueOf(System.currentTimeMillis() - time));
                gc.dispose();
                image.dispose();
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

