/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.test;

import com.verisilicon.isp.tuning.core.test.MyValidator;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class RoiTest {
    static Image image;
    static Cursor crosshairCursor;
    static Cursor defaultCursor;
    private static int startX;
    private static int startY;
    private static int endX;
    private static int endY;
    private static int offsetX;
    private static int offsetY;
    static boolean mouseDown;
    static int ww;
    static int hh;
    static int roiNums;
    static LinkedList<RoiInfo> roiInfos;
    static LinkedList<RoiInfo> undoList;
    static LinkedList<RoiInfo> redoList;

    static {
        crosshairCursor = new Cursor(null, 2);
        defaultCursor = new Cursor(null, 21);
        startX = 0;
        startY = 0;
        endX = 0;
        endY = 0;
        offsetX = 0;
        offsetY = 0;
        mouseDown = false;
        ww = 1920;
        hh = 1080;
        roiNums = 10;
        roiInfos = new LinkedList();
        undoList = new LinkedList();
        redoList = new LinkedList();
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 1232);
        shell.setSize(500, 400);
        shell.setLayout((Layout)new GridLayout());
        ToolBar toolBar = new ToolBar((Composite)shell, 0);
        ToolItem selectBtn = new ToolItem(toolBar, 8);
        ToolItem undoBtn = new ToolItem(toolBar, 8);
        ToolItem redoBtn = new ToolItem(toolBar, 8);
        ToolItem modifyBtn = new ToolItem(toolBar, 8);
        undoBtn.setText("Undo");
        undoBtn.setEnabled(false);
        redoBtn.setText("Redo");
        redoBtn.setEnabled(false);
        modifyBtn.setText("Modify");
        modifyBtn.setEnabled(true);
        Canvas cvs = new Canvas((Composite)shell, 0x20000800);
        cvs.setLayoutData((Object)new GridData(4, 4, true, true));
        cvs.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (image != null) {
                    event.gc.fillRectangle(0, 0, cvs.getClientArea().width, cvs.getClientArea().height);
                    event.gc.setForeground(Display.getCurrent().getSystemColor(3));
                    event.gc.drawImage(image, 0, 0, RoiTest.image.getBounds().width, RoiTest.image.getBounds().height, 0, 0, cvs.getClientArea().width, cvs.getClientArea().height);
                    event.gc.drawRectangle(startX * cvs.getClientArea().width / ww, startY * cvs.getClientArea().height / hh, offsetX * cvs.getClientArea().width / ww, offsetY * cvs.getClientArea().height / hh);
                    for (RoiInfo roiInfo : roiInfos) {
                        event.gc.drawRectangle(roiInfo.x * cvs.getClientArea().width / ww, roiInfo.y * cvs.getClientArea().height / hh, roiInfo.w * cvs.getClientArea().width / ww, roiInfo.h * cvs.getClientArea().height / hh);
                    }
                }
            }
        });
        selectBtn.setText("File");
        selectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                String[] extensions = new String[]{".jpg", ".bmp", ".*"};
                fileDialog.setFilterNames(extensions);
                fileDialog.open();
                if (fileDialog.getFileName() != null && !fileDialog.getFileName().equals("")) {
                    String imagePath = String.valueOf(fileDialog.getFilterPath()) + "\\" + fileDialog.getFileName();
                    image = new Image((Device)Display.getDefault(), imagePath);
                    if (image != null) {
                        cvs.setCursor(crosshairCursor);
                        cvs.redraw();
                    }
                }
            }
        });
        undoBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                startX = 0;
                startY = 0;
                offsetX = 0;
                offsetY = 0;
                redoBtn.setEnabled(true);
                if (roiInfos.size() > 0) {
                    undoList.add(roiInfos.removeLast());
                    if (roiInfos.size() <= 0) {
                        undoBtn.setEnabled(false);
                    }
                }
                cvs.redraw();
            }
        });
        redoBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                startX = 0;
                startY = 0;
                offsetX = 0;
                offsetY = 0;
                undoBtn.setEnabled(true);
                if (undoList.size() > 0) {
                    roiInfos.add(undoList.removeLast());
                    if (undoList.size() <= 0) {
                        redoBtn.setEnabled(false);
                    }
                }
                cvs.redraw();
            }
        });
        cvs.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                mouseDown = false;
                roiInfos.add(new RoiInfo(startX, startY, offsetX, offsetY));
                undoBtn.setEnabled(true);
            }

            public void mouseDown(MouseEvent e) {
                if (roiInfos.size() >= roiNums) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"warning", (String)("You have added " + roiNums + " regions of image"));
                    return;
                }
                mouseDown = true;
                startX = e.x * ww / cvs.getClientArea().width;
                startY = e.y * hh / cvs.getClientArea().height;
            }
        });
        cvs.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (mouseDown) {
                    if (e.x >= cvs.getClientArea().x + cvs.getClientArea().width) {
                        e.x = cvs.getClientArea().x + cvs.getClientArea().width;
                    } else if (e.x <= cvs.getClientArea().x) {
                        e.x = cvs.getClientArea().x;
                    }
                    if (e.y >= cvs.getClientArea().y + cvs.getClientArea().height) {
                        e.y = cvs.getClientArea().y + cvs.getClientArea().height;
                    } else if (e.y <= cvs.getClientArea().y) {
                        e.y = cvs.getClientArea().y;
                    }
                    offsetX = e.x * ww / cvs.getClientArea().width - startX;
                    offsetY = e.y * hh / cvs.getClientArea().height - startY;
                    cvs.redraw();
                }
            }
        });
        modifyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), "Modify Roi Nums", "Please input new Rois nums", String.valueOf(roiNums), (IInputValidator)new MyValidator());
                inputDialog.open();
                if (inputDialog.getValue() != null) {
                    String numsStr = inputDialog.getValue();
                    roiNums = Integer.parseInt(numsStr);
                    undoBtn.setEnabled(false);
                    redoBtn.setEnabled(false);
                    roiInfos.clear();
                    redoList.clear();
                    undoList.clear();
                    startX = 0;
                    startY = 0;
                    offsetX = 0;
                    offsetY = 0;
                    cvs.redraw();
                }
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!crosshairCursor.isDisposed()) {
                    crosshairCursor.dispose();
                }
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    static class RoiInfo {
        int x;
        int y;
        int w;
        int h;

        public RoiInfo(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

