/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.test;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.bean.ServerConfigBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ImageFormatConverter;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.eclipse.core.resources.ResourcesPlugin;

class Main {
    private static final String BASE64_PREFIX_XML = "data:text/xml;base64,";
    private static final String BASE64_PREFIX_JSON = "data:text/json;base64,";

    Main() {
    }

    public static void main(String[] args) {
        Scanner s = new Scanner(System.in);
        try {
            while (true) {
                String input;
                if ((input = s.nextLine()).equals("q")) {
                    return;
                }
                String[] t = input.split("\\s+");
                Main.handleInputList(t);
            }
        }
        catch (IllegalStateException | NoSuchElementException runtimeException) {
            return;
        }
    }

    private static List<ParamBean> requestParams(int num) {
        ArrayList<ParamBean> params = new ArrayList<ParamBean>();
        ParamBean snapNumParamBean = new ParamBean("Snapshot Number", "range");
        snapNumParamBean.getValue().setCurrentValue(num);
        snapNumParamBean.setCategory("OPT");
        params.add(snapNumParamBean);
        return params;
    }

    private static List<ParamBean> responseParams() {
        ArrayList<ParamBean> params = new ArrayList<ParamBean>();
        ParamBean imageParamBean = new ParamBean("Images", "file");
        imageParamBean.setCategory("OPT");
        params.add(imageParamBean);
        return params;
    }

    private static String makeQueryString(String widthInput, String heightInput, boolean isVideo, int bayperPattern, int bit, List<String> imagePath) {
        FileInputStream in = null;
        String BASE64_PREFIX = "data:image/raw;base64,";
        String[] bayerPatternArray = new String[]{"RGGB", "GRBG", "GBRG", "BGGR", "BGGIR", "GRIRG", "RGGIR", "GBIRG", "GIRRG", "IRGGB", "GIRBG", "IRGGR", "RGIRB", "GRBIR", "IRBRG", "BIRGR", "BGIRR", "GBRIR", "IRRBG", "RIRGB", "RCCC", "RCCB", "RYYCY"};
        String[] bitArray = new String[]{"RAW8", "RAW10", "RAW10 Align Double Word", "RAW10 Align 16bit", "RAW12", "RAW12 Align Double Word", "RAW12 Align 16bit", "RAW14", "RAW14 Align Double Word", "RAW14 Align 16bit", "RAW16"};
        ArrayList<StringBuffer> encodes = new ArrayList<StringBuffer>();
        if (isVideo) {
            int width = Integer.valueOf(widthInput);
            int height = Integer.valueOf(heightInput);
            File file = new File(imagePath.get(0));
            String rawPicPath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/rawPics/";
            File dict = new File(rawPicPath);
            if (dict.exists()) {
                File[] fileArray = dict.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    f.delete();
                    ++n2;
                }
            }
            dict.delete();
            dict.mkdir();
            int size = 0;
            size = bit == 0 ? width * height : width * height * 2;
            try {
                int beginFrame = 0;
                int numFrame = 2;
                int frameStep = 1;
                in = new FileInputStream(file);
                long t = (long)beginFrame * (long)size;
                in.skip(t);
                int index = beginFrame;
                byte[] bytes = new byte[size];
                while (in.read(bytes) != -1) {
                    FileOutputStream fout = new FileOutputStream(dict + "\\" + String.valueOf(index++) + ".raw");
                    fout.write(bytes);
                    StringBuffer encode = new StringBuffer();
                    encode.append(Base64.getEncoder().encodeToString(bytes));
                    encodes.add(encode);
                    if (index - beginFrame >= numFrame) break;
                    in.skip((long)(frameStep - 1) * (long)size);
                }
            }
            catch (IOException event) {
                event.printStackTrace();
                return null;
            }
        } else {
            int i = 0;
            while (i < imagePath.size()) {
                File file = new File(imagePath.get(i));
                try {
                    StringBuffer encode = new StringBuffer();
                    in = new FileInputStream(file);
                    byte[] bytes = new byte[(int)file.length()];
                    in.read(bytes);
                    encode.append(Base64.getEncoder().encodeToString(bytes));
                    encodes.add(encode);
                }
                catch (IOException event) {
                    event.printStackTrace();
                    return null;
                }
                ++i;
            }
        }
        JSONArray imagesArray = new JSONArray();
        int i = 0;
        while (i < encodes.size()) {
            imagesArray.add((Object)(String.valueOf(BASE64_PREFIX) + ((StringBuffer)encodes.get(i)).toString()));
            ++i;
        }
        String category = "IPT";
        JSONObject imagesParamObject = new JSONObject();
        imagesParamObject.set("category", (Object)category);
        imagesParamObject.set("key", (Object)"images");
        JSONObject imagesValueObject = new JSONObject();
        imagesValueObject.set("current", (Object)imagesArray);
        imagesParamObject.set("value", (Object)imagesValueObject);
        JSONObject bayerPatternParamObject = new JSONObject();
        bayerPatternParamObject.set("category", (Object)category);
        bayerPatternParamObject.set("key", (Object)"bayerPattern");
        JSONObject bayerPatternValueObject = new JSONObject();
        bayerPatternValueObject.set("current", (Object)bayerPatternArray[bayperPattern]);
        bayerPatternParamObject.set("value", (Object)bayerPatternValueObject);
        JSONObject bitParamObject = new JSONObject();
        bitParamObject.set("category", (Object)category);
        bitParamObject.set("key", (Object)"bit");
        JSONObject bitValueObject = new JSONObject();
        bitValueObject.set("current", (Object)bitArray[bit]);
        bitParamObject.set("value", (Object)bitValueObject);
        JSONObject widthParamObject = new JSONObject();
        widthParamObject.set("category", (Object)category);
        widthParamObject.set("key", (Object)"width");
        JSONObject widthValueObject = new JSONObject();
        widthValueObject.set("current", (Object)new Integer(widthInput));
        widthParamObject.set("value", (Object)widthValueObject);
        JSONObject heightParamObject = new JSONObject();
        heightParamObject.set("category", (Object)category);
        heightParamObject.set("key", (Object)"height");
        JSONObject heightValueObject = new JSONObject();
        heightValueObject.set("current", (Object)new Integer(heightInput));
        heightParamObject.set("value", (Object)heightValueObject);
        JSONArray paramObjectArray = new JSONArray();
        paramObjectArray.add((Object)imagesParamObject);
        paramObjectArray.add((Object)bayerPatternParamObject);
        paramObjectArray.add((Object)bitParamObject);
        paramObjectArray.add((Object)widthParamObject);
        paramObjectArray.add((Object)heightParamObject);
        return paramObjectArray.toString();
    }

    private static JSONObject generateSingleParamRequestJsonObject(ParamBean paramBean, Boolean isWithValue) {
        JSONObject paramObject = new JSONObject();
        paramObject.set("category", (Object)paramBean.getCategory());
        paramObject.set("key", (Object)paramBean.getKey());
        if (isWithValue.booleanValue()) {
            JSONObject valueObject = new JSONObject();
            valueObject.set("current", paramBean.getValue().getCurrentValue());
            paramObject.set("value", (Object)valueObject);
        }
        return paramObject;
    }

    private static void handleInputList(String[] input) {
        switch (input[0]) {
            case "-s": {
                String serverType = input[1];
                String httpHost = input[2];
                String httpPort = input[3];
                if (serverType.equals((Object)ServerConfigBean.ServerType.valueOf("UART"))) {
                    String cfr_ignored_0 = input[4];
                }
                ServerConfigBean configBean = new ServerConfigBean();
                configBean.setServerType(ServerConfigBean.ServerType.valueOf(serverType));
                configBean.setHttpHost(httpHost);
                configBean.setHttpPort(httpPort);
                ClientHolder.getInstance().updateServerConfig(configBean);
                boolean ret = ClientHolder.getInstance().testConnection(configBean);
                if (!ret) {
                    System.out.println("FAILED CONNECT");
                }
                return;
            }
            case "-imp": {
                String loadFileName = input[1];
                boolean xmlOrjson = loadFileName.contains(".xml");
                Path loadFilePath = Paths.get(loadFileName, new String[0]);
                File loadFile = new File(loadFilePath.toString());
                ClientHolder cl = ClientHolder.getInstance();
                try {
                    FileInputStream in = new FileInputStream(loadFile);
                    byte[] bytes = new byte[(int)loadFile.length()];
                    in.read(bytes);
                    StringBuffer encode = new StringBuffer();
                    encode.append(Base64.getEncoder().encodeToString(bytes));
                    ArrayList<ParamBean> params = new ArrayList<ParamBean>();
                    ParamBean fileParamBean = new ParamBean("Setting", "file");
                    if (xmlOrjson) {
                        fileParamBean.getValue().setCurrentValue(BASE64_PREFIX_XML + encode.toString());
                    } else {
                        fileParamBean.getValue().setCurrentValue(BASE64_PREFIX_JSON + encode.toString());
                    }
                    params.add(fileParamBean);
                    JSONArray array = new JSONArray();
                    array.add(((ParamBean)params.get(0)).getValue().getValue());
                    JSONObject paramObject = new JSONObject();
                    paramObject.set("category", (Object)"ST");
                    paramObject.set("key", (Object)"Setting");
                    paramObject.set("type", (Object)"file");
                    JSONObject valueObject = new JSONObject();
                    valueObject.set("current", (Object)array);
                    paramObject.set("value", (Object)valueObject);
                    cl.sendSyncRequest(paramObject.toString(), 10000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "-w": {
                try {
                    String writeFileName = input[1];
                    Path writeFilePath = Paths.get(writeFileName, new String[0]);
                    File writeFile = new File(writeFilePath.toString());
                    String fileContent = FileUtil.readString((File)writeFile, (Charset)Charset.forName("UTF-8"));
                    List paramBeans = JSONUtil.toList((String)fileContent, ParamBean.class);
                    for (ParamBean paramBean : paramBeans) {
                        ClientHolder.getInstance().sendSyncRequest(Main.generateSingleParamRequestJsonObject(paramBean, true).toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "-r": {
                try {
                    String readFileName = input[1];
                    Path readFilePath = Paths.get(readFileName, new String[0]);
                    File readFile = new File(readFilePath.toString());
                    String fileContent = FileUtil.readString((File)readFile, (Charset)Charset.forName("UTF-8"));
                    List paramBeans = JSONUtil.toList((String)fileContent, ParamBean.class);
                    for (ParamBean paramBean : paramBeans) {
                        String response = ClientHolder.getInstance().sendSyncRequest(Main.generateSingleParamRequestJsonObject(paramBean, false).toString());
                        JSONObject paramObj = (JSONObject)JSONUtil.parse((Object)response);
                        JSONObject valueObj = paramObj.getJSONObject((Object)"value");
                        if (valueObj != null) {
                            Object curValue = valueObj.get((Object)"current");
                            paramBean.getValue().setCurrentValue(curValue);
                            continue;
                        }
                        paramBean.getValue().setCurrentValue("Error");
                    }
                    String readContent = JSONUtil.toJsonStr((JSON)JSONUtil.parse((Object)paramBeans), (int)2);
                    FileWriter fileWriter = new FileWriter(readFileName);
                    fileWriter.write("");
                    fileWriter.write(readContent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "-l": {
                String width = input[1];
                String height = input[2];
                boolean isVideo = input[3].equals("t") || input[3].equals("true");
                int bayperPattern = Integer.valueOf(input[4]);
                int bit = Integer.valueOf(input[5]);
                ArrayList<String> imaPath = new ArrayList<String>();
                int i = 6;
                while (i < input.length) {
                    imaPath.add(input[i]);
                    ++i;
                }
                String queryString = Main.makeQueryString(width, height, isVideo, bayperPattern, bit, imaPath);
                if (queryString == null) {
                    System.out.println("Error: Null Request");
                    return;
                }
                ClientHolder.getInstance().sendSyncRequest(queryString, 150000);
                break;
            }
            case "-c": {
                String inputType = input[1];
                String imaType = new String();
                if (inputType.contains("YUV")) {
                    imaType = "YUV (*.yuv)";
                }
                String path = input[2];
                int num = Integer.valueOf(input[3]);
                try {
                    ModuleDataCenter moduleDataCenter = ModuleDataCenter.getInstance(false);
                    List<String> images = moduleDataCenter.captureRequest(false, path, imaType, "", "BGGR", 1920, 1080, "linear", 8, num, Main.requestParams(num), Main.responseParams());
                    if (images == null) {
                        return;
                    }
                    int i = 0;
                    while (i < images.size()) {
                        if (images.get(i) == null) {
                            System.out.println("SnapShot " + String.valueOf(i) + ": No Image Data");
                        } else if (images.get(i).endsWith(".pgm")) {
                            BufferedImage pgmFile = null;
                            try {
                                pgmFile = ImageIO.read(new File(images.get(i)));
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            if (images.get(i).indexOf("RAW08") >= 0) {
                                try {
                                    Thumbnails.of((String[])new String[]{images.get(i)}).size(pgmFile.getWidth(), pgmFile.getHeight()).outputFormat("jpg").toFile(String.valueOf(path) + "\\temp" + i);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                byte[] in = ImageFormatConverter.convertToByte(images.get(i), pgmFile.getWidth(), pgmFile.getHeight());
                                try {
                                    Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(in)}).size(pgmFile.getWidth(), pgmFile.getHeight()).outputFormat("jpg").toFile(String.valueOf(path) + "\\temp" + i);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        } else if (images.get(i).endsWith(".ppm")) {
                            try {
                                BufferedImage ppmFile = ImageIO.read(new File(images.get(i)));
                                Thumbnails.of((File[])new File[]{new File(images.get(i))}).size(ppmFile.getWidth(), ppmFile.getHeight()).outputFormat("jpg").toFile(String.valueOf(path) + "\\temp" + i);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        } else if (images.get(i).endsWith(".yuv")) {
                            File temp = new File(images.get(i));
                            ByteArrayOutputStream os = new ByteArrayOutputStream((int)temp.length());
                            BufferedInputStream in = null;
                            try {
                                in = new BufferedInputStream(new FileInputStream(temp));
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                            }
                            byte[] buffer = new byte[1024];
                            try {
                                while (in.read(buffer) > 0) {
                                    os.write(buffer);
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            case "-h": 
            case "-help": {
                System.out.println("#####Help Information:#####");
                System.out.println("    -s ServerType HttpHost HttpPort  //Connect to Server");
                System.out.println("    -imp FilePath //Import json / xml");
                System.out.println("    -w FilePath //Write parameters in the given json / xml file with specified values");
                System.out.println("    -r FilePath //Read parameters in the given json / xml file and update their values");
                System.out.println("    -l Width Height isVideo? BayerPattern Bit //Image Input Function");
                System.out.println("    -c ImageType Path Num //Capture and save specified number of images to the given path");
                System.out.println("    -start(-stop) Frame PreViewWidth PreviewHeight PreviewMode ClientType // Start / stop the stream");
                break;
            }
            case "-stop": 
            case "-start": {
                int frame = Integer.valueOf(input[1]);
                int previewWidth = Integer.valueOf(input[2]);
                int previewHeight = Integer.valueOf(input[3]);
                String previewMode = input[4];
                String cfr_ignored_1 = input[5];
                ArrayList<ParamBean> params = new ArrayList<ParamBean>();
                ParamBean frameRateParamBean = new ParamBean("framerate", "range");
                frameRateParamBean.getValue().setCurrentValue(frame);
                frameRateParamBean.setCategory("SS");
                ParamBean heigthParamBean = new ParamBean("height", "range");
                heigthParamBean.getValue().setCurrentValue(previewHeight);
                heigthParamBean.setCategory("SS");
                ParamBean streamParamBean = new ParamBean("isStream", "toogle");
                streamParamBean.getValue().setCurrentValue(input[0].equals("-start"));
                streamParamBean.setCategory("SS");
                ParamBean widthParamBean = new ParamBean("width", "range");
                widthParamBean.getValue().setCurrentValue(previewWidth);
                widthParamBean.setCategory("SS");
                ParamBean modeParamBean = new ParamBean("mode", "range");
                modeParamBean.getValue().setCurrentValue(previewMode.toLowerCase().equals("linear") ? 0 : 1);
                modeParamBean.setCategory("SS");
                params.add(frameRateParamBean);
                params.add(heigthParamBean);
                params.add(widthParamBean);
                params.add(modeParamBean);
                params.add(streamParamBean);
                ParamGroupBean sensorGroupParamBean = new ParamGroupBean("Sensor");
                sensorGroupParamBean.setParams(params);
                ArrayList<ParamGroupBean> paramGroups = new ArrayList<ParamGroupBean>();
                paramGroups.add(sensorGroupParamBean);
                ModuleBean sensorModuleBean = new ModuleBean("Sensor");
                sensorModuleBean.setParamGroups(paramGroups);
                String streamRequestString = ModuleDataCenter.getInstance(false).generateModuleRequestJsonString(sensorModuleBean, (Boolean)true);
                try {
                    ClientHolder.getInstance().sendSyncRequest(streamRequestString, 300000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                System.out.println("Unsupported Command");
                try {
                    Thread.sleep(10000000L);
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

