/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.test;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

class GraphicTest
extends JPanel {
    private List<Integer> values = Collections.synchronizedList(new ArrayList());
    private static final int MAX_VALUE = 100;
    private static final int MIN_VALUE = -100;
    private static final int MAX_COUNT_OF_VALUES = 40;

    public GraphicTest() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                new Random();
                int i = 5;
                try {
                    while (true) {
                        GraphicTest.this.addValue((int)(Math.sin(i++) * 100.0));
                        GraphicTest.this.repaint();
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        double xDelta = w / 40;
        int length = this.values.size();
        int i = 0;
        while (i < length - 1) {
            g2d.drawLine((int)(xDelta * (double)(40 - length + i)), (int)((double)h / 200.0 * (double)(-(this.values.get(i) - 100))), (int)(xDelta * (double)(40 - length + i + 1)), (int)((double)h / 200.0 * (double)(-(this.values.get(i + 1) - 100))));
            ++i;
        }
    }

    private void addValue(int value) {
        if (this.values.size() > 40) {
            this.values.remove(0);
        }
        this.values.add(value);
    }

    private static void createGuiAndShow() {
        JFrame frame = new JFrame("HAHAHA");
        frame.getContentPane().add(new GraphicTest());
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 500);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        GraphicTest.createGuiAndShow();
    }
}

