/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.model;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.verisilicon.isp.tuning.core.bean.BatchParamBean;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.bean.SensorBean;
import com.verisilicon.isp.tuning.core.bean.TemplateBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.manager.StorageManager;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ModuleDataCenter {
    private List<TemplateBean> templateBeans;
    private TemplateBean currentTemplate;
    private ModuleBean currentModuleBean;
    private List<ModuleBean> templateSupportModuleBeans;
    private List<SensorBean> allSensorBeans;
    private Map<String, ModuleBean> templateModuleBeanMap;
    private static ModuleDataCenter moduleDataCenter;
    private StorageManager storageManager;
    private static String BASE64_PREFIX;
    private Map<String, String> aMMap;
    private List<String> currentFileNames;
    String[] internalModuleNames = new String[]{"Register", "Sensor", "Setting", "Input", "Output", "Tile"};

    static {
        BASE64_PREFIX = "";
    }

    public static ModuleDataCenter getInstance() {
        if (moduleDataCenter == null) {
            moduleDataCenter = new ModuleDataCenter(true);
        }
        return moduleDataCenter;
    }

    public static ModuleDataCenter getInstance(boolean needStorageManager) {
        if (moduleDataCenter == null) {
            moduleDataCenter = new ModuleDataCenter(needStorageManager);
        }
        return moduleDataCenter;
    }

    public ModuleDataCenter(boolean needStorageManager) {
        this.storageManager = needStorageManager ? new StorageManager() : null;
        this.initTemplates();
        this.loadAllSensorBeansFromWorkspace();
    }

    private void initTemplates() {
        String templateJsonString = this.storageManager.readBundleFile("/data/templates_ISP8000_V2201.json");
        assert (!StrUtil.isEmpty((CharSequence)templateJsonString));
        this.templateBeans = JSONUtil.toList((String)templateJsonString, TemplateBean.class);
        this.templateBeans.forEach(e -> {
            int i = 0;
            while (i < this.internalModuleNames.length) {
                e.getModules().add(this.internalModuleNames[i]);
                ++i;
            }
        });
    }

    public Boolean getControlValue(String path) {
        String[] pathComponents = path.split(",");
        assert (pathComponents.length == 2);
        String moduleName = pathComponents[0];
        String keyName = pathComponents[1];
        assert (this.templateSupportModuleBeans != null);
        ModuleBean moduleBean = this.templateSupportModuleBeans.stream().filter(e -> moduleName.equals(e.getModuleName())).findFirst().get();
        for (ParamGroupBean paramGroupBean : moduleBean.getParamGroups()) {
            Optional<ParamBean> result = paramGroupBean.getParams().stream().filter(e -> keyName.equals(e.getKey())).findFirst();
            if (!result.isPresent()) continue;
            ParamBean paramBean = result.get();
            assert ("toggle".equals(paramBean.getType()));
            assert (paramBean.getValue().getValue() instanceof Boolean);
            return (Boolean)paramBean.getValue().getValue();
        }
        assert (false);
        return false;
    }

    public void clear() {
        this.currentTemplate = null;
        this.currentModuleBean = null;
        this.templateSupportModuleBeans = new ArrayList<ModuleBean>();
        this.aMMap = new HashMap<String, String>();
    }

    public List<TemplateBean> getTemplateBeans() {
        return this.templateBeans;
    }

    public String getCurrentTemplateName() {
        return this.currentTemplate == null ? "" : this.currentTemplate.getTemplateName();
    }

    public TemplateBean getCurrentTemplate() {
        return this.currentTemplate;
    }

    public TemplateBean getTemplateWithName(String templateName) {
        assert (!StrUtil.isEmpty((CharSequence)templateName));
        TemplateBean templateBean = this.templateBeans.stream().filter(e -> templateName.equals(e.getTemplateName())).findFirst().orElse(null);
        return templateBean;
    }

    public void changeCurrentModule(ModuleBean moduleBean) {
        this.currentModuleBean = moduleBean;
    }

    public ModuleBean getCurrentModuleBean() {
        return this.currentModuleBean;
    }

    public List<ModuleBean> getCurrentTemplateModuleBeans() {
        return this.templateSupportModuleBeans;
    }

    public List<SensorBean> getAllSensorBeans() {
        return this.allSensorBeans;
    }

    public String readParamBean(ParamBean paramBean) {
        JSONArray paramObjectArray = new JSONArray();
        JSONObject jsonObject = this.generateSingleParamRequestJsonObject(paramBean, false);
        paramObjectArray.add((Object)jsonObject);
        String requestString = paramObjectArray.toString();
        String response = ClientHolder.getInstance().sendSyncRequest(requestString);
        return response;
    }

    public void readModuleData(ModuleBean moduleBean) throws Exception {
        if (moduleBean.isParamCloned()) {
            for (ParamGroupBean paramGroupBean : moduleBean.getParamGroups()) {
                for (ParamBean paramBean : paramGroupBean.getParams()) {
                    if (paramBean.getKey().equals("modeSwitch")) continue;
                    String response = this.readParamBean(paramBean);
                    if (response != null) {
                        this.updateModuleDataWithJsonString(response);
                        EventManager.getInstance().notifyEvent("EVENT_REFRESH_UI", null);
                        continue;
                    }
                    ConsoleLogger.printErrorMsg("ReadModuleData Failed");
                }
            }
        } else {
            String requestString = this.generateModuleRequestJsonString(moduleBean, (Boolean)false);
            if (requestString == null) {
                return;
            }
            ClientHolder.getInstance().sendAsyncRequest(requestString, new ClientHolder.ResponseListener(){

                @Override
                public void success(String response) {
                    if (response.length() == 0) {
                        ConsoleLogger.printWarningMsg("Warning: Empty Response!");
                        return;
                    }
                    try {
                        ModuleDataCenter.this.updateModuleDataWithJsonString(response);
                    }
                    catch (Exception e) {
                        ConsoleLogger.printErrorMsg("ReadModuleData Failed: {" + e.getMessage() + "}");
                    }
                    EventManager.getInstance().notifyEvent("EVENT_REFRESH_UI", null);
                }

                @Override
                public void failed(String response) {
                    ConsoleLogger.printErrorMsg("ReadModuleData Failed: " + response);
                }
            });
        }
    }

    public void readSensorModuleData(ModuleBean moduleBean) {
        String requestString = this.generateModuleRequestJsonString(moduleBean, (Boolean)false);
        String response = ClientHolder.getInstance().sendSyncRequest(requestString);
        JSONArray jsonArray = JSONUtil.parseArray((String)response);
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject paramObj = jsonArray.getJSONObject((Object)i);
            String key = paramObj.getStr((Object)"key");
            assert (moduleBean != null);
            ParamBean paramBean = moduleBean.findParamBeanByKey(key);
            if (paramBean != null) {
                JSONObject valueObj = paramObj.getJSONObject((Object)"value");
                Object curValue = valueObj.get((Object)"current");
                paramBean.getValue().setCurrentValue(curValue);
            } else {
                System.out.println("readModuleData unkown key: " + key);
            }
            ++i;
        }
    }

    public void updateModuleDataWithJsonString(String jsonStr) throws Exception {
        JSONArray jsonAr = JSONUtil.parseArray((String)jsonStr);
        int i = 0;
        while (i < jsonAr.size()) {
            JSONObject paramObj = jsonAr.getJSONObject((Object)i);
            String key = paramObj.getStr((Object)"key");
            String category = paramObj.getStr((Object)"category");
            ModuleBean moduleBean = this.templateModuleBeanMap.get(category);
            assert (moduleBean != null);
            ParamBean paramBean = moduleBean.findParamBeanByKey(key);
            if (paramBean != null) {
                JSONObject valueObj = paramObj.getJSONObject((Object)"value");
                if (valueObj == null) {
                    String message = (String)paramObj.get((Object)"message");
                    throw new Exception(String.valueOf(key) + " : " + message);
                }
                Object curValue = valueObj.get((Object)"current");
                if (curValue == null) {
                    String message = (String)paramObj.get((Object)"message");
                    throw new Exception(String.valueOf(key) + " : " + message);
                }
                paramBean.getValue().setCurrentValue(curValue);
                Object options = valueObj.get((Object)"options");
                if (options != null) {
                    JSONArray optionsArray = (JSONArray)options;
                    ArrayList<String> optionsList = new ArrayList<String>();
                    int j = 0;
                    while (j < optionsArray.size()) {
                        optionsList.add(optionsArray.getStr((Object)j));
                        ++j;
                    }
                    paramBean.getValue().setOptions(optionsList);
                }
            } else {
                throw new Exception("Message: unkown key: " + key);
            }
            ++i;
        }
    }

    public void readAllModuleData(List<ModuleBean> moduleBeans) throws Exception {
        for (ModuleBean moduleBean : moduleBeans) {
            this.readModuleData(moduleBean);
        }
    }

    public void writeModuleData(ModuleBean moduleBean, List<BatchParamBean> batchParamBeans, Map<String, String> map) throws Exception {
        if (batchParamBeans == null || batchParamBeans.size() == 0) {
            this.sendWriteModuleDataRequest(moduleBean, SendType.TUNING);
        }
    }

    public void writeAllModuleData(List<ModuleBean> moduleBeans) throws Exception {
        ArrayList<String> errorModuleName = new ArrayList<String>();
        for (ModuleBean moduleBean : moduleBeans) {
            try {
                this.sendWriteModuleDataRequest(moduleBean, SendType.ALL);
            }
            catch (Exception exception) {
                errorModuleName.add(moduleBean.getModuleName());
            }
        }
        if (errorModuleName.size() > 0) {
            throw new Exception(((Object)errorModuleName).toString());
        }
    }

    private String getFileNameWithType(String type, String bayerPattern, int width, int height, String formatMode, int outputBits, Date date) {
        String filename = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String resoluation = String.valueOf(width) + "x" + height;
        switch (type) {
            case "YUV422 Semi-Planar": {
                filename = "YUV_" + resoluation + "_" + outputBits + "bits_422sp_" + formatMode + "_" + dateFormat.format(date) + ".yuv";
                break;
            }
            case "YUV422 Interleaved": {
                filename = "YUV_" + resoluation + "_" + outputBits + "bits_422i_" + formatMode + "_" + dateFormat.format(date) + ".yuv";
                break;
            }
            case "YUV420 Semi-Planar": {
                filename = "YUV_" + resoluation + "_" + outputBits + "bits_420sp_" + formatMode + "_" + dateFormat.format(date) + ".yuv";
                break;
            }
            case "YUV444 Planer": {
                filename = "YUV_" + resoluation + "_" + outputBits + "bits_444p_" + formatMode + "_" + dateFormat.format(date) + ".yuv";
                break;
            }
            case "YUV444 Interleaved": {
                filename = "YUV_" + resoluation + "_" + outputBits + "bits_444i_" + formatMode + "_" + dateFormat.format(date) + ".yuv";
                break;
            }
            case "RGB888 Raster Scan": {
                filename = "RGB888RS_" + bayerPattern + "_" + resoluation + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "RGB888 Planar": {
                filename = "RGB888P_" + bayerPattern + "_" + resoluation + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 8bit": {
                filename = "RAW_" + resoluation + "_8bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 10bit": {
                filename = "RAW_" + resoluation + "_10bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 10bit in align mode 0": {
                filename = "RAW_" + resoluation + "_10bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 10bit in align mode 1": {
                filename = "RAW_" + resoluation + "_10bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 12bit": {
                filename = "RAW_" + resoluation + "_12bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 12bit in align mode 0": {
                filename = "RAW_" + resoluation + "_12bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 12bit in align mode 1": {
                filename = "RAW_" + resoluation + "_12bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 14bit": {
                filename = "RAW_" + resoluation + "_14bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 14bit in align mode 0": {
                filename = "RAW_" + resoluation + "_14bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 14bit in align mode 1": {
                filename = "RAW_" + resoluation + "_14bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            case "Raw 16bit": {
                filename = "RAW_" + resoluation + "_16bits_" + bayerPattern + "_" + formatMode + "_" + dateFormat.format(date) + ".raw";
                break;
            }
            default: {
                ConsoleLogger.printWarningMsg("Not support format: " + type);
            }
        }
        return filename;
    }

    public List<String> captureRequest(boolean isOutputAsOneFile, String path, String type, String pathType, String bayerPattern, int width, int height, String formatMode, int outputBits, int snapNum, List<ParamBean> setParams, List<ParamBean> queryParams) throws Exception {
        ArrayList<String> imageStr = new ArrayList<String>();
        this.currentFileNames = new ArrayList<String>();
        Date date = new Date();
        int i = 0;
        while (i < snapNum) {
            date.setTime(date.getTime() + (long)(i * 1000));
            String filename = this.getFileNameWithType(type, bayerPattern, width, height, formatMode, outputBits, date);
            if (filename == null) {
                return null;
            }
            this.currentFileNames.add(filename);
            imageStr.add(String.valueOf(path) + "\\" + filename);
            ++i;
        }
        String setRequestString = this.generateModuleRequestJsonString(setParams, (Boolean)true);
        String responseString = ClientHolder.getInstance().sendSyncRequest(setRequestString);
        if (StrUtil.isEmpty((CharSequence)responseString)) {
            return null;
        }
        JSONArray jsonAr = JSONUtil.parseArray((String)responseString);
        int i2 = 0;
        while (i2 < jsonAr.size()) {
            JSONObject paramObj = jsonAr.getJSONObject((Object)i2);
            String key = paramObj.getStr((Object)"key");
            String message = paramObj.getStr((Object)"message");
            if (!StrUtil.isEmpty((CharSequence)message)) {
                ConsoleLogger.printErrorMsg("Cpature Failed: {" + key + " : " + message + "}");
                return null;
            }
            ++i2;
        }
        String queryImageRequestString = this.generateModuleRequestJsonString(queryParams, (Boolean)false);
        responseString = ClientHolder.getInstance().sendSyncRequest(queryImageRequestString, 150000);
        if (StrUtil.isEmpty((CharSequence)responseString)) {
            return null;
        }
        JSONArray arrayJson = new JSONArray((Object)responseString);
        assert (arrayJson != null);
        JSONObject responseJson = new JSONObject((Object)arrayJson.getStr((Object)0));
        String key = responseJson.getStr((Object)"key");
        String message = responseJson.getStr((Object)"message");
        if (!StrUtil.isEmpty((CharSequence)message)) {
            ConsoleLogger.printErrorMsg("Cpature Failed: {" + key + " : " + message + "}");
            return null;
        }
        assert (key.equals("images"));
        responseJson = responseJson.getJSONObject((Object)"value");
        assert (responseJson != null);
        JSONArray imageArrayJson = responseJson.getJSONArray((Object)"current");
        if (imageArrayJson == null) {
            ConsoleLogger.printErrorMsg("Capture Failed: no images found.");
            return null;
        }
        BASE64_PREFIX = pathType.equals("Raw") ? "data:image/raw;base64," : "data:image/yuv;base64,";
        if (isOutputAsOneFile) {
            FileOutputStream out = null;
            Path localFile = new Path(path);
            StringBuffer videoName = new StringBuffer(this.currentFileNames.get(0));
            int index = videoName.indexOf(".");
            videoName.insert(index, "_video_" + snapNum);
            localFile = localFile.append(videoName.toString());
            out = new FileOutputStream(localFile.toOSString());
            int i3 = 0;
            while (i3 < snapNum) {
                String base64Str = imageArrayJson.getStr((Object)i3);
                if (base64Str == null) {
                    imageStr.set(i3, null);
                } else {
                    base64Str = base64Str.replaceFirst(BASE64_PREFIX, "");
                    Base64.Decoder decoder = Base64.getDecoder();
                    byte[] imageData = decoder.decode(base64Str);
                    out.write(imageData);
                }
                ++i3;
            }
            out.close();
            ConsoleLogger.print("Video is saving to: " + localFile.toOSString());
        } else {
            int i4 = 0;
            while (i4 < snapNum) {
                block30: {
                    String base64Str = imageArrayJson.getStr((Object)i4);
                    if (base64Str == null) {
                        imageStr.set(i4, null);
                    } else {
                        base64Str = base64Str.replaceFirst(BASE64_PREFIX, "");
                        FileOutputStream out = null;
                        try {
                            try {
                                Path localFile = new Path(path);
                                localFile = localFile.append(this.currentFileNames.get(i4));
                                out = new FileOutputStream(localFile.toOSString());
                                Base64.Decoder decoder = Base64.getDecoder();
                                byte[] imageData = decoder.decode(base64Str);
                                out.write(imageData);
                                ConsoleLogger.print("Saving to: " + localFile.toOSString());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                try {
                                    out.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                break block30;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i4;
            }
        }
        this.currentFileNames.clear();
        return imageStr;
    }

    public String generateModuleRequestJsonString(ModuleBean moduleBean, Boolean isWithValue) {
        JSONArray paramObjectArray = new JSONArray();
        for (ParamGroupBean paramGroupBean : moduleBean.getParamGroups()) {
            for (ParamBean paramBean : paramGroupBean.getParams()) {
                if (paramBean.getKey().equals("modeSwitch") || !paramBean.getIsEnabled().booleanValue()) continue;
                paramObjectArray.add((Object)this.generateSingleParamRequestJsonObject(paramBean, isWithValue));
            }
        }
        if (paramObjectArray.size() == 0) {
            return null;
        }
        return paramObjectArray.toString();
    }

    public String generateModuleRequestJsonString(List<ParamBean> paramBeans, Boolean isWithValue) {
        JSONArray paramObjectArray = new JSONArray();
        for (ParamBean paramBean : paramBeans) {
            if (paramBean.getKey().equals("modeSwitch")) continue;
            paramObjectArray.add((Object)this.generateSingleParamRequestJsonObject(paramBean, isWithValue));
        }
        return paramObjectArray.toString();
    }

    public JSONObject generateSingleParamRequestJsonObject(ParamBean paramBean, Boolean isWithValue) {
        JSONObject paramObject = new JSONObject();
        paramObject.set("category", (Object)paramBean.getCategory());
        paramObject.set("key", (Object)paramBean.getKey());
        if (isWithValue.booleanValue() && paramBean.getValue().getCurrentValue() != null) {
            JSONObject valueObject = new JSONObject();
            valueObject.set("current", paramBean.getValue().getCurrentValue());
            paramObject.set("value", (Object)valueObject);
        }
        return paramObject;
    }

    public void sendWriteModuleDataRequest(ModuleBean moduleBean, SendType sendType) {
        if (moduleBean.isParamCloned()) {
            for (ParamGroupBean paramGroupBean : moduleBean.getParamGroups()) {
                for (ParamBean paramBean : paramGroupBean.getParams()) {
                    if (paramBean.getKey().equals("modeSwitch") || !paramBean.getIsEnabled().booleanValue()) continue;
                    JSONArray paramObjectArray = new JSONArray();
                    paramObjectArray.add((Object)this.generateSingleParamRequestJsonObject(paramBean, true));
                    this.sendWriteModuleDataRequestString(paramObjectArray.toString(), SendType.ALL);
                }
            }
        } else {
            String requestString = this.generateModuleRequestJsonString(moduleBean, (Boolean)true);
            this.sendWriteModuleDataRequestString(requestString, sendType);
        }
    }

    public void sendWriteModuleDataRequestString(String requestString, SendType sendType) {
        if (sendType == SendType.TUNING) {
            ClientHolder.getInstance().sendAsyncLastChangeWriteRequest(requestString, ClientHolder.SET_CONFIG_REQUEST_FAMILY, new ClientHolder.ResponseListener(){

                @Override
                public void success(String response) {
                    System.out.println(response);
                    JSONArray jsonAr = JSONUtil.parseArray((String)response);
                    int i = 0;
                    while (i < jsonAr.size()) {
                        JSONObject paramObj = jsonAr.getJSONObject((Object)i);
                        String key = paramObj.getStr((Object)"key");
                        String message = paramObj.getStr((Object)"message");
                        if (!StrUtil.isEmpty((CharSequence)message)) {
                            ConsoleLogger.printErrorMsg("WriteModuleData Failed: {" + key + " : " + message + "}");
                        }
                        ++i;
                    }
                }

                @Override
                public void failed(String response) {
                }
            });
        } else if (sendType == SendType.ALL) {
            ClientHolder.getInstance().sendAsyncRequest(requestString, new ClientHolder.ResponseListener(){

                @Override
                public void success(String response) {
                    System.out.println(response);
                }

                @Override
                public void failed(String response) {
                }
            });
        }
    }

    public String getExportingSetting(int indent) {
        assert (indent <= 4);
        assert (this.templateSupportModuleBeans != null);
        if (this.currentTemplate == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.set("version", (Object)"1.0.0");
        jsonObject.set("templateName", (Object)this.currentTemplate.getTemplateName());
        jsonObject.set("templateModules", this.getCurrentTemplateModuleBeans());
        return jsonObject.toJSONString(indent);
    }

    public void changeToTemplate(TemplateBean templateBean) {
        this.currentTemplate = templateBean;
        this.templateSupportModuleBeans = new ArrayList<ModuleBean>();
        this.templateModuleBeanMap = new HashMap<String, ModuleBean>();
        List<ModuleBean> allModuleBeans = this.loadAllModuleBeansFromWorkspace();
        for (String moduleName : templateBean.getModules()) {
            Optional<ModuleBean> result = allModuleBeans.stream().filter(e -> e.getModuleName().equals(moduleName)).findAny();
            if (!result.isPresent()) continue;
            ModuleBean moduleBean = result.get();
            this.templateSupportModuleBeans.add(moduleBean);
            String category = moduleBean.getParamGroups().get(0).getParams().get(0).getCategory();
            this.templateModuleBeanMap.put(category, moduleBean);
        }
        this.processCloneParam();
    }

    private List<ModuleBean> loadAllModuleBeansFromWorkspace() {
        IPath jsonPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String jsonFilePath = String.valueOf(jsonPath.toString()) + "/isp_modules.json";
        assert (FileUtil.exist((String)jsonFilePath));
        String fileContent = FileUtil.readString((String)jsonFilePath, (Charset)Charset.forName("UTF-8"));
        List allModuleBeans = JSONUtil.toList((String)fileContent, ModuleBean.class);
        return allModuleBeans;
    }

    public void loadAllSensorBeansFromWorkspace() {
        IPath jsonPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String jsonFilePath = String.valueOf(jsonPath.toString()) + "/isp_sensor.json";
        if (FileUtil.exist((String)jsonFilePath)) {
            String fileContent = FileUtil.readString((String)jsonFilePath, (Charset)Charset.forName("UTF-8"));
            this.allSensorBeans = JSONUtil.toList((String)fileContent, SensorBean.class);
        }
    }

    public String getAllSensorBeansString() {
        String sensorJsonString = this.storageManager.readBundleFile("/res/sensor.json");
        List sensorBeans = JSONUtil.toList((String)sensorJsonString, SensorBean.class);
        return JSONUtil.parseArray((Object)sensorBeans).toJSONString(0);
    }

    public String getAllTemplateModuleBeansString() {
        ArrayList<ModuleBean> allTemplateModuleBeans = new ArrayList<ModuleBean>();
        String moduleJsonString = this.storageManager.readBundleFile("/res/modules.json");
        List allModuleBeans = JSONUtil.toList((String)moduleJsonString, ModuleBean.class);
        HashSet<String> addedModuleNames = new HashSet<String>();
        for (TemplateBean templateBean : this.templateBeans) {
            for (String templateModuleName : templateBean.getModules()) {
                Optional<ModuleBean> result;
                if (addedModuleNames.contains(templateModuleName) || !(result = allModuleBeans.stream().filter(e -> templateModuleName.equals(e.getModuleName())).findAny()).isPresent()) continue;
                ModuleBean moduleBean = result.get();
                allTemplateModuleBeans.add(moduleBean);
                addedModuleNames.add(templateModuleName);
            }
        }
        return JSONUtil.parseArray(allTemplateModuleBeans).toJSONString(0);
    }

    public void importFromExportedSetting(String jsonString) {
        JSONObject jsonObject = new JSONObject((Object)jsonString);
        String templateName = jsonObject.getStr((Object)"templateName");
        boolean found = false;
        for (TemplateBean templateBean : this.templateBeans) {
            if (!templateBean.getTemplateName().equals(templateName)) continue;
            this.currentTemplate = templateBean;
            this.templateSupportModuleBeans = JSONUtil.toList((JSONArray)jsonObject.getJSONArray((Object)"templateModules"), ModuleBean.class);
            found = true;
            break;
        }
        assert (found);
        assert (this.templateSupportModuleBeans != null && this.templateSupportModuleBeans.size() > 0);
        if (this.currentTemplate == null) {
            return;
        }
        this.templateModuleBeanMap = new HashMap<String, ModuleBean>();
        for (ModuleBean moduleBean : this.templateSupportModuleBeans) {
            String category;
            if (moduleBean.getParamGroups() == null || moduleBean.getParamGroups().get(0).getParams() == null || moduleBean.getParamGroups().get(0).getParams().size() <= 0) continue;
            String string = category = moduleBean.getParamGroups().get(0).getParams().get(0).getKey().equals("modeSwitch") ? moduleBean.getParamGroups().get(0).getParams().get(1).getCategory() : moduleBean.getParamGroups().get(0).getParams().get(0).getCategory();
            assert (StrUtil.isNotEmpty((CharSequence)category));
            this.templateModuleBeanMap.put(category, moduleBean);
        }
        this.processCloneParam();
        ConsoleLogger.print(String.valueOf(this.templateSupportModuleBeans.size()) + " modules restored for [" + this.currentTemplate.getTemplateName() + "].");
    }

    private void processCloneParam() {
        this.templateSupportModuleBeans.stream().filter(m -> m.isParamCloned()).forEach(m -> {
            m.getParamGroups().stream().forEach(g -> {
                ArrayList<ParamBean> paramBeans = new ArrayList<ParamBean>();
                for (ParamBean paramBean : g.getParams()) {
                    assert (paramBean.getKey() != null);
                    String cat = paramBean.getCategory();
                    ModuleBean originalModuleBean = this.templateModuleBeanMap.get(cat);
                    if (originalModuleBean == null) continue;
                    ParamBean originalParamBean = originalModuleBean.findParamBeanByKey(paramBean.getKey());
                    if (originalParamBean == null) {
                        System.out.println("WARN: processCloneParam() originalParamBean not found! cat=" + paramBean.getCategory() + ", key=" + paramBean.getKey());
                        continue;
                    }
                    paramBeans.add(originalParamBean);
                }
                g.setParams(paramBeans);
            });
            List<ParamGroupBean> paramGroupBeans = m.getParamGroups().stream().filter(g -> g.getParams().size() > 0).collect(Collectors.toList());
            m.setParamGroups(paramGroupBeans);
        });
    }

    public void updateAMMap() {
        this.aMMap = new HashMap<String, String>();
        for (ModuleBean moduleBean : this.templateSupportModuleBeans) {
            if (!moduleBean.getShowName().startsWith("Auto")) continue;
            this.aMMap.put(moduleBean.getShowName(), null);
        }
        block1: for (String autoName : this.aMMap.keySet()) {
            String manualName = autoName.substring(autoName.indexOf(" ") + 1, autoName.length());
            for (ModuleBean moduleBean : this.templateSupportModuleBeans) {
                if (!moduleBean.getShowName().equals(manualName)) continue;
                this.aMMap.put(autoName, manualName);
                continue block1;
            }
        }
    }

    public void addManualAutoMode() {
        assert (this.aMMap != null);
        for (String autoName : this.aMMap.keySet()) {
            if (this.aMMap.get(autoName) == null) continue;
            String manualName = autoName.substring(autoName.indexOf(" ") + 1, autoName.length());
            ParamBean autoOptionBean = new ParamBean("modeSwitch", "option");
            autoOptionBean.getValue().setOptions(Arrays.asList("Auto Mode", "Manual Mode"));
            autoOptionBean.getValue().setCurrentValue(1);
            this.getModuleBeanByShowName(autoName).getParamGroups().get(0).getParams().add(0, autoOptionBean);
            this.getModuleBeanByShowName(manualName).getParamGroups().get(0).getParams().add(0, autoOptionBean);
        }
    }

    public ModuleBean getModuleBeanByName(String name) {
        if (this.templateSupportModuleBeans == null) {
            return null;
        }
        return this.templateSupportModuleBeans.stream().filter(e -> name.equals(e.getModuleName())).findAny().orElse(null);
    }

    public ModuleBean getModuleBeanByShowName(String name) {
        if (this.templateSupportModuleBeans == null) {
            return null;
        }
        for (ModuleBean moduleBean : this.templateSupportModuleBeans) {
            if (!moduleBean.getShowName().equals(name)) continue;
            return moduleBean;
        }
        return null;
    }

    public Map<String, String> getAutoManualMap() {
        this.updateAMMap();
        return this.aMMap;
    }

    public String sendRegisterRequest(ParamBean paramBean) {
        JSONObject paramObject = new JSONObject();
        paramObject.set("category", (Object)paramBean.getCategory());
        paramObject.set("key", (Object)paramBean.getKey());
        if (paramBean.getValue().getCurrentValue() != null) {
            paramObject.set("value", (Object)paramBean.getValue());
        }
        return ClientHolder.getInstance().sendSyncRequest(paramObject.toString());
    }

    public static enum SendType {
        TUNING,
        BATCHING,
        ALL;

    }
}

