/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.model;

import com.verisilicon.isp.tuning.core.bean.BatchParamBean;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.dao.BatchJobMapper;
import com.verisilicon.isp.tuning.core.dao.BatchTaskMapper;
import com.verisilicon.isp.tuning.core.dao.bean.BatchJob;
import com.verisilicon.isp.tuning.core.dao.bean.BatchTask;
import com.verisilicon.isp.tuning.core.dao.bean.constant.BatchTaskStateConstant;
import com.verisilicon.isp.tuning.core.dao.bean.criteria.BatchTaskCriteria;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.util.ImageFormatConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BatchDataCenter {
    private final Integer MAX_VAR_PARAM_COUNT = 5;
    private static BatchDataCenter batchDataCenter;
    private List<BatchParamBean> batchParamBeans;
    private BatchJobMapper batchJobMapper;
    public BatchTaskMapper batchTaskMapper;
    public SqlSession sqlSession;
    public static int currentJobId;

    public List<BatchJob> getAllRecords() {
        return this.batchJobMapper.selectAllJobs();
    }

    public void deleteJobByPrimaryKey(int id) {
        this.batchJobMapper.deleteByPrimaryKey(id);
    }

    public int getMaxJobId() {
        return this.batchJobMapper.qMaxJobId();
    }

    public void setBatchParamBeans(List<BatchParamBean> batchParamBeans) {
        this.batchParamBeans = batchParamBeans;
    }

    public List<BatchParamBean> getBatchParamBeans() {
        return this.batchParamBeans;
    }

    public static BatchDataCenter getInstance() {
        if (batchDataCenter == null) {
            batchDataCenter = new BatchDataCenter();
            batchDataCenter.init();
        }
        return batchDataCenter;
    }

    private void init() {
        this.batchParamBeans = new ArrayList<BatchParamBean>();
        String path = "/src/resource/mybatis-config.xml";
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        URL url = bundle.getResource(path);
        try {
            InputStream inputStream = FileLocator.toFileURL((URL)url).openStream();
            SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
            SqlSessionFactory factory = builder.build(inputStream);
            builder = null;
            this.sqlSession = factory.openSession();
            this.batchJobMapper = (BatchJobMapper)this.sqlSession.getMapper(BatchJobMapper.class);
            this.batchTaskMapper = (BatchTaskMapper)this.sqlSession.getMapper(BatchTaskMapper.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeDB() {
        if (this.sqlSession != null) {
            this.sqlSession.close();
        }
    }

    public void createTask(Integer jobId, List<Integer> indexArray) {
        BatchTask batchTask = new BatchTask();
        batchTask.setJobId(jobId);
        batchTask.setVarIndexJson(indexArray);
        this.batchTaskMapper.insertSelective(batchTask);
    }

    public void writeJob(BatchJob batchJob) {
        this.batchJobMapper.insertSelective(batchJob);
        this.commit();
    }

    public int getTaskNum(int currentJobId) {
        return this.batchTaskMapper.countAllTask(currentJobId);
    }

    public void updateBatchJob(BatchJob batchJob) {
        this.batchJobMapper.updateByPrimaryKeySelective(batchJob);
        this.commit();
    }

    public void updateBatchTask(BatchTask batchTask) {
        this.batchTaskMapper.updateByPrimaryKeySelective(batchTask);
        this.commit();
    }

    public void commit() {
        assert (this.sqlSession != null);
        this.sqlSession.commit();
    }

    public void createJpg(List<String> images, String jpgImagePath) throws IOException {
        File[] files = new File[images.size()];
        int i = 0;
        while (i < images.size()) {
            files[i] = new File(images.get(i));
            ++i;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("ppm")) {
                if (file.isFile()) {
                    BufferedImage ppmFile = ImageIO.read(file);
                    String name = file.getName();
                    name = name.replaceFirst(".ppm", ".jpg");
                    Thumbnails.of((File[])new File[]{file}).size(ppmFile.getWidth(), ppmFile.getHeight()).outputFormat("jpg").toFile(new File(String.valueOf(jpgImagePath) + "\\" + name));
                }
            } else if (file.getName().endsWith("yuv")) {
                ByteArrayOutputStream os = new ByteArrayOutputStream((int)file.length());
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                byte[] buffer = new byte[1024];
                while (in.read(buffer) > 0) {
                    os.write(buffer);
                }
                byte[] yuvByte = os.toByteArray();
                byte[] rgbByte = new byte[6220800];
                ImageFormatConverter.NV162RGB(yuvByte, 1920, 1080, rgbByte);
                BufferedImage bi = new BufferedImage(1920, 1080, 1);
                bi.setRGB(0, 0, 1920, 1080, ImageFormatConverter.rgb24ToPixel(rgbByte, 1920, 1080), 0, 1920);
                String name = file.getName();
                name = name.replaceFirst(".yuv", ".jpg");
                File outfile = new File(String.valueOf(jpgImagePath) + "\\" + name);
                ImageIO.write((RenderedImage)bi, "jpg", outfile);
            }
            ++n2;
        }
    }

    public BatchTask getOneTask(Integer jobId) {
        BatchTaskCriteria criteria = new BatchTaskCriteria();
        criteria.setJobId(jobId);
        criteria.setState(BatchTaskStateConstant.CREATED);
        BatchTask batchTask = this.batchTaskMapper.selectFirstTaskByCriteria(criteria);
        return batchTask;
    }

    public List<BatchTask> getTaskList(Integer jobId, Integer pageNum, Integer pageSize) {
        List<BatchTask> tasks = this.batchTaskMapper.selectDoneTasksByJobId(jobId, pageNum, pageSize);
        return tasks;
    }

    public int getFinished(Integer jobId) {
        int finNums = this.batchTaskMapper.countFinishedTask(jobId);
        return finNums;
    }

    public int getAll(Integer jobId) {
        int allNums = this.batchTaskMapper.countAllTask(jobId);
        return allNums;
    }

    public BatchJob getJobById(Integer Id) {
        BatchJob batchJob = this.batchJobMapper.selectByPrimaryKey(Id);
        return batchJob;
    }

    public String getPathById(Integer Id) {
        BatchJob batchJob = this.getJobById(Id);
        String path = (String)((Map)batchJob.getConfigJson()).get("path");
        return path;
    }

    public List<ParamBean> getVarParamBeans(List<Integer> indexes) {
        ArrayList<ParamBean> paramBeans = new ArrayList<ParamBean>();
        int i = 0;
        while (i < indexes.size()) {
            BatchParamBean batchParamBean = this.batchParamBeans.get(i);
            ParamBean paramBean = new ParamBean(batchParamBean.getOrigParamBean().getKey(), batchParamBean.getOrigParamBean().getType());
            paramBean.getValue().setCurrentValue(batchParamBean.getBatchValues().get(indexes.get(i)));
            paramBeans.add(paramBean);
            ++i;
        }
        return paramBeans;
    }

    public List<List<Integer>> generateIndexMatrix(List<Integer> paramCountArray) {
        assert (paramCountArray.size() > 0 && paramCountArray.size() <= 5);
        List<List<Integer>> matrix = new ArrayList<List<Integer>>();
        int i = 0;
        while (i < paramCountArray.get(0)) {
            matrix.add(new ArrayList<Integer>(Arrays.asList(i)));
            ++i;
        }
        i = 1;
        while (i < paramCountArray.size()) {
            matrix = this.compose(matrix, paramCountArray.get(i));
            ++i;
        }
        return matrix;
    }

    public List<List<Integer>> generateIndexMatrix(int rawImageNum) {
        assert (rawImageNum > 0);
        ArrayList<List<Integer>> matrix = new ArrayList<List<Integer>>();
        int i = 0;
        while (i < rawImageNum) {
            matrix.add(new ArrayList<Integer>(Arrays.asList(i)));
            ++i;
        }
        return matrix;
    }

    private List<List<Integer>> compose(List<List<Integer>> indexMatrix, Integer newIndexCount) {
        ArrayList<List<Integer>> matrix = new ArrayList<List<Integer>>();
        int i = 0;
        while (i < newIndexCount) {
            int j = 0;
            while (j < indexMatrix.size()) {
                ArrayList<Integer> tempList = new ArrayList<Integer>();
                tempList.addAll((Collection)indexMatrix.get(j));
                tempList.add(i);
                matrix.add(tempList);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public ModuleBean getBatchModuleBean(List<BatchParamBean> batchParamBeans) {
        Object cate;
        ArrayList<List<ParamBean>> batchParamList = new ArrayList<List<ParamBean>>();
        int i = 0;
        while (i < batchParamBeans.size()) {
            ArrayList<ParamBean> paramBeans = new ArrayList<ParamBean>();
            List<Object> batchValues = batchParamBeans.get(i).getBatchValues();
            int j = 0;
            while (j < batchValues.size()) {
                String key = batchParamBeans.get(i).getOrigParamBean().getKey();
                String type = batchParamBeans.get(i).getOrigParamBean().getType();
                ParamBean paramBean = new ParamBean(key, type);
                paramBean.setCategory(batchParamBeans.get(i).getOrigParamBean().getCategory());
                paramBean.getValue().setCurrentValue(batchValues.get(j));
                paramBeans.add(paramBean);
                ++j;
            }
            batchParamList.add(paramBeans);
            ++i;
        }
        ArrayList<List<ParamBean>> resultList = new ArrayList<List<ParamBean>>();
        BatchDataCenter.listRecursive(batchParamList, 0, resultList, new ArrayList<ParamBean>());
        HashMap<String, List<ParamBean>> allModuleMap = new HashMap<String, List<ParamBean>>();
        for (ModuleBean modBean : ModuleDataCenter.getInstance().getCurrentTemplateModuleBeans()) {
            for (ParamGroupBean gropuBean : modBean.getParamGroups()) {
                if (gropuBean.getParams().get(0).getCategory() == null) {
                    allModuleMap.put(gropuBean.getParams().get(1).getCategory(), gropuBean.getParams());
                    continue;
                }
                allModuleMap.put(gropuBean.getParams().get(0).getCategory(), gropuBean.getParams());
            }
        }
        HashMap<Object, List> batchMap = new HashMap<Object, List>();
        int i2 = 0;
        while (i2 < resultList.size()) {
            int j = 0;
            while (j < ((List)resultList.get(i2)).size()) {
                cate = ((ParamBean)((List)resultList.get(i2)).get(j)).getCategory();
                if (allModuleMap.containsKey(((ParamBean)((List)resultList.get(i2)).get(j)).getCategory())) {
                    batchMap.put(cate, (List)allModuleMap.get(cate));
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < resultList.size()) {
            int j = 0;
            while (j < ((List)resultList.get(i2)).size()) {
                cate = ((ParamBean)((List)resultList.get(i2)).get(j)).getCategory();
                List beans = (List)batchMap.get(cate);
                int k = 0;
                while (k < beans.size()) {
                    if (((ParamBean)beans.get(k)).getKey().equals(((ParamBean)((List)resultList.get(i2)).get(j)).getKey())) {
                        beans.set(k, (ParamBean)((List)resultList.get(i2)).get(j));
                    }
                    ++k;
                }
                ++j;
            }
            ((List)resultList.get(i2)).clear();
            for (List batchBeans : batchMap.values()) {
                for (ParamBean bean : batchBeans) {
                    ((List)resultList.get(i2)).add(bean);
                }
            }
            ++i2;
        }
        ModuleBean batchModuleBean = new ModuleBean("Batch Module");
        ArrayList<ParamGroupBean> paramGroupBeans = new ArrayList<ParamGroupBean>();
        int i3 = 0;
        while (i3 < resultList.size()) {
            ParamGroupBean paramGroupBean = new ParamGroupBean("group" + i3);
            paramGroupBean.setParams((List)resultList.get(i3));
            paramGroupBeans.add(paramGroupBean);
            ++i3;
        }
        batchModuleBean.setParamGroups(paramGroupBeans);
        return batchModuleBean;
    }

    private static void listRecursive(List<List<ParamBean>> batchParamList, int pos, List<List<ParamBean>> resultList, List<ParamBean> cacheList) {
        List<ParamBean> list = batchParamList.get(pos);
        int i = 0;
        while (i < list.size()) {
            ArrayList<ParamBean> childCacheList = i == list.size() - 1 ? cacheList : new ArrayList<ParamBean>(cacheList);
            childCacheList.add(list.get(i));
            if (pos == batchParamList.size() - 1) {
                resultList.add(childCacheList);
            } else {
                BatchDataCenter.listRecursive(batchParamList, pos + 1, resultList, childCacheList);
            }
            ++i;
        }
    }

    public void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        File[] fileArray = files = file.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.deleteFile(f);
            } else {
                f.delete();
            }
            ++n2;
        }
        file.delete();
    }
}

