/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.manager;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.setting.Setting;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class StorageManager {
    private static final String PROJECT_STORAGE_FILE = ".dproject";

    public String readProjectFile(IProject project) {
        assert (project != null);
        String filePath = project.getFile((IPath)new Path(PROJECT_STORAGE_FILE)).getLocation().toOSString();
        if (FileUtil.exist((String)filePath)) {
            FileReader fileReader = new FileReader(filePath);
            return fileReader.readString();
        }
        return null;
    }

    public void writeProjectFile(IProject project, String content) {
        assert (project != null);
        IFile file = project.getFile((IPath)new Path(PROJECT_STORAGE_FILE));
        if (file == null || file.getLocation() == null) {
            ConsoleLogger.printErrorMsg("Project file doesn't exist!");
            return;
        }
        String filePath = file.getLocation().toOSString();
        FileWriter fileWriter = new FileWriter(filePath);
        fileWriter.write(content);
    }

    public String readBundleFile(String path) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        URL url = bundle.getResource(path);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int n;
            InputStream input = FileLocator.toFileURL((URL)url).openStream();
            byte[] buffer = new byte[1024];
            while ((n = input.read(buffer)) != -1) {
                outputStream.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toString();
    }

    public static Setting getSettingFromConfigIniFile() {
        IPath iniPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String iniFilePath = String.valueOf(iniPath.toString()) + "/isp_config.ini";
        return new Setting(iniFilePath);
    }
}

