/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.manager;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class EventManager {
    public static final String EVENT_TEMPLATE_CHANGED = "EVENT_TEMPLATE_CHANGED";
    public static final String EVENT_MODULE_CHANGED = "EVENT_MODULE_CHANGED";
    public static final String EVENT_GROUP_CHANGED = "EVENT_GROUP_CHANGED";
    public static final String EVENT_REFRESH_UI = "EVENT_REFRESH_UI";
    public static final String EVENT_PARAM_VALUE_CHANGED = "EVENT_PARAM_VALUE_CHANGED";
    public static final String EVENT_PROJECT_SAVED = "EVENT_PROJECT_SAVED";
    public static final String EVENT_STATUS_UPDATE = "EVENT_STATUS_UPDATE";
    private List<IPropertyChangeListener> listeners = new ArrayList<IPropertyChangeListener>();
    private static EventManager eventManager;

    public static EventManager getInstance() {
        if (eventManager == null) {
            eventManager = new EventManager();
        }
        return eventManager;
    }

    private EventManager() {
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyEvent(String property, Object value) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, null, value);
        this.notifyAllListener(event);
    }

    public void notifyEvent(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
        this.notifyAllListener(event);
    }

    private void notifyAllListener(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }
}

