/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.dao.handler;

import cn.hutool.json.JSONUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class JSONArrayTypeHandler<T>
implements TypeHandler<List<T>> {
    private final Class<T> type;

    public JSONArrayTypeHandler(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
    }

    public void setParameter(PreparedStatement ps, int i, List<T> parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, this.toString(parameter));
    }

    public List<T> getResult(ResultSet rs, String columnName) throws SQLException {
        return this.toObject(rs.getString(columnName));
    }

    public List<T> getResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.toObject(rs.getString(columnIndex));
    }

    public List<T> getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.toObject(cs.getString(columnIndex));
    }

    private String toString(List<T> object) {
        if (object == null) {
            return null;
        }
        return JSONUtil.toJsonStr(object);
    }

    private List<T> toObject(String str) {
        if (str == null) {
            return null;
        }
        return JSONUtil.toList((String)str, this.type);
    }
}

