/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.bean;

import com.verisilicon.isp.tuning.core.bean.ParamBean;
import java.util.Collections;
import java.util.LinkedList;

public class UndoBean {
    private static final Integer MAX_UNDO_COUNT = 10;
    private LinkedList<ModificationBean> undoList = new LinkedList();
    private LinkedList<ModificationBean> redoList = new LinkedList();

    public LinkedList<ModificationBean> getUndoList() {
        return this.undoList;
    }

    public LinkedList<ModificationBean> getRedoList() {
        return this.redoList;
    }

    public Object getFirstRedoByKey(String key) {
        for (ModificationBean bean : this.redoList) {
            if (bean.getNewValue().getKey().compareTo(key) != 0) continue;
            return bean.getNewValue().getValue().getValue();
        }
        return null;
    }

    public Object getLastUndoByKey(String key) {
        int index = -1;
        int currentIndex = 0;
        for (ModificationBean bean : this.undoList) {
            if (bean.getNewValue().getKey().compareTo(key) == 0) {
                index = currentIndex;
            }
            ++currentIndex;
        }
        return index < 0 ? null : this.undoList.get(index).getNewValue().getValue().getValue();
    }

    public void pushUndoValue(ParamBean oldValue, ParamBean newValue) {
        ModificationBean modificationBean = new ModificationBean();
        ModificationBean tempBean = new ModificationBean();
        if (this.redoList.size() > 0) {
            String lastKey = this.redoList.getFirst().getNewValue().getKey();
            tempBean.oldValue = this.redoList.getFirst().getNewValue().clone();
            tempBean.newValue = tempBean.oldValue.clone();
            if (this.getLastUndoByKey(lastKey) != null) {
                tempBean.newValue.getValue().setCurrentValue(this.getLastUndoByKey(lastKey));
            } else {
                tempBean.newValue.getValue().setCurrentValue(tempBean.oldValue.getValue().getValue());
            }
            Collections.reverse(this.redoList);
            while (this.redoList.size() > 0) {
                this.undoList.addLast(this.redoList.getFirst());
                this.redoList.removeFirst();
            }
            this.undoList.addLast(tempBean);
        }
        modificationBean.setOldValue(oldValue);
        modificationBean.setNewValue(newValue);
        this.undoList.addLast(modificationBean);
        if (this.undoList.size() > MAX_UNDO_COUNT) {
            this.undoList.removeFirst();
        }
    }

    public ParamBean popUndoValue() {
        if (this.undoList.size() == 0) {
            return null;
        }
        ModificationBean modificationBean = this.undoList.removeLast();
        this.redoList.addLast(modificationBean);
        if (this.redoList.size() > MAX_UNDO_COUNT) {
            this.redoList.removeFirst();
        }
        return modificationBean.getOldValue();
    }

    public ParamBean popRedoValue() {
        if (this.redoList.size() == 0) {
            return null;
        }
        ModificationBean modificationBean = this.redoList.removeLast();
        this.undoList.addLast(modificationBean);
        if (this.undoList.size() > MAX_UNDO_COUNT) {
            this.undoList.removeFirst();
        }
        return modificationBean.getNewValue();
    }

    public void clear() {
        this.undoList.clear();
        this.redoList.clear();
    }

    public int getUndoLength() {
        return this.undoList.size();
    }

    public int getRedoLength() {
        return this.redoList.size();
    }

    public class ModificationBean {
        ParamBean oldValue;
        ParamBean newValue;

        public ParamBean getOldValue() {
            return this.oldValue;
        }

        public ParamBean getNewValue() {
            return this.newValue;
        }

        public void setOldValue(ParamBean oldValue) {
            this.oldValue = oldValue;
        }

        public void setNewValue(ParamBean newValue) {
            this.newValue = newValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModificationBean)) {
                return false;
            }
            ModificationBean other = (ModificationBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ParamBean this$oldValue = this.getOldValue();
            ParamBean other$oldValue = other.getOldValue();
            if (this$oldValue == null ? other$oldValue != null : !((Object)this$oldValue).equals(other$oldValue)) {
                return false;
            }
            ParamBean this$newValue = this.getNewValue();
            ParamBean other$newValue = other.getNewValue();
            return !(this$newValue == null ? other$newValue != null : !((Object)this$newValue).equals(other$newValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModificationBean;
        }

        public int hashCode() {
            int result = 1;
            ParamBean $oldValue = this.getOldValue();
            result = result * 59 + ($oldValue == null ? 43 : ((Object)$oldValue).hashCode());
            ParamBean $newValue = this.getNewValue();
            result = result * 59 + ($newValue == null ? 43 : ((Object)$newValue).hashCode());
            return result;
        }

        public String toString() {
            return "UndoBean.ModificationBean(oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ")";
        }
    }
}

