/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.bean;

import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.bean.UndoBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ModuleBean {
    private String moduleName;
    private String label;
    private List<ParamGroupBean> paramGroups;
    private transient Map<String, ParamBean> paramBeanMap;
    private transient UndoBean undoBean;
    private transient List<ParamGroupBean> paramGroupsSet1;
    private transient List<ParamGroupBean> paramGroupsSet2;
    private boolean isParamCloned = false;
    private boolean isHide = false;
    public static final Set<String> enableKeySet = new HashSet<String>(){
        {
            this.add("enable");
            this.add("isEnable");
            this.add("driverLoad");
            this.add("isDriverLoad");
            this.add("deMosaicEnable");
            this.add("expandEnable");
            this.add("isTnr");
        }
    };

    public ModuleBean() {
        this.undoBean = new UndoBean();
    }

    public ModuleBean(String name) {
        this.moduleName = name;
    }

    public ParamBean findParamBeanByKey(String keyName) {
        if (this.paramBeanMap == null) {
            this.paramBeanMap = new HashMap<String, ParamBean>();
            for (ParamGroupBean paramGroupBean : this.paramGroups) {
                paramGroupBean.getParams().stream().forEach(o -> this.paramBeanMap.put(o.getKey(), (ParamBean)o));
            }
        }
        return this.paramBeanMap.get(keyName);
    }

    public Boolean getModuleEnable() {
        Optional<String> result = enableKeySet.stream().filter(e -> {
            ParamBean paramBean = this.findParamBeanByKey((String)e);
            return paramBean != null;
        }).findFirst();
        if (result.isPresent()) {
            ParamBean paramBean = this.findParamBeanByKey(result.get());
            if (paramBean.getValue() == null || paramBean.getValue().getValue() == null) {
                return true;
            }
            if (paramBean.getValue().getValue() instanceof Boolean) {
                return (Boolean)paramBean.getValue().getValue();
            }
            return new Boolean((Integer)paramBean.getValue().getValue() == 1);
        }
        return true;
    }

    private List<ParamGroupBean> cloneParamGroupBeans(List<ParamGroupBean> groupBeans) {
        ArrayList<ParamGroupBean> newParamGroups = new ArrayList<ParamGroupBean>();
        for (ParamGroupBean paramGroupBean : groupBeans) {
            ParamGroupBean newParamGroupBean = paramGroupBean.clone();
            newParamGroups.add(newParamGroupBean);
        }
        return newParamGroups;
    }

    public Boolean hasSetData(int setIndex) {
        assert (setIndex == 1 || setIndex == 2);
        return setIndex == 1 ? this.paramGroupsSet1 != null : this.paramGroupsSet2 != null;
    }

    public void saveToSet(int setIndex) {
        assert (setIndex == 1 || setIndex == 2);
        List<ParamGroupBean> newParamGroups = this.cloneParamGroupBeans(this.paramGroups);
        if (setIndex == 1) {
            this.paramGroupsSet1 = newParamGroups;
        } else {
            this.paramGroupsSet2 = newParamGroups;
        }
    }

    public void loadFromSet(int setIndex) {
        assert (setIndex == 1 || setIndex == 2);
        List<ParamGroupBean> newParamGroups = this.cloneParamGroupBeans(setIndex == 1 ? this.paramGroupsSet1 : this.paramGroupsSet2);
        this.paramGroups = newParamGroups;
        this.paramBeanMap = null;
    }

    public String getShowName() {
        if (this.label == null || this.label.length() == 0) {
            return this.moduleName;
        }
        return this.label;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getLabel() {
        return this.label;
    }

    public List<ParamGroupBean> getParamGroups() {
        return this.paramGroups;
    }

    public Map<String, ParamBean> getParamBeanMap() {
        return this.paramBeanMap;
    }

    public UndoBean getUndoBean() {
        return this.undoBean;
    }

    public List<ParamGroupBean> getParamGroupsSet1() {
        return this.paramGroupsSet1;
    }

    public List<ParamGroupBean> getParamGroupsSet2() {
        return this.paramGroupsSet2;
    }

    public boolean isParamCloned() {
        return this.isParamCloned;
    }

    public boolean isHide() {
        return this.isHide;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setParamGroups(List<ParamGroupBean> paramGroups) {
        this.paramGroups = paramGroups;
    }

    public void setParamBeanMap(Map<String, ParamBean> paramBeanMap) {
        this.paramBeanMap = paramBeanMap;
    }

    public void setUndoBean(UndoBean undoBean) {
        this.undoBean = undoBean;
    }

    public void setParamGroupsSet1(List<ParamGroupBean> paramGroupsSet1) {
        this.paramGroupsSet1 = paramGroupsSet1;
    }

    public void setParamGroupsSet2(List<ParamGroupBean> paramGroupsSet2) {
        this.paramGroupsSet2 = paramGroupsSet2;
    }

    public void setParamCloned(boolean isParamCloned) {
        this.isParamCloned = isParamCloned;
    }

    public void setHide(boolean isHide) {
        this.isHide = isHide;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleBean)) {
            return false;
        }
        ModuleBean other = (ModuleBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isParamCloned() != other.isParamCloned()) {
            return false;
        }
        if (this.isHide() != other.isHide()) {
            return false;
        }
        String this$moduleName = this.getModuleName();
        String other$moduleName = other.getModuleName();
        if (this$moduleName == null ? other$moduleName != null : !this$moduleName.equals(other$moduleName)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        List<ParamGroupBean> this$paramGroups = this.getParamGroups();
        List<ParamGroupBean> other$paramGroups = other.getParamGroups();
        return !(this$paramGroups == null ? other$paramGroups != null : !((Object)this$paramGroups).equals(other$paramGroups));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModuleBean;
    }

    public int hashCode() {
        int result = 1;
        result = result * 59 + (this.isParamCloned() ? 79 : 97);
        result = result * 59 + (this.isHide() ? 79 : 97);
        String $moduleName = this.getModuleName();
        result = result * 59 + ($moduleName == null ? 43 : $moduleName.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        List<ParamGroupBean> $paramGroups = this.getParamGroups();
        result = result * 59 + ($paramGroups == null ? 43 : ((Object)$paramGroups).hashCode());
        return result;
    }

    public String toString() {
        return "ModuleBean(moduleName=" + this.getModuleName() + ", label=" + this.getLabel() + ", paramGroups=" + this.getParamGroups() + ", paramBeanMap=" + this.getParamBeanMap() + ", undoBean=" + this.getUndoBean() + ", paramGroupsSet1=" + this.getParamGroupsSet1() + ", paramGroupsSet2=" + this.getParamGroupsSet2() + ", isParamCloned=" + this.isParamCloned() + ", isHide=" + this.isHide() + ")";
    }
}

