/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.algo;

import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.algo.IParamCallback;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import java.math.BigDecimal;
import java.util.ArrayList;

public class GammaCurve
implements IParamCallback {
    @Override
    public Object process(ModuleBean moduleBean, String callbackValue) {
        return this.generateCurve(moduleBean, callbackValue);
    }

    public Object generateCurve(ModuleBean moduleBean, String curveName) {
        JSONArray pointsArray = new JSONArray();
        ParamBean gammaParamBean = moduleBean.findParamBeanByKey("standardVal");
        if (gammaParamBean.getValue().getValue() == null) {
            return null;
        }
        BigDecimal gamma = new BigDecimal(gammaParamBean.getValue().getValue().toString()).setScale((int)gammaParamBean.getValue().getDecimals(), 1);
        ParamBean curvePxParamBean = moduleBean.findParamBeanByKey("curvePx");
        JSONArray pxArray = new JSONArray(curvePxParamBean.getValue().getValue());
        double xRange = 0.0;
        int i = 0;
        while (i < pxArray.size()) {
            if (pxArray.get(i) instanceof BigDecimal) {
                xRange += Math.pow(2.0, ((BigDecimal)pxArray.get(i)).doubleValue());
            } else if (pxArray.get(i) instanceof Integer) {
                xRange += Math.pow(2.0, ((Integer)pxArray.get(i)).doubleValue());
            }
            ++i;
        }
        int x = 0;
        double c = 0.0;
        int i2 = 0;
        while (i2 < 64) {
            JSONArray point = new JSONArray();
            if (pxArray.get(i2) instanceof BigDecimal) {
                x += (int)Math.pow(2.0, ((BigDecimal)pxArray.get(i2)).doubleValue());
            } else if (pxArray.get(i2) instanceof Integer) {
                x += (int)Math.pow(2.0, ((Integer)pxArray.get(i2)).intValue());
            }
            c = Math.min(xRange, (double)x) / xRange;
            c = gamma.compareTo(BigDecimal.ZERO) == 0 ? 0.0 : Math.pow(c, 1.0 / gamma.doubleValue());
            double y = Math.min(1023.0, c * 1024.0);
            point.add((Object)new BigDecimal(x).setScale(0, 1));
            point.add((Object)new BigDecimal(y).setScale(0, 5));
            pointsArray.add((Object)point);
            ++i2;
        }
        ParamBean curevYParamBean = moduleBean.findParamBeanByKey("curve");
        ArrayList<BigDecimal> curveY = new ArrayList<BigDecimal>();
        int i3 = 0;
        while (i3 < pointsArray.size()) {
            curveY.add((BigDecimal)pointsArray.getJSONArray((Object)i3).get(1));
            ++i3;
        }
        curevYParamBean.getValue().setCurrentValue(curveY);
        return pointsArray;
    }

    @Override
    public Object process(ModuleBean moduleBean, String callbackValue, int index) {
        return null;
    }
}

