/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.algo;

import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import java.math.BigDecimal;

public class CurveYBase {
    public JSONArray generateCurve(ModuleBean moduleBean, String curveName, JSONArray xArray) {
        int[] x = new int[xArray.size()];
        int i = 0;
        while (i < xArray.size()) {
            if (xArray.get(i) instanceof BigDecimal) {
                String str = xArray.get(i).toString();
                x[i] = Integer.parseInt(str);
            } else {
                Integer temp = (Integer)xArray.get(i);
                x[i] = temp;
            }
            ++i;
        }
        return this.generateCurve(moduleBean, curveName, x);
    }

    public JSONArray generateCurve(ModuleBean moduleBean, String curveName, int[] x) {
        JSONArray pointsArray = new JSONArray();
        ParamBean curveParamBean = moduleBean.findParamBeanByKey(curveName);
        JSONArray pointYArray = (JSONArray)curveParamBean.getValue().getValue();
        if (pointYArray == null) {
            return null;
        }
        int i = 0;
        while (i < x.length) {
            JSONArray point = new JSONArray();
            point.add((Object)new BigDecimal(x[i]).setScale(0, 1));
            Object yObject = pointYArray.get(i);
            if (yObject instanceof Integer) {
                Integer y = (Integer)yObject;
                point.add((Object)new BigDecimal(y));
            } else if (yObject instanceof BigDecimal) {
                point.add((Object)((BigDecimal)yObject));
            } else if (yObject instanceof Double) {
                String str = yObject.toString();
                BigDecimal y = new BigDecimal(str).setScale((int)curveParamBean.getValue().getDecimals(), 1);
                point.add((Object)y);
            } else assert (false);
            pointsArray.add((Object)point);
            ++i;
        }
        return pointsArray;
    }
}

