/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.algo;

import com.verisilicon.isp.tuning.core.algo.AutoEeCaCurve;
import com.verisilicon.isp.tuning.core.algo.AutoEeDciCurve;
import com.verisilicon.isp.tuning.core.algo.AutoGammaCurve;
import com.verisilicon.isp.tuning.core.algo.AutoGtmUserCurve;
import com.verisilicon.isp.tuning.core.algo.AutoTwoDnrLumaCurve;
import com.verisilicon.isp.tuning.core.algo.CpdExpandCurve;
import com.verisilicon.isp.tuning.core.algo.DpfNoiseCurve;
import com.verisilicon.isp.tuning.core.algo.EeCaCurve;
import com.verisilicon.isp.tuning.core.algo.EeDciCurve;
import com.verisilicon.isp.tuning.core.algo.GammaCurve;
import com.verisilicon.isp.tuning.core.algo.GtmUserCurve;
import com.verisilicon.isp.tuning.core.algo.IParamCallback;
import com.verisilicon.isp.tuning.core.algo.TwoDnrLumaCurve;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import java.util.HashMap;
import java.util.Map;

public class CallbackManager {
    private static CallbackManager callbackManagerInstance = null;
    private static Map<String, IParamCallback> callbackMap;

    public static CallbackManager getInstance() {
        if (callbackManagerInstance == null) {
            callbackManagerInstance = new CallbackManager();
        }
        return callbackManagerInstance;
    }

    private CallbackManager() {
        this.init();
    }

    private void init() {
        callbackMap = new HashMap<String, IParamCallback>();
        callbackMap.put("GC_2.curve", new GammaCurve());
        callbackMap.put("DPF.noiseCurve", new DpfNoiseCurve());
        callbackMap.put("EE_2.caCurve", new EeCaCurve());
        callbackMap.put("EE_2.dciCurve", new EeDciCurve());
        callbackMap.put("GTM.userCurve", new GtmUserCurve());
        callbackMap.put("2DNR_5_2.lumaCurveY", new TwoDnrLumaCurve());
        callbackMap.put("CPD_1_1.expandCurveY", new CpdExpandCurve());
        callbackMap.put("A2DNR_5_2.:lumaCurveY", new AutoTwoDnrLumaCurve());
        callbackMap.put("AEE_2.:caCurve", new AutoEeCaCurve());
        callbackMap.put("AEE_2.:dciCurve", new AutoEeDciCurve());
        callbackMap.put("AGTM.:userCurve", new AutoGtmUserCurve());
        callbackMap.put("AGC_2.:curve", new AutoGammaCurve());
    }

    public static Object processCallback(ModuleBean moduleBean, String category, String key) {
        IParamCallback callback = callbackMap.get(String.valueOf(category) + '.' + key);
        if (callback == null) {
            return null;
        }
        return callback.process(moduleBean, key);
    }

    public static Object processCallback(ModuleBean moduleBean, String category, String key, int index) {
        IParamCallback callback = callbackMap.get(String.valueOf(category) + '.' + key);
        if (callback == null) {
            return null;
        }
        return callback.process(moduleBean, key, index);
    }
}

