/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.core.algo;

import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.algo.IParamCallback;
import com.verisilicon.isp.tuning.core.algo.TableCurveBase;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import java.math.BigDecimal;

public class AutoGammaCurve
extends TableCurveBase
implements IParamCallback {
    private static final int[] LOG_CURVE_X = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 64, 64, 64, 64, 64};

    @Override
    public Object process(ModuleBean moduleBean, String callbackValue) {
        return null;
    }

    @Override
    public Object process(ModuleBean moduleBean, String callbackValue, int index) {
        JSONArray pointsArray = new JSONArray();
        ParamBean gammaParamBean = moduleBean.findParamBeanByKey(":standardVal");
        JSONArray gammaTable = (JSONArray)gammaParamBean.getValue().getValue();
        if (gammaTable == null) {
            return null;
        }
        BigDecimal gamma = new BigDecimal(gammaTable.get(index).toString()).setScale((int)gammaParamBean.getValue().getDecimals(), 1);
        String xScale = "Logarithmic";
        int x = 0;
        double c = 0.0;
        int i = 1;
        while (i <= 64) {
            JSONArray point = new JSONArray();
            if (xScale.equals("Equidistant")) {
                point.add((Object)new BigDecimal(i * 16).setScale(0, 1));
                c = (double)Math.min(1024, i * 16) / 1024.0;
            } else if (xScale.equals("Logarithmic")) {
                point.add((Object)new BigDecimal(x += LOG_CURVE_X[i - 1]));
                c = (double)Math.min(1024, x) / 1024.0;
            }
            c = gamma.compareTo(BigDecimal.ZERO) == 0 ? 0.0 : Math.pow(c, 1.0 / gamma.doubleValue());
            double y = Math.min(1023.0, c * 1024.0);
            point.add((Object)new BigDecimal(y).setScale(0, 1));
            pointsArray.add((Object)point);
            ++i;
        }
        return pointsArray;
    }
}

